/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.SqlUiService;
import com.intellij.database.actions.RefreshSchemaAction;
import com.intellij.database.actions.diagnostic.DiagnosticRefresh;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/diagnostic/DiagnosticRefresh;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "diagnosticRefresh", "Lcom/intellij/database/util/AsyncTask;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "elementsToRefresh", "", "Lcom/intellij/database/psi/DbElement;", "rebuildDdlDataSource", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "refresh", "subscribeReady", "update", "Companion", "DiagnosticFormatter", "intellij.database.impl"})
public final class DiagnosticRefresh
extends DumbAwareAction {
    private static final Logger LOG;
    private static final Set<DatabaseGlobalAuditService.BlockType> considerBlockTypes;
    @NotNull
    public static final String timeSpace = "  ";
    @NotNull
    public static final String timeIndent = "          ";
    @NotNull
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
        DbDataSource dbDataSource = (DbDataSource)selection.map((Function)actionPerformed.dataSource.1.INSTANCE).first();
        if (dbDataSource == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"selection.map { obj: DbE\u2026ource }.first() ?: return");
        DbDataSource dataSource2 = dbDataSource;
        String string = dataSource2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.uniqueId");
        String dataSourceId = string;
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        Disposable disposable3 = disposable2;
        try {
            Path logFile = Files.createTempDirectory("introspection", new FileAttribute[0]).resolve("introspector.%u.%g.log");
            FileHandler handler = new FileHandler(((Object)logFile).toString(), 0x200000, 10, false);
            handler.setLevel(Level.ALL);
            handler.setFormatter(DiagnosticFormatter.INSTANCE);
            handler.setFilter(new Filter(dataSourceId){
                final /* synthetic */ String $dataSourceId;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isLoggable(@Nullable LogRecord record) {
                    if (!(record instanceof DatabaseGlobalAuditService.DatabaseLogRecord)) return false;
                    if (!Intrinsics.areEqual((Object)((DatabaseGlobalAuditService.DatabaseLogRecord)record).getDataSourceId(), (Object)this.$dataSourceId)) return false;
                    if (!(record instanceof DatabaseGlobalAuditService.DatabaseLogBlockRecord)) return true;
                    DatabaseGlobalAuditService.Block[] blockArray = ((DatabaseGlobalAuditService.DatabaseLogBlockRecord)record).getBlocks();
                    boolean bl = false;
                    DatabaseGlobalAuditService.Block[] blockArray2 = blockArray;
                    boolean bl2 = false;
                    if (blockArray2.length != 0) return true;
                    return false;
                }
                {
                    this.$dataSourceId = string;
                }
            });
            DatabaseGlobalAuditService.Companion.attach(handler, disposable3);
            Function0 function0 = (Function0)new Function0<Unit>(handler){

                public final void invoke() {
                    ((FileHandler)this.receiver).close();
                }
            };
            Disposer.register((Disposable)disposable3, (Disposable)new Disposable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void dispose() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            });
            Level level = Level.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.ALL");
            DatabaseGlobalAuditService.Companion.setRootLevel(level, disposable3);
            Set set = selection.filter(new Condition(dataSource2){
                final /* synthetic */ DbDataSource $dataSource;

                public final boolean value(@NotNull DbElement o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    return o.getDataSource() == this.$dataSource;
                }
                {
                    this.$dataSource = dbDataSource;
                }
            }).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"selection.filter { o: Db\u2026 === dataSource }.toSet()");
            Set elementsToRefresh2 = set;
            this.diagnosticRefresh(dataSource2, elementsToRefresh2).whenComplete(null, new BiConsumer(disposable3, logFile){
                final /* synthetic */ Disposable $disposable;
                final /* synthetic */ Path $logFile;

                public final void accept(@Nullable Object $noName_0, @Nullable Throwable $noName_1) {
                    Disposer.dispose((Disposable)this.$disposable);
                    RevealFileAction.openFile((Path)this.$logFile);
                }
                {
                    this.$disposable = disposable2;
                    this.$logFile = path;
                }
            });
        }
        catch (Throwable th) {
            LOG.error(th);
            Disposer.dispose((Disposable)disposable3);
        }
    }

    private final AsyncTask<?> diagnosticRefresh(DbDataSource dataSource2, Set<? extends DbElement> elementsToRefresh2) {
        SqlDataSource sqlDs2 = DbImplUtil.getMaybeSqlDataSource(dataSource2);
        if (sqlDs2 != null) {
            return this.refresh(sqlDs2, dataSource2);
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = RefreshSchemaAction.refresh(dataSource2, (Collection<DbElement>)elementsToRefresh2);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"refresh(dataSource, elementsToRefresh)");
        return asyncTask;
    }

    private final AsyncTask<?> refresh(SqlDataSource sqlDs2, DbDataSource dataSource2) {
        AsyncTask.Frame frame = AsyncTask.Companion.frame("Diagnostic refresh: " + sqlDs2.getName());
        Project project = dataSource2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dataSource.project");
        AsyncTask.Companion.withBgIndicator(frame, project, null, true);
        return frame.wrap(null, (Function0)new Function0<CompletionStage<Unit>>(this, dataSource2, sqlDs2){
            final /* synthetic */ DiagnosticRefresh this$0;
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ SqlDataSource $sqlDs;

            @NotNull
            public final CompletionStage<Unit> invoke() {
                Project project = this.$dataSource.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dataSource.project");
                return DiagnosticRefresh.access$rebuildDdlDataSource(this.this$0, project, this.$sqlDs);
            }
            {
                this.this$0 = diagnosticRefresh;
                this.$dataSource = dbDataSource;
                this.$sqlDs = sqlDataSource;
                super(0);
            }
        });
    }

    private final CompletableFuture<Unit> rebuildDdlDataSource(Project project, SqlDataSource sqlDs2) {
        Object object = WriteAction.compute((ThrowableComputable)new ThrowableComputable(this, sqlDs2, project){
            final /* synthetic */ DiagnosticRefresh this$0;
            final /* synthetic */ SqlDataSource $sqlDs;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final CompletableFuture<Unit> compute() {
                void var2_1;
                void $this$mapTo$iv$iv;
                List list = this.$sqlDs.getSqlFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlDs.sqlFiles");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    SqlFile sqlFile = (SqlFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    FileViewProvider fileViewProvider = v1.getViewProvider();
                    Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"it.viewProvider");
                    VirtualFile virtualFile = fileViewProvider.getVirtualFile();
                    collection.add(virtualFile);
                }
                List files2 = (List)destination$iv$iv;
                CompletableFuture res2 = DiagnosticRefresh.access$subscribeReady(this.this$0, this.$project, this.$sqlDs);
                FileContentUtilCore.reparseFiles((Collection)files2);
                Collection $this$toTypedArray$iv = files2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
                if (virtualFileArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
                this.$sqlDs.setUrls(this.$sqlDs.getUrls());
                this.$sqlDs.getModel();
                return var2_1;
            }
            {
                this.this$0 = diagnosticRefresh;
                this.$sqlDs = sqlDataSource;
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.compute<Comp\u2026lDs.model\n      res\n    }");
        return (CompletableFuture)object;
    }

    private final CompletableFuture<Unit> subscribeReady(Project project, SqlDataSource sqlDs2) {
        ProgressIndicator indicator;
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        Disposable disposable3 = disposable2;
        CompletableFuture<Unit> res2 = new CompletableFuture<Unit>();
        res2.whenComplete(new BiConsumer(disposable3){
            final /* synthetic */ Disposable $disposable;

            public final void accept(Unit $noName_0, Throwable $noName_1) {
                Disposer.dispose((Disposable)this.$disposable);
            }
            {
                this.$disposable = disposable2;
            }
        });
        ProgressIndicator progressIndicator = indicator = ProgressManager.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.ProgressIndicatorEx");
        }
        ((ProgressIndicatorEx)progressIndicator).addStateDelegate((ProgressIndicatorEx)new SqlUiService.DummyProgressIndicator(res2){
            final /* synthetic */ CompletableFuture $res;

            public void cancel() {
                this.$res.completeExceptionally(new ProcessCanceledException());
            }
            {
                this.$res = $captured_local_variable$0;
            }
        });
        SqlDataSource sqlDataSource = sqlDs2;
        if (sqlDataSource == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.SimpleModificationTracker");
        }
        SimpleModificationTracker tracker = (SimpleModificationTracker)sqlDataSource;
        long sc = tracker.getModificationCount();
        project.getMessageBus().connect(disposable3).subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener(sqlDs2, sc, tracker, res2){
            final /* synthetic */ SqlDataSource $sqlDs;
            final /* synthetic */ long $sc;
            final /* synthetic */ SimpleModificationTracker $tracker;
            final /* synthetic */ CompletableFuture $res;

            public final void onChanged(@Nullable DbDataSource it2) {
                if (this.$sqlDs.isReady() && this.$sc != this.$tracker.getModificationCount()) {
                    this.$res.complete(Unit.INSTANCE);
                }
            }
            {
                this.$sqlDs = sqlDataSource;
                this.$sc = l;
                this.$tracker = simpleModificationTracker;
                this.$res = completableFuture;
            }
        });
        return res2;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            v0 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"e.dataContext");
            dataContext = v0;
            selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
            if (selection.isEmpty()) ** GOTO lbl-1000
            $this$none$iv = (Iterable)selection;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v1 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (DbElement)element$iv;
                    $i$a$-none-DiagnosticRefresh$update$enabled$1 = false;
                    v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    var11_10 = DbImplUtil.getMaybeLocalDataSource(v2.getDataSource());
                    var12_11 = false;
                    var13_12 = false;
                    ds = var11_10;
                    $i$a$-let-DiagnosticRefresh$update$enabled$1$1 = false;
                    v3 = ds != null && (ds.isLoading() || !DbImplUtilCore.canConnectTo(ds));
                    if (!v3) continue;
                    v1 = false;
                    break block5;
                }
                v1 = true;
            }
        }
        if (v1) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        enabled = v4;
        v5 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"e.presentation");
        v5.setVisible(enabled != false || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) != false || e.isFromActionToolbar() != false);
        v6 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"e.presentation");
        v6.setEnabled(enabled);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(DiagnosticRefresh.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(DiagnosticRefresh::class.java)");
        LOG = logger2;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)DatabaseGlobalAuditService.BlockType.STATEMENT, (Enum)DatabaseGlobalAuditService.BlockType.EXECUTION_DURATION, (Enum)DatabaseGlobalAuditService.BlockType.FETCHING_DURATION, (Enum)DatabaseGlobalAuditService.BlockType.WARNING, (Enum)DatabaseGlobalAuditService.BlockType.ERROR);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(\n        Bloc\u2026  BlockType.ERROR\n      )");
        considerBlockTypes = enumSet;
    }

    public static final /* synthetic */ CompletableFuture access$rebuildDdlDataSource(DiagnosticRefresh $this, Project project, SqlDataSource sqlDs2) {
        return $this.rebuildDdlDataSource(project, sqlDs2);
    }

    public static final /* synthetic */ CompletableFuture access$subscribeReady(DiagnosticRefresh $this, Project project, SqlDataSource sqlDs2) {
        return $this.subscribeReady(project, sqlDs2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010\n\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u000f\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/actions/diagnostic/DiagnosticRefresh$DiagnosticFormatter;", "Ljava/util/logging/Formatter;", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "formatTime", "instant", "Ljava/time/Instant;", "appendTrimmed", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "str", "", "insertLinePrefix", "prefix", "fromIndex", "", "tillIndex", "toStr2", "intellij.database.impl"})
    public static final class DiagnosticFormatter
    extends Formatter {
        @NotNull
        public static final DiagnosticFormatter INSTANCE;

        @Override
        @NotNull
        public String format(@NotNull LogRecord record) {
            String string;
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            StringBuilder b2 = new StringBuilder();
            String timeStr = this.formatTime(record.getInstant());
            b2.append(timeStr).append(DiagnosticRefresh.timeSpace);
            boolean was = false;
            LogRecord logRecord = record;
            if (logRecord instanceof DatabaseGlobalAuditService.DatabaseLogBlockRecord) {
                int p1 = b2.length();
                for (DatabaseGlobalAuditService.Block block : ((DatabaseGlobalAuditService.DatabaseLogBlockRecord)record).getBlocks()) {
                    String text2 = block.getText();
                    Object object = text2;
                    boolean bl = false;
                    if (object.length() == 0) continue;
                    object = block.getType();
                    if (object == DatabaseGlobalAuditService.BlockType.STATEMENT) {
                        b2.append("Executing query:");
                        b2.append("\n-- 8< --\n");
                        this.appendTrimmed(b2, text2);
                        b2.append("\n-- >8 --\n");
                        was = true;
                        continue;
                    }
                    if (!considerBlockTypes.contains(object)) continue;
                    this.appendTrimmed(b2, text2).append('\n');
                    was = true;
                }
                this.insertLinePrefix(b2, DiagnosticRefresh.timeIndent, p1, b2.length() - 1);
            } else if (logRecord instanceof DatabaseGlobalAuditService.DatabaseLogRecord) {
                String msg;
                String string2 = msg = ((DatabaseGlobalAuditService.DatabaseLogRecord)record).getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"msg");
                this.appendTrimmed(b2, string2);
                DiagnosticFormatter.insertLinePrefix$default(this, b2, DiagnosticRefresh.timeIndent, 0, 0, 6, null);
                b2.append('\n');
                CharSequence charSequence = msg;
                boolean bl = false;
                boolean bl2 = was = charSequence.length() > 0;
            }
            if (was) {
                String string3 = b2.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"b.toString()");
            } else {
                string = "";
            }
            return string;
        }

        private final String formatTime(Instant instant) {
            ZonedDateTime time;
            if (instant == null) {
                return "        ";
            }
            ZonedDateTime zonedDateTime = time = instant.atZone(ZoneId.systemDefault());
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"time");
            String h = this.toStr2(zonedDateTime.getHour());
            String m = this.toStr2(time.getMinute());
            String s2 = this.toStr2(time.getSecond());
            return h + ':' + m + ':' + s2;
        }

        private final StringBuilder appendTrimmed(StringBuilder $this$appendTrimmed, CharSequence str) {
            int n;
            int b2 = 0;
            for (n = str.length(); n > 0 && CharsKt.isWhitespace((char)str.charAt(n - 1)); --n) {
            }
            while (b2 < n && CharsKt.isWhitespace((char)str.charAt(b2))) {
                ++b2;
            }
            $this$appendTrimmed.append(str, b2, n);
            return $this$appendTrimmed;
        }

        /*
         * WARNING - void declaration
         */
        private final StringBuilder insertLinePrefix(StringBuilder $this$insertLinePrefix, String prefix, int fromIndex, int tillIndex) {
            int n = tillIndex - 1;
            int n2 = fromIndex;
            if (n >= n2) {
                while (true) {
                    void i2;
                    if ($this$insertLinePrefix.charAt((int)i2) == '\n') {
                        $this$insertLinePrefix.insert((int)(i2 + true), prefix);
                    }
                    if (i2 == n2) break;
                    --i2;
                }
            }
            return $this$insertLinePrefix;
        }

        static /* synthetic */ StringBuilder insertLinePrefix$default(DiagnosticFormatter diagnosticFormatter, StringBuilder stringBuilder, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = stringBuilder.length();
            }
            return diagnosticFormatter.insertLinePrefix(stringBuilder, string, n, n2);
        }

        private final String toStr2(int $this$toStr2) {
            String string;
            if ($this$toStr2 < 10) {
                char c2 = '0';
                String string2 = String.valueOf($this$toStr2);
                boolean bl = false;
                string = String.valueOf(c2) + string2;
            } else {
                string = String.valueOf($this$toStr2);
            }
            return string;
        }

        private DiagnosticFormatter() {
        }

        static {
            DiagnosticFormatter diagnosticFormatter;
            INSTANCE = diagnosticFormatter = new DiagnosticFormatter();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/diagnostic/DiagnosticRefresh$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "considerBlockTypes", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "timeIndent", "", "timeSpace", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

