/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.BooleanCliArgument;
import com.intellij.database.cli.argument.BooleanCliArgumentImpl;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.argument.StringCliArgumentImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class CommonPgCliArguments {
    public static final DefaultValueCliArgument F_DIRECTORY = new DefaultValueCliArgumentImpl.Parameterized(DatabaseBundle.messagePointer("database.cli.integration.pg.common.directory", new Object[0]), CommonPgArguments.FORMAT, CommonPgArguments.DIR_FORMAT);
    public static final DefaultValueCliArgument F_TAR = new DefaultValueCliArgumentImpl.Parameterized(DatabaseBundle.messagePointer("database.cli.integration.pg.common.tar.archive", new Object[0]), CommonPgArguments.FORMAT, CommonPgArguments.TAR_FORMAT);
    public static final DefaultValueCliArgument F_CUSTOM = new DefaultValueCliArgumentImpl.Parameterized(DatabaseBundle.messagePointer("database.cli.integration.pg.common.custom.archive", new Object[0]), CommonPgArguments.FORMAT, CommonPgArguments.CUSTOM_FORMAT);
    public static final BooleanCliArgument CLEAN = new BooleanCliArgumentImpl(DatabaseBundle.messagePointer("database.cli.integration.pg.common.clean.database", new Object[0]), CommonPgArguments.CLEAN_DATABASE);
    public static final BooleanCliArgument CREATE = new BooleanCliArgumentImpl(DatabaseBundle.messagePointer("database.cli.integration.pg.common.create.database", new Object[0]), CommonPgArguments.CREATE_DATABASE);
    public static final BooleanCliArgument IF_EXISTS = new BooleanCliArgumentImpl(DatabaseBundle.messagePointer("database.cli.integration.pg.common.add.if.exists", new Object[0]), "--if-exists");
    public static final BooleanCliArgument DATA_ONLY = new BooleanCliArgumentImpl(DatabaseBundle.messagePointer("database.cli.integration.pg.common.data.only", new Object[0]), CommonPgArguments.DATA_ONLY);
    public static final StringCliArgument DATABASE = new StringCliArgumentImpl.MaybeUnnamedArgument(DatabaseBundle.messagePointer("database.cli.integration.database", new Object[0]), DasUtil.byKind(ObjectKind.DATABASE), CommonPgArguments.DB_NAME);
    public static final StringCliArgument TABLES = new StringCliArgumentImpl((Supplier)DatabaseBundle.messagePointer("database.cli.integration.tables", new Object[0]), CommonPgArguments.TABLE){

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
            if (elements == null) {
                1.$$$reportNull$$$0(0);
            }
            if (cd == null) {
                1.$$$reportNull$$$0(1);
            }
            List<String> list = DbCliUtil.getTablesNames(elements);
            if (list == null) {
                1.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/argument/CommonPgCliArguments$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/argument/CommonPgCliArguments$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringsFromElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringsFromElements";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final StringCliArgument SCHEMAS = new StringCliArgumentImpl.ElementsStringArgument((Supplier)DatabaseBundle.messagePointer("database.cli.integration.schemas", new Object[0]), DasUtil.byKind(ObjectKind.SCHEMA), CommonPgArguments.SCHEMA){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function2 = DbCliUtil::pgQuote;
            if (function2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return function2;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> unquoter = super.getUnquoter();
            Function<String, String> function2 = s2 -> StringUtil.unquoteString((String)((String)unquoter.apply((String)s2)));
            if (function2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/cli/argument/CommonPgCliArguments$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuoter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnquoter";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    private CommonPgCliArguments() {
    }
}

