/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.TypeConversionHelper;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Domain {
    public static final Domain EMPTY = new Domain(ConversionPoint.UNKNOWN, PhysicalDomainType.UNKNOWN, ""){

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality cardinality = Cardinality.EMPTY;
            if (cardinality == null) {
                1.$$$reportNull$$$0(0);
            }
            return cardinality;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                1.$$$reportNull$$$0(1);
            }
            Compatibility compatibility = Compatibility.incompatible();
            if (compatibility == null) {
                1.$$$reportNull$$$0(2);
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o) {
            if (o == null) {
                1.$$$reportNull$$$0(3);
            }
            return o;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cardinality";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final ConversionPoint myPoint;
    private final PhysicalDomainType myDomainType;
    private final String myName;
    private OperationSupport myOperationSupport;
    private TypeConversionHelper myTypeConversionHelper;
    private Condition<@NotNull Version> myVersionSupport;

    protected Domain(@NotNull ConversionPoint point, @NotNull PhysicalDomainType type, @NotNull String name) {
        if (point == null) {
            Domain.$$$reportNull$$$0(0);
        }
        if (type == null) {
            Domain.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Domain.$$$reportNull$$$0(2);
        }
        this.myTypeConversionHelper = TypeConversionHelper.DEFAULT_TYPE_CONVERSION_HELPER;
        this.myVersionSupport = null;
        this.myPoint = point;
        this.myDomainType = type;
        this.myName = name;
        this.myOperationSupport = OperationSupport.DEFAULT_OPERATION_SUPPORT;
    }

    @NotNull
    public Domain withOperationSupport(@NotNull OperationSupport operationSupport) {
        if (operationSupport == null) {
            Domain.$$$reportNull$$$0(3);
        }
        this.myOperationSupport = operationSupport;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(4);
        }
        return domain;
    }

    @NotNull
    public Domain withVersion(@Nullable Condition<@NotNull Version> versionSupport) {
        this.myVersionSupport = versionSupport;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(5);
        }
        return domain;
    }

    @NotNull
    public OperationSupport getOperationSupport() {
        OperationSupport operationSupport = this.myOperationSupport;
        if (operationSupport == null) {
            Domain.$$$reportNull$$$0(6);
        }
        return operationSupport;
    }

    @NotNull
    public Domain withTypeConversionHelper(@NotNull TypeConversionHelper helper) {
        if (helper == null) {
            Domain.$$$reportNull$$$0(7);
        }
        this.myTypeConversionHelper = helper;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(8);
        }
        return domain;
    }

    public TypeConversionHelper getTypeConversionHelper() {
        return this.myTypeConversionHelper;
    }

    @NotNull
    public PhysicalDomainType getDomainType() {
        PhysicalDomainType physicalDomainType = this.myDomainType;
        if (physicalDomainType == null) {
            Domain.$$$reportNull$$$0(9);
        }
        return physicalDomainType;
    }

    @NotNull
    public ConversionPoint getPoint() {
        ConversionPoint conversionPoint = this.myPoint;
        if (conversionPoint == null) {
            Domain.$$$reportNull$$$0(10);
        }
        return conversionPoint;
    }

    public boolean contains(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(11);
        }
        return this.getCompatibility(domain).isCanContains();
    }

    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(12);
        }
        Domain domain2 = this;
        if (domain2 == null) {
            Domain.$$$reportNull$$$0(13);
        }
        return domain2;
    }

    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            Domain.$$$reportNull$$$0(14);
        }
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(15);
        }
        return domain;
    }

    @NotNull
    public String name() {
        String string = this.simpleName();
        if (string == null) {
            Domain.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String simpleName() {
        String string = this.myName;
        if (string == null) {
            Domain.$$$reportNull$$$0(17);
        }
        return string;
    }

    public String toString() {
        return this.myName + " " + this.getPoint() + " " + this.getDomainType();
    }

    public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
        if (descriptor2 == null) {
            Domain.$$$reportNull$$$0(18);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myName, (CharSequence)descriptor2.getTypeName());
    }

    public boolean supportedIn(@Nullable Version version) {
        return this.myVersionSupport == null || version == null || this.myVersionSupport.value((Object)version);
    }

    public final boolean supports(@NotNull Operation operation) {
        if (operation == null) {
            Domain.$$$reportNull$$$0(19);
        }
        return this.getOperationSupport().supportsOperation(this, operation);
    }

    @NotNull
    public LogicalType getLogicType() {
        LogicalType logicalType = this.getPoint().getLogicalType();
        if (logicalType == null) {
            Domain.$$$reportNull$$$0(20);
        }
        return logicalType;
    }

    @NotNull
    public abstract Cardinality cardinality();

    @NotNull
    public abstract Compatibility getCompatibility(@NotNull Domain var1);

    @Nullable
    public abstract Object trim(@NotNull Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSupport";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withOperationSupport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSupport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withTypeConversionHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withOperationSupport";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withTypeConversionHelper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

