/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.ui.BeforeConnectionStepsPanel;
import com.intellij.database.dataSource.ui.HardViewport;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlDialectSpecificCodeStyleScheme;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private final DataSourceConfigurable myConfigurable;
    private JBScrollPane myRoot;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private ComboBox<SchemaControl> mySwitchControlBox;
    private JBCheckBox mySingleDatabase;
    private ComboBox<@NlsSafe String> myCodeStyleComboBox;
    private JBCheckBox mySingleConnectionCheckBox;
    private JBCheckBox myCheckOutdatedCheckBox;
    private JBCheckBox myKeepAliveEnable;
    private JBTextField myKeepAliveTimeout;
    private JBCheckBox myAutoCloseEnable;
    private EditorTextField myInitScript;
    private JBTextField myAutoCloseTimeout;
    private JBCheckBox myAutoSyncCheckBox;
    private JBCheckBox myReadOnlyCheckBox;
    private JPanel myTxControlPanel;
    private JPanel myTxControlHolder;
    private TextFieldWithAutoCompletion<String> myTimeZoneField;
    private JLabel myTimeZoneLabel;
    private JBCheckBox myUseMiniCat;
    private TextFieldWithBrowseButton myExternalModelData;
    private BeforeConnectionStepsPanel myBeforeRunStepsPanel;
    private final DataSourceGeneralPanel.MyTxIsolationSelector mySelector;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(0);
        }
        this.mySelector = new DataSourceGeneralPanel.MyTxIsolationSelector();
        this.myConfigurable = configurable;
        this.$$$setupUI$$$();
        this.myExternalModelData.addBrowseFolderListener(DatabaseBundle.message("DataSourceConfigurable.choose.external.model.data", new Object[0]), null, configurable.getProject(), FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml"));
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message("data.source.settings.options.source.loading.none", new Object[0]), value2 -> DataSourceOptionsPanel.getSourceLoadingComboText(value2)));
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message("data.source.settings.options.schema.switch.auto", new Object[0]), value2 -> DataSourceOptionsPanel.getSchemaSwitchComboText(value2)));
        LocalDataSource dataSource2 = (LocalDataSource)this.myConfigurable.getDataSource();
        Dbms dbms = dataSource2.getDbms();
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dbms);
        boolean tzVisible = ExecutionEnvironmentHelper.EP.forDbms(dbms).getTimeZoneManager().canChange();
        this.myTimeZoneField.setVisible(tzVisible);
        this.myTimeZoneLabel.setVisible(tzVisible);
        this.mySingleDatabase.setVisible(JdbcUrlParserUtil.isDatabaseBounded(dataSource2));
        new ExpandableEditorSupport(this.myInitScript);
        DatabaseDialogsHelper.setTextFieldLanguage(this.myInitScript, DbSqlUtilCore.getSqlDialect(dataSource2));
        this.myKeepAliveEnable.addActionListener(this::update);
        this.myAutoCloseEnable.addActionListener(this::update);
        this.myCodeStyleComboBox.setModel(DataSourceOptionsPanel.createCodeStyleComboBox(dialect));
        JComponent txComponent = DbUIUtil.createActionComponent((AnAction)new DataSourceGeneralPanel.DataSourceTxModeAction(this.mySelector, dbms), (JComponent)this.myRoot);
        this.myTxControlPanel.setLayout(new BorderLayout());
        this.myTxControlPanel.add((Component)txComponent, "Center");
        this.myTxControlHolder.setVisible(DataSourceUtil.isTransactionsSupported(dbms));
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        new UiNotifyConnector((Component)this.myRoot, new Activatable(){

            public void showNotify() {
                DatabaseDialogsHelper.setTextFieldLanguage(DataSourceOptionsPanel.this.myInitScript, DbSqlUtilCore.getSqlDialect(DataSourceOptionsPanel.this.myConfigurable.getTempDataSource()));
            }
        });
    }

    public static ComboBoxModel<String> createCodeStyleComboBox(@Nullable SqlLanguageDialect dialect) {
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List regularSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        List<SqlDialectSpecificCodeStyleScheme> specificSchemes = DataSourceOptionsPanel.listSpecificSchemes(dialect);
        for (CodeStyleScheme codeStyleScheme : regularSchemes) {
            codeStyleNamesModel.add((Object)codeStyleScheme.getName());
        }
        for (CodeStyleScheme codeStyleScheme : specificSchemes) {
            codeStyleNamesModel.add((Object)codeStyleScheme.getName());
        }
        return codeStyleNamesModel;
    }

    private static List<SqlDialectSpecificCodeStyleScheme> listSpecificSchemes(@Nullable SqlLanguageDialect dialect) {
        if (dialect == null) {
            return Collections.emptyList();
        }
        List schemes = SqlCodeStyles.listSpecificSchemes().filter(s2 -> s2.getApplicableDialect() == dialect).filter(s2 -> DataSourceOptionsPanel.checkScheme((CodeStyleScheme)s2, dialect)).toList();
        return schemes;
    }

    private static Boolean checkScheme(@NotNull CodeStyleScheme scheme, @NotNull SqlLanguageDialect dialect) {
        CodeStyleSettings container;
        SqlCodeStyleSettings sql;
        if (scheme == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(1);
        }
        if (dialect == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(2);
        }
        return (sql = SqlCodeStyles.pickSqlSettingsIfExists((CodeStyleSettings)(container = scheme.getCodeStyleSettings()), (SqlLanguageDialect)dialect)) != null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static String getSchemaSwitchComboText(@NotNull SchemaControl value2) {
        if (value2 == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(3);
        }
        String string = value2 == SchemaControl.AUTOMATIC ? DatabaseBundle.message("data.source.settings.options.schema.switch.auto", new Object[0]) : (value2 == SchemaControl.MANUAL ? DatabaseBundle.message("data.source.settings.options.schema.switch.manual", new Object[0]) : DatabaseBundle.message("data.source.settings.options.schema.switch.disabled", new Object[0]));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static String getSourceLoadingComboText(@NotNull DBIntrospectionOptions.SourceLoading value2) {
        if (value2 == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(5);
        }
        String string = value2 == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES ? DatabaseBundle.message("data.source.settings.options.source.loading.all", new Object[0]) : (value2 == DBIntrospectionOptions.SourceLoading.USER_SOURCES ? DatabaseBundle.message("data.source.settings.options.source.loading.all.excl.system", new Object[0]) : DatabaseBundle.message("data.source.settings.options.source.loading.none", new Object[0]));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void createUIComponents() {
        this.myRoot = new HardViewport.ScrollPane();
        this.myInitScript = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
        this.myInitScript.setPreferredWidth(JBUI.scale((int)200));
        this.myBeforeRunStepsPanel = new BeforeConnectionStepsPanel(this.myConfigurable.getProject());
        ExecutionEnvironmentHelper.TimeZoneManager manager = ExecutionEnvironmentHelper.EP.forDbms(((LocalDataSource)this.myConfigurable.getDataSource()).getDbms()).getTimeZoneManager();
        Collection<String> zones = manager.getAvailableTimeZones();
        TimeZoneCompletionProvider zonesProvider = new TimeZoneCompletionProvider(zones);
        this.myTimeZoneField = new TextFieldWithAutoCompletion(this.myConfigurable.getProject(), (TextFieldWithAutoCompletionListProvider)zonesProvider, !zones.isEmpty(), "");
        this.myTimeZoneField.setPreferredWidth(this.computePreferredWidth(ZoneId.getAvailableZoneIds()));
    }

    private int computePreferredWidth(@NotNull Collection<String> zones) {
        if (zones == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(7);
        }
        int maxLength = Integer.MIN_VALUE;
        String maxZone = null;
        for (String zone : zones) {
            if (zone.length() <= maxLength) continue;
            maxLength = zone.length();
            maxZone = zone;
        }
        this.myTimeZoneField.setText(maxZone);
        this.myTimeZoneField.ensureWillComputePreferredSize();
        return this.myTimeZoneField.getPreferredSize().width;
    }

    private void update(ActionEvent ignore) {
        this.myKeepAliveTimeout.setEnabled(this.myKeepAliveEnable.isSelected());
        this.myAutoCloseTimeout.setEnabled(this.myAutoCloseEnable.isSelected());
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(8);
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    public void saveData(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(9);
        }
        dataSource2.setAutoCommit(this.mySelector.isAuto());
        dataSource2.setTxIsolation(this.mySelector.getIsolation().getIsolation());
        dataSource2.setAutoSynchronize(this.myAutoSyncCheckBox.isSelected());
        dataSource2.setReadOnly(this.myReadOnlyCheckBox.isSelected());
        dataSource2.getSchemaMapping().setUseMiniCat(this.myUseMiniCat.isSelected());
        dataSource2.setRewriteBounds(!this.mySingleDatabase.isSelected());
        dataSource2.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.notNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        dataSource2.setSchemaControl((SchemaControl)((Object)ObjectUtils.notNull((Object)((Object)((SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()))), (Object)((Object)SchemaControl.AUTOMATIC))));
        dataSource2.setCodeStyleName(StringUtil.nullize((String)((String)this.myCodeStyleComboBox.getSelectedItem()), (String)"Default"));
        dataSource2.setSingleConnection(this.mySingleConnectionCheckBox.isSelected());
        dataSource2.setCheckOutdated(this.myCheckOutdatedCheckBox.isSelected());
        dataSource2.setInitScript(this.myInitScript.getText());
        dataSource2.setKeepAlive(this.myKeepAliveEnable.isSelected());
        dataSource2.setAutoClose(this.myAutoCloseEnable.isSelected());
        dataSource2.setKeepAliveTimeout(StringUtil.parseInt((String)this.myKeepAliveTimeout.getText(), (int)0));
        dataSource2.setAutoCloseTimeout(StringUtil.parseInt((String)this.myAutoCloseTimeout.getText(), (int)0));
        dataSource2.setTimeZone(StringUtil.nullize((String)StringUtil.trim((String)this.myTimeZoneField.getText()), (boolean)true));
        dataSource2.getBeforeTasks().clear();
        dataSource2.getBeforeTasks().addAll(DataSourceUtil.storeBeforeTasks(this.myBeforeRunStepsPanel.getTasks()));
        DataSourceOptionsPanel.put(dataSource2.getAdditionalProperties(), "EXTERNAL_DATA_PATH", StringUtil.nullize((String)this.myExternalModelData.getText(), (boolean)true));
    }

    private static <K, V> void put(Map<K, V> m, K k, V v) {
        if (v == null) {
            m.remove(k);
        } else {
            m.put(k, v);
        }
    }

    public void reset(LocalDataSource dataSource2) {
        this.mySelector.toggle(null, dataSource2.isAutoCommit());
        this.mySelector.select(TxIsolation.of(dataSource2.getTxIsolation()), null);
        this.myAutoSyncCheckBox.setSelected(dataSource2.isAutoSynchronize());
        this.myReadOnlyCheckBox.setSelected(dataSource2.isReadOnly());
        this.mySourceLoading.setSelectedItem((Object)dataSource2.getSourceLoading());
        this.mySwitchControlBox.setSelectedItem((Object)dataSource2.getSchemaControl());
        this.myUseMiniCat.setSelected(dataSource2.getSchemaMapping().isUseMiniCat());
        this.mySingleDatabase.setSelected(!dataSource2.isRewriteBounds());
        this.myCodeStyleComboBox.setSelectedItem((Object)StringUtil.notNullize((String)dataSource2.getCodeStyleName(), (String)"Default"));
        this.mySingleConnectionCheckBox.setSelected(dataSource2.isSingleConnection());
        this.myCheckOutdatedCheckBox.setSelected(dataSource2.shouldCheckOutdated());
        this.myCheckOutdatedCheckBox.setEnabled(DBIntrospectorFactory.isOutdatedCheckSupported(dataSource2.getDbms(), false, null));
        this.myCheckOutdatedCheckBox.setToolTipText(this.myCheckOutdatedCheckBox.isEnabled() ? null : DatabaseBundle.message("data.source.settings.options.outdated.check.unsupported", new Object[0]));
        this.myInitScript.setText(dataSource2.getInitScript());
        this.myKeepAliveEnable.setSelected(dataSource2.isKeepAlive());
        this.myAutoCloseEnable.setSelected(dataSource2.isAutoClose());
        this.myKeepAliveTimeout.setText(String.valueOf(dataSource2.getKeepAliveTimeout()));
        this.myAutoCloseTimeout.setText(String.valueOf(dataSource2.getAutoCloseTimeout()));
        this.myTimeZoneField.setText(StringUtil.notNullize((String)dataSource2.getTimeZone()));
        this.myExternalModelData.setText(StringUtil.notNullize((String)dataSource2.getAdditionalProperties().get("EXTERNAL_DATA_PATH")));
        ConsoleRunConfiguration runConfiguration = ConsoleRunConfiguration.newConfiguration(this.myConfigurable.getProject());
        this.myBeforeRunStepsPanel.doReset(DataSourceUtil.instantiateBeforeTasks(runConfiguration, dataSource2.getBeforeTasks()));
        this.update(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zones";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaSwitchComboText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLoadingComboText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSwitchComboText";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceLoadingComboText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computePreferredWidth";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox2;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        ComboBox comboBox3;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox7;
        JBTextField jBTextField2;
        JBCheckBox jBCheckBox8;
        this.createUIComponents();
        JBScrollPane jBScrollPane = this.myRoot;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.connection.title"), (int)0, (int)0, null, null));
        this.myKeepAliveEnable = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.keep.alive.label"));
        jPanel4.add((Component)jBCheckBox8, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myKeepAliveTimeout = jBTextField2 = new JBTextField();
        jPanel4.add((Component)jBTextField2, new GridConstraints(5, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("DataSourceOptionsPanel.sec"));
        jPanel4.add((Component)jBLabel, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseEnable = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.auto.disconnect.label"));
        jPanel4.add((Component)jBCheckBox7, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseTimeout = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(6, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(5, 4, 1, 1, 0, 1, 2, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("DataSourceOptionsPanel.sec"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(6, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.switch.schema.label"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox3 = new ComboBox();
        jPanel4.add((Component)comboBox3, new GridConstraints(2, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.startup.script.label"));
        jPanel4.add((Component)jLabel3, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myInitScript;
        jPanel4.add((Component)editorTextField2, new GridConstraints(8, 1, 1, 4, 0, 1, 3, 0, null, null, null));
        this.myReadOnlyCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.read.onlyl.label"));
        jPanel4.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySingleConnectionCheckBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.single.connection.mode.label"));
        jPanel4.add((Component)jBCheckBox5, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySingleDatabase = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.single.dataase.mode.label"));
        jPanel4.add((Component)jBCheckBox4, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTxControlHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.transaction.control.label"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTxControlPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myTimeZoneLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.time.zone.label"));
        jPanel4.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithAutoCompletion<String> textFieldWithAutoCompletion = this.myTimeZoneField;
        jPanel4.add((Component)textFieldWithAutoCompletion, new GridConstraints(3, 1, 1, 4, 8, 0, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.other.title"), (int)0, (int)0, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.code.style.label"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeStyleComboBox = comboBox2 = new ComboBox();
        comboBox2.setEnabled(true);
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.editor.url.label.Introspection.title"), (int)0, (int)0, null, null));
        this.myCheckOutdatedCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.warn.outdated.label"));
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel6.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.auto.sync.label"));
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.load.sources.label"));
        jPanel6.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseMiniCat = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.pre.introspected.label"));
        jPanel6.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("data.source.external.data.label"));
        jPanel6.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExternalModelData = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceOptionsPanel.class).getString("before.connection"), (int)0, (int)0, null, null));
        BeforeConnectionStepsPanel beforeConnectionStepsPanel = this.myBeforeRunStepsPanel;
        jPanel7.add((Component)beforeConnectionStepsPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel2.setLabelFor((Component)comboBox3);
        jLabel3.setLabelFor((Component)editorTextField2);
        jLabel.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox2);
        jBLabel4.setLabelFor((Component)comboBox);
        jLabel5.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class TimeZonePrefixMatcher
    extends PlainPrefixMatcher {
        private final MinusculeMatcher myMatcher;

        TimeZonePrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(0);
            }
            super(prefix);
            this.myMatcher = NameUtil.buildMatcher((String)prefix).build();
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(1);
            }
            return super.prefixMatches(name) || this.myMatcher.matches(name);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(2);
            }
            return new TimeZonePrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel$TimeZonePrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TimeZoneCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider {
        TimeZoneCompletionProvider(@NotNull Collection<String> variants) {
            if (variants == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(0);
            }
            super(variants, null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(1);
            }
            return new TimeZonePrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel$TimeZoneCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPrefixMatcher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

