/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTrackerProject;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcChangesTrackerApplication
extends DbSrcChangesTracker {
    private final DbSrcFileStatus myFileStatus = new DbSrcFileStatus();
    private final Set<VirtualFile> myDirtyFiles = new HashSet<VirtualFile>();
    private final Alarm myAlarm = new Alarm();
    private final AtomicReference<Disposable> myAdded = new AtomicReference();
    private final DocumentListener myListener = new DocumentListener(){
        private final FileDocumentManager documentManager = FileDocumentManager.getInstance();

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile file;
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if (DbSrcUtilsCore.isDbSrcFile(file = this.documentManager.getFile(event.getDocument()))) {
                DbSrcChangesTrackerApplication.this.fileDirty(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$1", "documentChanged"));
        }
    };

    public DbSrcChangesTrackerApplication() {
        super(null);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                HashSet<Project> projects = new HashSet<Project>();
                for (VFileEvent vFileEvent : events) {
                    Ref<Project> project;
                    if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                    DbSrcChangesTrackerApplication.this.fileDirty(vFileEvent.getFile());
                    if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent) || (project = DbSrcUtils.getProject(vFileEvent.getPath())) == null) continue;
                    projects.add((Project)project.get());
                }
                if (!projects.isEmpty()) {
                    DbSrcChangesTrackerApplication.updateIndexLater(projects, null, "VFS Changes in dbSrc:// file system");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$2", "after"));
            }
        });
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                DbSrcChangesTrackerApplication.this.ensureListenerAdded();
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                    DbSrcChangesTrackerApplication.this.ensureListenerRemoved();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (ProjectUtil.getOpenProjects().length > 0) {
            this.ensureListenerAdded();
        }
        appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new DbSrcChangesTracker.DbSrcDataSourceListener(this));
        this.validate(null);
    }

    public void validate(@Nullable Project project) {
        VirtualFile root2 = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, null, null, null, null));
        this.fileDirty(root2);
    }

    public void ensureListenerAdded() {
        Disposable disposable2;
        if (this.myAdded.get() == null && this.myAdded.compareAndSet(null, disposable2 = Disposer.newDisposable())) {
            Disposer.register((Disposable)this, (Disposable)disposable2);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, disposable2);
        }
    }

    public void ensureListenerRemoved() {
        Disposable disposable2 = this.myAdded.getAndSet(null);
        if (disposable2 != null) {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileDirty(@Nullable VirtualFile file) {
        if (!DbSrcUtilsCore.isDbSrcFile(file)) {
            return;
        }
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            this.myDirtyFiles.add(file);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this::update, 1000, ModalityState.defaultModalityState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<VirtualFile> files2;
        Set<VirtualFile> set = this.myDirtyFiles;
        synchronized (set) {
            files2 = new ArrayList<VirtualFile>(this.myDirtyFiles);
            this.myDirtyFiles.clear();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.distributeUpdates(files2));
    }

    @Override
    public void distributeUpdates(List<VirtualFile> files2) {
        MultiMap byProject = MultiMap.create();
        for (VirtualFile file : files2) {
            Ref<Project> p2 = DbSrcUtils.getProject(file.getPath());
            if (p2 == null) continue;
            byProject.putValue((Object)((Project)p2.get()), (Object)file);
        }
        if (byProject.containsKey(null)) {
            this.updateFiles(byProject.get(null));
            for (Iterator<Object> iterator : ProjectManager.getInstance().getOpenProjects()) {
                DbSrcChangesTracker.getInstance(iterator).updateFiles(byProject.get(iterator));
            }
        } else {
            for (Map.Entry entry : byProject.entrySet()) {
                if (!((Project)entry.getKey()).isOpen()) continue;
                DbSrcChangesTracker.getInstance((Project)entry.getKey()).updateFiles((Collection)entry.getValue());
            }
        }
    }

    @Override
    @NotNull
    public DbSrcFileStatus getFileStatus() {
        DbSrcFileStatus dbSrcFileStatus = this.myFileStatus;
        if (dbSrcFileStatus == null) {
            DbSrcChangesTrackerApplication.$$$reportNull$$$0(0);
        }
        return dbSrcFileStatus;
    }

    private static void updateIndexLater(@NotNull Set<Project> projects, @Nullable Runnable extra, @NotNull String indexingReason) {
        if (projects == null) {
            DbSrcChangesTrackerApplication.$$$reportNull$$$0(1);
        }
        if (indexingReason == null) {
            DbSrcChangesTrackerApplication.$$$reportNull$$$0(2);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            Collection<Object> toProcess = projects.contains(null) ? Arrays.asList(ProjectUtil.getOpenProjects()) : projects;
            for (Project project : toProcess) {
                if (project.isDisposed() || ProjectManagerImpl.isLight((Project)project)) continue;
                ((DbSrcChangesTrackerProject)DbSrcChangesTrackerApplication.getInstance(project)).updateIndex(indexingReason);
            }
            if (extra != null) {
                extra.run();
            }
        }, app.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTrackerApplication";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateIndexLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

