/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.history.VersionedFileSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcFileSystem
extends DbSrcFileSystemCore
implements VersionedFileSystem {
    public static final String PROTOCOL = "dbSrc";
    public static final FileAttributes DEFAULT_FOLDER_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false, SystemInfo.isFileSystemCaseSensitive ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE);

    public static DbSrcFileSystem getInstance() {
        return (DbSrcFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DbSrcFileSystem() {
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(null));
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            private volatile boolean appRegistered;

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.appRegistered) {
                    this.appRegistered = true;
                    DbSrcFileSystem.this.refreshProjectStorage(null);
                }
                DbSrcFileSystem.this.refreshProjectStorage(project);
                project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(project));
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbSrcFileSystem.this.refreshProjectStorage(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    void refreshProjectStorage(@Nullable Project project) {
        Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, (String)DbSrcFileSystem.getProjectPath(project));
        NewVirtualFile vfile = (NewVirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
        if (vfile != null) {
            VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
        }
    }

    @NotNull
    public static String getProjectPath(@Nullable Project project) {
        return DbSrcFileSystem.getDataSourcePath(project, null);
    }

    @NotNull
    public static String getDataSourcePath(@Nullable Project project, @Nullable String dsId) {
        return DbSrcFileSystem.getPathFromNormalized(project, dsId, null, DbSrcFileSystemCore.ItemType.FOLDER);
    }

    @NotNull
    public static String getPath(@Nullable Project project, @Nullable String dsId, @Nullable DasObject object, @Nullable CasingProvider provider, @Nullable DbSrcFileSystemCore.ItemType type) {
        ObjectPath path = object != null && object.getKind() == ObjectKind.ROOT ? null : ObjectPaths.of(object, provider);
        return DbSrcFileSystem.getPathFromNormalized(project, dsId, path, (DbSrcFileSystemCore.ItemTypeOrFolder)type);
    }

    @NotNull
    public static String getPathFromNormalized(@Nullable Project project, @Nullable String dsId, @Nullable ObjectPath object, @Nullable DbSrcFileSystemCore.ItemTypeOrFolder type) {
        return DbSrcFileSystem.getPathFromNormalized(DbSrcUtils.getProjectId(project), dsId, object, type);
    }

    @NotNull
    public static String getPathFromNormalized(@NotNull String projectId, @Nullable String dsId, @Nullable ObjectPath object, @Nullable DbSrcFileSystemCore.ItemTypeOrFolder type) {
        if (projectId == null) {
            DbSrcFileSystem.$$$reportNull$$$0(0);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(projectId);
        if (dsId != null) {
            builder.append("/").append(dsId);
            if (object != null) {
                DbSrcFileSystem.appendPath(builder, object);
                DbSrcFileSystem.appendExt(builder, type);
            }
        }
        String string = builder.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getPathFromNormalized(@NotNull String projectId, @NotNull String dsId, @Nullable ObjectPath object, @NotNull ObjectKind group) {
        if (projectId == null) {
            DbSrcFileSystem.$$$reportNull$$$0(2);
        }
        if (dsId == null) {
            DbSrcFileSystem.$$$reportNull$$$0(3);
        }
        if (group == null) {
            DbSrcFileSystem.$$$reportNull$$$0(4);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(projectId);
        builder.append("/").append(dsId);
        if (object != null) {
            DbSrcFileSystem.appendPath(builder, object);
        }
        DbSrcFileSystem.appendKind(builder, group);
        String string = builder.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void appendPath(@NotNull StringBuilder builder, @NotNull ObjectPath object) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(6);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(7);
        }
        if (object.parent != null) {
            DbSrcFileSystem.appendPath(builder, object.parent);
        }
        DbSrcFileSystem.appendObj(builder, object);
    }

    private static void appendObj(@NotNull StringBuilder builder, @NotNull ObjectPath object) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(8);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(9);
        }
        DbSrcFileSystem.appendKind(builder, object.kind).append("/");
        DbSrcFileSystem.appendName(builder, object, null);
    }

    @NotNull
    private static StringBuilder appendKind(@NotNull StringBuilder builder, ObjectKind kind) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(10);
        }
        StringBuilder stringBuilder = builder.append("/").append(DbSrcFileSystem.escapeGroup(kind.code()));
        if (stringBuilder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    public static String getFileName(@NotNull ObjectPath object, @Nullable DbSrcFileSystemCore.ItemTypeOrFolder type) {
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(12);
        }
        return DbSrcFileSystem.appendName(new StringBuilder(), object, type).toString();
    }

    private static StringBuilder appendName(@NotNull StringBuilder builder, @NotNull ObjectPath object, @Nullable DbSrcFileSystemCore.ItemTypeOrFolder type) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(13);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(14);
        }
        builder.append(DbSrcFileSystem.escapeName(object.name));
        String identity = object.getIdentity();
        if (identity != null) {
            builder.append("@").append(DbSrcFileSystem.escapeName(identity));
        }
        DbSrcFileSystem.appendExt(builder, type);
        return builder;
    }

    private static void appendExt(@NotNull StringBuilder builder, @Nullable DbSrcFileSystemCore.ItemTypeOrFolder type) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(15);
        }
        if (type instanceof DbSrcFileSystemCore.ItemType) {
            builder.append(((DbSrcFileSystemCore.ItemType)type).ext);
        }
    }

    public static boolean isOriginalFilePath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(16);
        }
        return DbSrcFileSystemCore.ItemType.ORIG.is(path);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(17);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        StringBuilder res2;
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(18);
        }
        String string = (res2 = DbSrcFileSystem.processPath(path, new DbSrcFileSystemCore.ItemProcessor<StringBuilder>(){

            @Override
            public StringBuilder processProject(@Nullable Project project) {
                return new StringBuilder(project == null ? "Application" : project.getName());
            }

            @Override
            public StringBuilder processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalDataSource source = DbSrcUtils.findDataSource(project, dataSourceId);
                return this.processProject(project).append(File.separator).append(source == null ? dataSourceId : source.getName());
            }

            @Override
            public StringBuilder processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                StringBuilder res2 = this.processPath(project, dataSourceId, path);
                if (group != null) {
                    res2.append(File.separator).append(group);
                }
                return res2;
            }

            @Override
            public StringBuilder processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(4);
                }
                StringBuilder res2 = this.processPath(project, dataSourceId, path);
                if (type == DbSrcFileSystemCore.ItemType.ORIG) {
                    res2.append("[orig]");
                } else if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
                    res2.append("[base]");
                }
                return res2;
            }

            public StringBuilder processPath(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(5);
                }
                StringBuilder res2 = this.processDataSource(project, dataSourceId);
                return this.processObject(res2, path);
            }

            public StringBuilder processObject(@NotNull StringBuilder res2, @Nullable ObjectPath path) {
                if (res2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (path == null) {
                    return res2;
                }
                return this.processObject(res2, path.parent).append(File.separator).append(path.kind).append(File.separator).append(path.name).append(StringUtil.notNullize((String)path.getIdentity()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "res";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processPath";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processObject";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) == null || res2.length() == 0 ? path : res2.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            for (DbSrcStorage storage : DbSrcStorageManager.getInstance(project).getActiveStorages()) {
                storage.flushToFs(asynchronous);
            }
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(20);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(21);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            DbSrcFileSystem.$$$reportNull$$$0(22);
        }
        return normalizedPath.startsWith("/") ? "/" : "";
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(23);
        }
        Object object = path.startsWith("/") ? path : "/" + path;
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(24);
        }
        return object;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(25);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(26);
        }
        if (copyName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(27);
        }
        throw DbSrcFileSystem.unsupported("copy", file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent2, @NotNull String dir) throws IOException {
        if (parent2 == null) {
            DbSrcFileSystem.$$$reportNull$$$0(28);
        }
        if (dir == null) {
            DbSrcFileSystem.$$$reportNull$$$0(29);
        }
        throw DbSrcFileSystem.unsupported("create directory", parent2);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent2, @NotNull String file) throws IOException {
        if (parent2 == null) {
            DbSrcFileSystem.$$$reportNull$$$0(30);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(31);
        }
        throw DbSrcFileSystem.unsupported("create file", parent2);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(32);
        }
        throw DbSrcFileSystem.unsupported("delete", file);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(33);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(34);
        }
        throw DbSrcFileSystem.unsupported("move", file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(35);
        }
        if (newName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(36);
        }
        throw DbSrcFileSystem.unsupported("rename", file);
    }

    @NotNull
    private static IOException unsupported(@NotNull String op, @NotNull VirtualFile file) {
        if (op == null) {
            DbSrcFileSystem.$$$reportNull$$$0(37);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(38);
        }
        return new IOException(StringUtil.capitalize((String)op) + " is unsupported for DbSrcFS: " + file.getUrl());
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(39);
        }
        DbSrcFileSystem.ensureUtf8(file);
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<FileAttributes>(){

            @Override
            public FileAttributes processRoot() {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processProject(@Nullable Project project) {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                DbSrcStorageManager instance;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (instance = DbSrcStorageManager.getInstance(project)).isStored(dataSourceId) ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                boolean exists = group != null ? storage.hasGroup(path, group) : storage.hasChildren(path);
                return exists ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    3.$$$reportNull$$$0(4);
                }
                return (storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null ? null : storage.getSrcAttributes(path, type, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(40);
        }
        return this.getAttributes(file) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(41);
        }
        Object[] listing = ArrayUtilRt.toStringArray(DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<Collection<String>>(){

            @Override
            public Collection<String> processRoot() {
                ArrayList res2 = ContainerUtil.newArrayList((Object[])new String[]{"app"});
                for (Project p2 : ProjectManager.getInstance().getOpenProjects()) {
                    res2.add(p2.getLocationHash());
                }
                return res2;
            }

            @Override
            public Collection<String> processOutOfDate() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> processProject(@Nullable Project project) {
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                return instance.getStoredDataSources();
            }

            @Override
            public Collection<String> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return this.listGroups(project, dataSourceId, null);
            }

            @NotNull
            public Collection<String> listGroups(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                HashSet res2 = new HashSet();
                storage.listGroups(path, (Consumer<? super ObjectKind>)((Consumer)res2::add));
                List list = JBIterable.from(res2).transform(g -> DbSrcFileSystem.escapeGroup(g.code())).toList();
                if (list == null) {
                    4.$$$reportNull$$$0(3);
                }
                return list;
            }

            @Override
            public Collection<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (group == null) {
                    return this.listGroups(project, dataSourceId, path);
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, false);
                if (storage == null) {
                    return Collections.emptyList();
                }
                HashSet<String> res2 = new HashSet<String>();
                StringBuilder nameBuilder = new StringBuilder();
                HashSet fUnique = new HashSet();
                storage.list(path, group, (object, type) -> {
                    if (type == DbSrcBackendUtils.SrcType.FOLDER) {
                        if (!fUnique.add(object) || !storage.hasChildren(object)) {
                            return;
                        }
                        res2.add(this.getName(nameBuilder, object, DbSrcFileSystemCore.ItemType.FOLDER));
                    } else if (type == DbSrcBackendUtils.SrcType.ORIGINAL) {
                        res2.add(this.getName(nameBuilder, object, DbSrcFileSystemCore.ItemType.SRC));
                    } else if (type == DbSrcBackendUtils.SrcType.USER) {
                        if (!res2.add(this.getName(nameBuilder, object, DbSrcFileSystemCore.ItemType.SRC))) {
                            res2.add(this.getName(nameBuilder, object, DbSrcFileSystemCore.ItemType.ORIG));
                        }
                    } else if (type == DbSrcBackendUtils.SrcType.USER_BASE) {
                        res2.add(this.getName(nameBuilder, object, DbSrcFileSystemCore.ItemType.USER_BASE));
                    }
                });
                return res2;
            }

            @NotNull
            public String getName(StringBuilder nameBuilder, ObjectPath dir, DbSrcFileSystemCore.ItemTypeOrFolder t) {
                String name = DbSrcFileSystem.appendName(nameBuilder, dir, t).toString();
                nameBuilder.setLength(0);
                String string = name;
                if (string == null) {
                    4.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Override
            public Collection<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(7);
                }
                if (type == null) {
                    4.$$$reportNull$$$0(8);
                }
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listGroups";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "listGroups";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processFolder";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "processFile";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }));
        Arrays.sort(listing);
        if (listing == null) {
            DbSrcFileSystem.$$$reportNull$$$0(42);
        }
        return listing;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        FileAttributes attributes2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(43);
        }
        return (attributes2 = this.getAttributes(file)) != null && attributes2.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        FileAttributes attributes2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(44);
        }
        return (attributes2 = this.getAttributes(file)) != null && attributes2.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        FileAttributes attributes2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(45);
        }
        return (attributes2 = this.getAttributes(file)) != null && attributes2.isSymLink();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        FileAttributes attributes2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(46);
        }
        return (attributes2 = this.getAttributes(file)) != null ? attributes2.lastModified : 0L;
    }

    public long getLength(@NotNull VirtualFile file) {
        FileAttributes attributes2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(47);
        }
        return (attributes2 = this.getAttributes(file)) != null ? attributes2.length : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, final long timeStamp) throws IOException {
        Object res2;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(48);
        }
        if ((res2 = DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<Object>(){

            @Override
            public Object processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    5.$$$reportNull$$$0(2);
                }
                DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                try {
                    storage.setTimestamp(path, type == DbSrcFileSystemCore.ItemType.ORIG ? DbSrcBackendUtils.SrcType.ORIGINAL : (type == DbSrcFileSystemCore.ItemType.SRC ? DbSrcBackendUtils.SrcType.USER : DbSrcBackendUtils.SrcType.USER_BASE), timeStamp);
                }
                catch (Throwable th) {
                    return th;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) instanceof IOException) {
            throw (IOException)res2;
        }
        ExceptionUtil.rethrowUnchecked((Throwable)((Throwable)ObjectUtils.tryCast((Object)res2, Throwable.class)));
        if (res2 == null) {
            throw DbSrcFileSystem.unsupported("set timestamp", file);
        }
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(49);
        }
        throw DbSrcFileSystem.unsupported("set writable", file);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(50);
        }
        DbSrcFileSystem.ensureUtf8(file);
        final Ref exc = Ref.create();
        byte[] res2 = DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<byte[]>(){

            @Override
            public byte[] processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    6.$$$reportNull$$$0(2);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContent(path, type);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        byte[] byArray = (byte[])ObjectUtils.chooseNotNull((Object)res2, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY);
        if (byArray == null) {
            DbSrcFileSystem.$$$reportNull$$$0(51);
        }
        return byArray;
    }

    public boolean isOrphaned(@NotNull VirtualFile file) {
        VirtualFile base;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(52);
        }
        if (!file.isDirectory() && !file.equals(base = this.getBaseFile(file, false))) {
            return false;
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<Boolean>(){

            @Override
            public Boolean processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (group != null || path == null) {
                    return Boolean.FALSE;
                }
                return this.isOrphaned(project, dataSourceId, path);
            }

            @Override
            public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    7.$$$reportNull$$$0(3);
                }
                if (type != DbSrcFileSystemCore.ItemType.SRC) {
                    return Boolean.FALSE;
                }
                return this.isOrphaned(project, dataSourceId, path);
            }

            @NotNull
            private Boolean isOrphaned(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path) {
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    7.$$$reportNull$$$0(4);
                }
                if (path == null) {
                    7.$$$reportNull$$$0(5);
                }
                if ((storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, false)) == null) {
                    Boolean bl = false;
                    if (bl == null) {
                        7.$$$reportNull$$$0(6);
                    }
                    return bl;
                }
                Boolean bl = storage.getSrcAttributes(path, DbSrcFileSystemCore.ItemType.ORIG, true) == null;
                if (bl == null) {
                    7.$$$reportNull$$$0(7);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 6: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "isOrphaned";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processFolder";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "processFile";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isOrphaned";
                        break;
                    }
                    case 6: 
                    case 7: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }) == Boolean.TRUE;
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(53);
        }
        return this.getBaseFile(file, staging, false);
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging, boolean refresh2) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(54);
        }
        return this.getBaseFile(file, staging, refresh2, false);
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging, boolean refresh2, boolean ignoreValidness) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(55);
        }
        if (!file.isValid() && !ignoreValidness) {
            return null;
        }
        Object name = file.getName();
        DbSrcFileSystemCore.ItemType type = DbSrcFileSystemCore.ItemType.identify((String)name);
        if (DbSrcFileSystemCore.ItemType.ORIG == type) {
            if (!staging) {
                return file;
            }
            name = type.trim((String)name) + DbSrcFileSystemCore.ItemType.SRC.ext;
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), (String)name, refresh2), (Object)file);
        }
        if (DbSrcFileSystemCore.ItemType.SRC == type) {
            if (staging) {
                return file;
            }
            name = type.trim((String)name) + DbSrcFileSystemCore.ItemType.ORIG.ext;
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), (String)name, refresh2), (Object)file);
        }
        return null;
    }

    @Nullable
    public VirtualFile getSatelliteFile(@NotNull VirtualFile file, @NotNull DbSrcFileSystemCore.ItemType type, boolean refresh2) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(56);
        }
        if (type == null) {
            DbSrcFileSystem.$$$reportNull$$$0(57);
        }
        if (!file.isValid()) {
            return null;
        }
        Object name = file.getName();
        DbSrcFileSystemCore.ItemType cur2 = DbSrcFileSystemCore.ItemType.identify((String)name);
        if (cur2 == null) {
            return null;
        }
        if (cur2 == type) {
            return file;
        }
        name = cur2.trim((String)name) + type.ext;
        return DbSrcFileSystem.findChild(file.getParent(), (String)name, refresh2);
    }

    private static VirtualFile findChild(VirtualFile parent2, String name, boolean refresh2) {
        return refresh2 ? ((NewVirtualFile)parent2).refreshAndFindChild(name) : parent2.findChild(name);
    }

    private static void ensureUtf8(VirtualFile file) {
        if (file instanceof VirtualFileImpl) {
            file.setCharset(StandardCharsets.UTF_8);
        }
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(58);
        }
        DbSrcFileSystem.ensureUtf8(file);
        final Ref exc = Ref.create();
        InputStream res2 = DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<InputStream>(){

            @Override
            public InputStream processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    8.$$$reportNull$$$0(2);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContentInputStream(path, type);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res2 == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        InputStream inputStream = res2;
        if (inputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(59);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(60);
        }
        DbSrcFileSystem.ensureUtf8(file);
        final Ref exc = Ref.create();
        OutputStream res2 = DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<OutputStream>(){

            @Override
            public OutputStream processFile(final @Nullable Project project, final @NotNull String dataSourceId, final @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    9.$$$reportNull$$$0(2);
                }
                if (type != DbSrcFileSystemCore.ItemType.SRC) {
                    return null;
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, true);
                try {
                    final OutputStream res2 = storage.getContentOutputStream(path);
                    return res2 == null ? null : new OutputStream(){

                        @Override
                        public void write(int b2) throws IOException {
                            res2.write(b2);
                        }

                        @Override
                        public void close() throws IOException {
                            res2.close();
                            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                                List<VirtualFile> files2;
                                VirtualFile f1 = DbSrcFileSystem.getInstance().refreshAndFindFileByPath(DbSrcFileSystem.getPathFromNormalized(project, dataSourceId, path, (DbSrcFileSystemCore.ItemTypeOrFolder)DbSrcFileSystemCore.ItemType.ORIG));
                                VirtualFile f2 = DbSrcFileSystem.getInstance().refreshAndFindFileByPath(DbSrcFileSystem.getPathFromNormalized(project, dataSourceId, path, (DbSrcFileSystemCore.ItemTypeOrFolder)DbSrcFileSystemCore.ItemType.USER_BASE));
                                List<VirtualFile> list = files2 = f1 != null && f2 != null ? Arrays.asList(f1, f2) : ContainerUtil.createMaybeSingletonList((Object)((VirtualFile)ObjectUtils.coalesce((Object)f1, (Object)f2)));
                                if (!files2.isEmpty()) {
                                    RefreshQueue.getInstance().refresh(true, false, null, files2);
                                }
                            }));
                        }
                    };
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$9";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res2 == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        OutputStream outputStream = res2;
        if (outputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(61);
        }
        return outputStream;
    }

    private static String escapeName(String s2) {
        if (s2 == null) {
            return null;
        }
        if (((String)(s2 = DbSrcUtilsCore.escapeChars((String)s2))).endsWith(".sql") || ((String)s2).endsWith(".orig")) {
            s2 = (String)s2 + "&";
        }
        return s2;
    }

    private static String escapeGroup(String s2) {
        return DbSrcUtilsCore.escapeChars(s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: 
            case 24: 
            case 42: 
            case 51: 
            case 59: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: 
            case 24: 
            case 42: 
            case 51: 
            case 59: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: 
            case 24: 
            case 42: 
            case 51: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromNormalized";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "appendKind";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromNormalized";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: 
            case 24: 
            case 42: 
            case 51: 
            case 59: 
            case 61: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendObj";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendKind";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendExt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isOriginalFilePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "unsupported";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isOrphaned";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFile";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSatelliteFile";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: 
            case 24: 
            case 42: 
            case 51: 
            case 59: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDataSourceUpdater
    implements DataSourceStorage.Listener {
        private final Project myProject;

        MyDataSourceUpdater(Project project) {
            this.myProject = project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(0);
            }
            this.refresh(dataSource2);
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(1);
            }
            this.refresh(dataSource2);
        }

        void refresh(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(2);
            }
            if (this.myProject != null && dataSource2.isGlobal()) {
                return;
            }
            String dataSourceId = Objects.requireNonNull(dataSource2.getUniqueId());
            Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)DbSrcFileSystem.this, (String)DbSrcFileSystem.getDataSourcePath(this.myProject, dataSourceId));
            VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
            if (vfile != null) {
                VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                RefreshQueue.getInstance().refresh(true, true, null, new VirtualFile[]{vfile});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

