/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipData;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

class DbSrcBackend {
    private final DbSrcBackendFiles myFiles;

    DbSrcBackend(@NotNull String root2, @NotNull Listener listener2) {
        if (root2 == null) {
            DbSrcBackend.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            DbSrcBackend.$$$reportNull$$$0(1);
        }
        this.myFiles = new DbSrcBackendFiles(root2, listener2);
    }

    @NotNull
    public @SystemDependent String getRoot() {
        String string = this.myFiles.getRoot();
        if (string == null) {
            DbSrcBackend.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void list(@Nullable ObjectPath object, @NotNull ObjectKind group, boolean staging, @NotNull DbSrcStorage.ListingConsumer consumer2) {
        DbSrcBackendZipData data;
        if (group == null) {
            DbSrcBackend.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            DbSrcBackend.$$$reportNull$$$0(4);
        }
        if ((data = this.getZipData(object, staging, true)) != null) {
            data.list(object, group, consumer2);
        } else {
            this.myFiles.list(object, group, staging, consumer2);
        }
    }

    public void listGroups(@Nullable ObjectPath object, boolean staging, @NotNull Consumer<? super ObjectKind> consumer2) {
        DbSrcBackendZipData data;
        if (consumer2 == null) {
            DbSrcBackend.$$$reportNull$$$0(5);
        }
        if ((data = this.getZipData(object, staging, true)) != null) {
            data.listGroups(object, consumer2);
        } else {
            this.myFiles.listGroups(object, staging, consumer2);
        }
    }

    public boolean hasChildren(@Nullable ObjectPath object, boolean staging) {
        DbSrcBackendZipData data = this.getZipData(object, staging, true);
        if (data != null) {
            return data.hasChildren(object);
        }
        return this.myFiles.hasChildren(object, staging);
    }

    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group, boolean staging) {
        DbSrcBackendZipData data;
        if (group == null) {
            DbSrcBackend.$$$reportNull$$$0(6);
        }
        if ((data = this.getZipData(object, staging, true)) != null) {
            return data.hasGroup(object, group);
        }
        return this.myFiles.hasGroup(object, group, staging);
    }

    public void dropObject(@Nullable ObjectPath object, boolean staging) throws IOException {
        DbSrcBackendZipData data;
        ObjectPath zipRoot;
        ObjectPath objectPath = zipRoot = staging ? null : DbSrcBackend.getZipRoot(object);
        DbSrcBackendZipData dbSrcBackendZipData = zipRoot == null ? null : (data = zipRoot == object ? this.myFiles.getCachedZipData(zipRoot) : this.myFiles.getZipData(zipRoot));
        if (data != null) {
            data.dropObject(object);
        } else {
            this.myFiles.dropObject(object, staging);
        }
    }

    public byte @Nullable [] getContent(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(7);
        }
        if (type == null) {
            DbSrcBackend.$$$reportNull$$$0(8);
        }
        if ((data = this.getZipData(object, DbSrcBackendUtils.isStaging(type), false)) != null) {
            return data.getContent(object);
        }
        return this.myFiles.getContent(object, type);
    }

    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(9);
        }
        if (type == null) {
            DbSrcBackend.$$$reportNull$$$0(10);
        }
        if ((data = this.getZipData(object, DbSrcBackendUtils.isStaging(type), false)) != null) {
            byte[] content = data.getContent(object);
            return content == null ? null : new BufferExposingByteArrayInputStream(content);
        }
        return this.myFiles.getContentInputStream(object, type);
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(11);
        }
        if (type == null) {
            DbSrcBackend.$$$reportNull$$$0(12);
        }
        if ((data = this.getZipData(object, DbSrcBackendUtils.isStaging(type), false)) != null) {
            return data.getSrcAttributes(object);
        }
        return this.myFiles.getSrcAttributes(object, type);
    }

    public void putContent(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content, @Nullable DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(13);
        }
        if (type == null) {
            DbSrcBackend.$$$reportNull$$$0(14);
        }
        if (metaData == null && !DbSrcBackendUtils.isStaging(type)) {
            metaData = this.getMetaData(object);
        }
        if (metaData == null) {
            metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        this.putMetaData(object, DbSrcBackendUtils.isStaging(type), metaData);
        DbSrcBackendZipData data = this.getZipData(object, DbSrcBackendUtils.isStaging(type), false);
        if (data != null) {
            data.putContent(object, content);
        } else {
            this.myFiles.putContent(object, type, content);
        }
    }

    public void setTimestamp(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, long timestamp) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(15);
        }
        if (type == null) {
            DbSrcBackend.$$$reportNull$$$0(16);
        }
        if ((data = this.getZipData(object, DbSrcBackendUtils.isStaging(type), false)) != null) {
            data.setTimestamp(object, timestamp);
        } else {
            this.myFiles.setTimestamp(object, type, timestamp);
        }
    }

    private void cascadeObjectCreation(@NotNull ObjectPath object, boolean staging) throws IOException {
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(17);
        }
        this.putMetaData(object, staging, staging ? DbSrcStorageDsMetadata.MetaData.EMPTY : (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.getMetaData(object), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY));
    }

    public void moveAll(@NotNull ObjectPath from, @NotNull ObjectPath to) throws IOException {
        if (from == null) {
            DbSrcBackend.$$$reportNull$$$0(18);
        }
        if (to == null) {
            DbSrcBackend.$$$reportNull$$$0(19);
        }
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
            this.myFiles.moveAll(from, to, true);
            DbSrcBackendZipData fromData = this.getZipData(from, false, false);
            if (fromData != null) {
                DbSrcBackendZipData toData = this.getZipData(to, false, false);
                if (toData == null) {
                    throw new AssertionError((Object)"Moving from zip to non-zip?!");
                }
                fromData.moveAll(from, toData, to);
            } else {
                this.myFiles.moveAll(from, to, false);
            }
        }
    }

    public void putMetaData(@NotNull ObjectPath object, boolean staging, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        DbSrcBackendZipData data;
        DbSrcStorageDsMetadata.MetaData existing;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(20);
        }
        if (metaData == null) {
            DbSrcBackend.$$$reportNull$$$0(21);
        }
        DbSrcStorageDsMetadata.MetaData metaData2 = existing = staging ? this.myFiles.getStagingMetaData(object) : this.getMetaData(object);
        if (Comparing.equal((Object)existing, (Object)metaData)) {
            return;
        }
        ObjectPath parent2 = object.parent;
        if (parent2 != null) {
            this.cascadeObjectCreation(parent2, staging);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            data.putMetaData(object, metaData);
        } else {
            this.myFiles.putMetaData(object, staging, metaData);
        }
        if (!staging) {
            this.myFiles.putMetaDataToCache(object, metaData);
        }
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData res2;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(22);
        }
        if ((res2 = this.myFiles.getCachedMetaData(object)) != null) {
            return res2;
        }
        DbSrcBackendZipData data = this.getZipData(object, false, false);
        res2 = data != null ? data.readMetaData(object) : this.myFiles.readMetaData(object);
        if (res2 != null) {
            this.myFiles.putMetaDataToCache(object, res2);
        }
        return res2;
    }

    @Nullable
    private DbSrcBackendZipData getZipData(@Nullable ObjectPath object, boolean staging, boolean acceptRoot) {
        ObjectPath zipRoot = staging ? null : DbSrcBackend.getZipRoot(object);
        return zipRoot != null && (object != zipRoot || acceptRoot) ? this.myFiles.getZipData(zipRoot) : null;
    }

    @NotNull
    public DbSrcBackendFiles.Locker writeLock() {
        DbSrcBackendFiles.Locker locker = this.myFiles.writeLock();
        if (locker == null) {
            DbSrcBackend.$$$reportNull$$$0(23);
        }
        return locker;
    }

    @Contract(value="null->null")
    private static ObjectPath getZipRoot(@Nullable ObjectPath object) {
        ObjectPath tmp2 = object;
        while (tmp2 != null) {
            if (DbSrcBackendFiles.isZipRoot(tmp2.kind)) {
                return tmp2;
            }
            tmp2 = tmp2.parent;
        }
        return null;
    }

    public void resetCaches() {
        this.myFiles.resetCaches();
    }

    public void finish() {
        this.myFiles.finish();
    }

    public void drop() {
        this.myFiles.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackend";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackend";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cascadeObjectCreation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveAll";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Listener {
        public void fileMoved(@NotNull ObjectPath var1, @NotNull ObjectPath var2);

        public void fileChanged(@NotNull ObjectPath var1, @NotNull DbSrcBackendUtils.SrcType var2);

        public void dirChanged(@Nullable ObjectPath var1, boolean var2, boolean var3);
    }
}

