/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipWriter;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcZipFile;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbSrcBackendZipData {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendZipData.class);
    private final Map<ObjectPath, DirInfo> myStructure;
    private final Map<ObjectPath, FileInfo> myFileStamps;
    private final ObjectPath myRoot;
    private final int myRootDepth;
    private final DbSrcBackendFiles myFiles;
    private final DbSrcBackendZipWriter myWriter;
    private volatile boolean myLoaded;

    public DbSrcBackendZipData(@NotNull String path, @NotNull ObjectPath root2, @NotNull DbSrcBackendFiles files2) {
        if (path == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(2);
        }
        this.myStructure = new HashMap<ObjectPath, DirInfo>();
        this.myFileStamps = new HashMap<ObjectPath, FileInfo>();
        this.myWriter = new DbSrcBackendZipWriter(path, this::scheduleClose);
        this.myRoot = root2;
        this.myRootDepth = ObjectPaths.getLength(root2);
        this.myFiles = files2;
        this.myLoaded = !this.myWriter.isExists();
    }

    private void scheduleClose() {
        LazyData.ourCloseQueue.queue(new Update(this, false){

            public void run() {
                try (DbSrcBackendFiles.Locker lock = DbSrcBackendZipData.this.myFiles.writeLock();){
                    if (DbSrcBackendZipData.this.myWriter.canClose()) {
                        DbSrcBackendZipData.this.closeWriter();
                    }
                }
            }
        });
    }

    @NotNull
    public ObjectPath getRoot() {
        ObjectPath objectPath = this.myRoot;
        if (objectPath == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(3);
        }
        return objectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            if (this.myLoaded) {
                return;
            }
            if (!this.myWriter.isExists()) {
                this.myLoaded = true;
                return;
            }
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
                 GuardedRef<DbSrcZipFile> zip = this.myWriter.openZip();){
                this.fillStructure(zip.get(), this.extractNamesMapping(zip.get()));
            }
            catch (IOException e) {
                LOG.warn("ZipData build failed", (Throwable)e);
            }
            finally {
                this.myLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(@Nullable ObjectPath object, @Nullable ObjectKind group, @NotNull DbSrcStorage.ListingConsumer consumer2) {
        if (consumer2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(4);
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return;
            }
            for (ObjectPath dir : info.dirs) {
                if (group != null && dir.kind != group) continue;
                consumer2.consume(dir, DbSrcBackendUtils.SrcType.FOLDER);
            }
            for (ObjectPath file : info.files) {
                if (group != null && file.kind != group) continue;
                consumer2.consume(file, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listGroups(@Nullable ObjectPath object, @NotNull Consumer<? super ObjectKind> consumer2) {
        if (consumer2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(5);
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return;
            }
            for (ObjectPath dir : info.dirs) {
                consumer2.consume((Object)dir.kind);
            }
            for (ObjectPath file : info.files) {
                consumer2.consume((Object)file.kind);
            }
        }
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        DirInfo info = this.getDirInfo(object);
        return info != null && (!info.dirs.isEmpty() || !info.files.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(6);
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return false;
            }
            for (ObjectPath dir : info.dirs) {
                if (dir.kind != group) continue;
                return true;
            }
            for (ObjectPath file : info.files) {
                if (file.kind != group) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetaData(@NotNull ObjectPath object, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(7);
        }
        if (metaData == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(8);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".meta");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            byte[] data = DbSrcBackendUtils.serializeMetaData(object, metaData);
            ref.get().putData(path.toString(), data, System.currentTimeMillis(), DbSrcBackendZipData.getDisplayName(object));
            this.myFiles.putMetaDataToCache(object, metaData);
            Map<ObjectPath, DirInfo> map2 = this.myStructure;
            synchronized (map2) {
                DirInfo info = this.getOrCreateDirInfo(object.parent);
                if (info != null) {
                    info.dirs.add(object);
                }
            }
        }
        finally {
            this.myFiles.getListener().dirChanged(object, false, false);
            this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(9);
        }
        if ((metaData = this.myFiles.getCachedMetaData(object)) == null && (metaData = this.readMetaData(object)) != null) {
            this.myFiles.putMetaDataToCache(object, metaData);
        }
        return metaData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(10);
        }
        if (!this.myWriter.isExists()) {
            return null;
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".meta");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.readLock();){
            byte[] data;
            GuardedRef<DbSrcZipFile> ref;
            block20: {
                ref = this.myWriter.openZip();
                try {
                    data = this.getEntryData(ref.get(), path.toString());
                    if (data != null) break block20;
                    DbSrcStorageDsMetadata.MetaData metaData = null;
                    if (ref != null) {
                        ref.close();
                    }
                    return metaData;
                }
                catch (Throwable throwable) {
                    if (ref != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            DbSrcStorageDsMetadata.MetaData metaData = DbSrcBackendUtils.deserializeMetaData(new ByteArrayInputStream(data));
            if (ref != null) {
                ref.close();
            }
            return metaData;
        }
        catch (IOException e) {
            return null;
        }
    }

    private synchronized byte[] getEntryData(DbSrcZipFile file, String name) throws IOException {
        return file.getData(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(@NotNull ObjectPath object, @Nullable byte[] content) throws IOException {
        block25: {
            if (object == null) {
                DbSrcBackendZipData.$$$reportNull$$$0(11);
            }
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            path.append(".sql");
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
                 GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
                if (content != null) {
                    String comment = DbSrcBackendZipData.getDisplayName(object);
                    ref.get().putData(path.toString(), content, System.currentTimeMillis(), comment);
                    Map<ObjectPath, DirInfo> map2 = this.myStructure;
                    synchronized (map2) {
                        DirInfo info = this.getOrCreateDirInfo(object.parent);
                        this.myFileStamps.put(object, new FileInfo(System.currentTimeMillis(), content.length));
                        if (info != null) {
                            info.files.add(object);
                        }
                        break block25;
                    }
                }
                ref.get().eraseEntry(path.toString());
                Map<ObjectPath, DirInfo> map3 = this.myStructure;
                synchronized (map3) {
                    DirInfo info = this.getDirInfo(object.parent);
                    if (info != null) {
                        info.files.remove(object);
                    }
                    this.myFileStamps.remove(object);
                }
            }
            finally {
                this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAll(@NotNull ObjectPath from, @NotNull DbSrcBackendZipData toData, @NotNull ObjectPath to) throws IOException {
        if (from == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(12);
        }
        if (toData == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(13);
        }
        if (to == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(14);
        }
        try (DbSrcBackendFiles.Locker fromLock = this.myFiles.writeLock();
             DbSrcBackendFiles.Locker toLock = toData.myFiles.writeLock();){
            this.copyFile(from, toData, to);
            this.copyDir(from, toData, to, false);
            this.dropObjectInner(from);
        }
        finally {
            this.myFiles.getListener().fileMoved(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDir(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to, boolean meta) {
        DirInfo dirInfo;
        if (meta) {
            this.copyMeta(from, toData, to);
        }
        Iterator<ObjectPath> iterator = this.myStructure;
        synchronized (iterator) {
            dirInfo = this.myStructure.get(from);
        }
        if (dirInfo == null) {
            return;
        }
        for (ObjectPath file : dirInfo.files) {
            this.copyFile(file, toData, ObjectPath.copyUnder(file, to));
        }
        for (ObjectPath dir : dirInfo.dirs) {
            this.copyDir(dir, toData, ObjectPath.copyUnder(dir, to), !dirInfo.files.contains(dir));
        }
    }

    private void copyFile(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to) {
        this.copyMeta(from, toData, to);
        try {
            byte[] content = this.getContent(from);
            if (content != null) {
                toData.putContent(to, content);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to move content", (Throwable)e);
        }
    }

    private void copyMeta(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to) {
        DbSrcStorageDsMetadata.MetaData data = this.getMetaData(from);
        if (data != null) {
            try {
                toData.putMetaData(to, data);
            }
            catch (IOException e) {
                LOG.warn("Failed to move meta data", (Throwable)e);
            }
        }
    }

    private static String getDisplayName(@NotNull ObjectPath object) {
        String d2;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(15);
        }
        return (d2 = object.getIdentity()) != null ? object.getName() + "." + d2 : object.getName();
    }

    @NotNull
    public ObjectPath findCascadeRemovalRoot(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(16);
        }
        return this.findCascadeRemovalRootImpl(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ObjectPath findCascadeRemovalRootImpl(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(17);
        }
        if (object.equals(this.myRoot)) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(18);
            return objectPath;
        }
        ObjectPath parent2 = object.parent;
        if (parent2 == null) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(19);
            return objectPath;
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        // MONITORENTER : map2
        if (this.hasOtherChild(parent2, object)) {
            ObjectPath objectPath = object;
            // MONITOREXIT : map2
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(20);
            return objectPath;
        }
        if (parent2.equals(this.myRoot)) {
            ObjectPath objectPath = parent2;
            // MONITOREXIT : map2
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(21);
            return objectPath;
        }
        if (this.myFileStamps.get(parent2) != null) {
            ObjectPath objectPath = object;
            // MONITOREXIT : map2
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(22);
            return objectPath;
        }
        // MONITOREXIT : map2
        if (((DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.getMetaData(object), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY)).equals(DbSrcStorageDsMetadata.MetaData.EMPTY)) return this.findCascadeRemovalRootImpl(parent2);
        ObjectPath objectPath = object;
        if (objectPath != null) return objectPath;
        DbSrcBackendZipData.$$$reportNull$$$0(23);
        return objectPath;
    }

    private boolean hasOtherChild(@NotNull ObjectPath parent2, @NotNull ObjectPath object) {
        DirInfo info;
        if (parent2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(24);
        }
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(25);
        }
        if ((info = this.myStructure.get(parent2)) == null) {
            return false;
        }
        if (info.dirs.size() > 1 || info.files.size() > 1) {
            return true;
        }
        if (!info.dirs.isEmpty() && !info.dirs.contains(object)) {
            return true;
        }
        return !info.files.isEmpty() && !info.files.contains(object);
    }

    @Nullable
    public byte[] getContent(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(26);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".sql");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.readLock();){
            GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();
            try {
                byte[] byArray = this.getEntryData(ref.get(), path.toString());
                if (ref != null) {
                    ref.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (ref != null) {
                    try {
                        ref.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object) {
        FileInfo info;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(27);
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            info = this.myFileStamps.get(object);
        }
        if (info == null) {
            return null;
        }
        return new FileAttributes(false, false, false, false, info.size, info.stamp, !this.myWriter.isReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(28);
        }
        ObjectPath root2 = object;
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
            if (object.equals(this.myRoot)) {
                this.myFiles.dropSrcAndMeta(object);
            }
            root2 = this.dropObjectInner(object);
        }
        finally {
            this.myFiles.getListener().dirChanged(root2, false, true);
            this.myFiles.getListener().fileChanged(root2, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    private ObjectPath dropObjectInner(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(29);
        }
        ObjectPath root2 = this.findCascadeRemovalRoot(object);
        this.dropFromStructure(root2);
        this.clearSubEntries(root2);
        this.myFiles.removeCachedMetaDataRec(root2);
        return root2;
    }

    private void clearSubEntries(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(30);
        }
        String prefix = null;
        String src = null;
        String meta = null;
        if (!object.equals(this.myRoot)) {
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            int len = path.length();
            prefix = path.append("/").toString();
            path.setLength(len);
            src = path.append(".sql").toString();
            path.setLength(len);
            meta = path.append(".meta").toString();
        }
        try (GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            DbSrcZipFile.It it2 = ref.get().iterate();
            while (it2.advance()) {
                String name = it2.getName();
                if (prefix != null && !name.startsWith(prefix) && !name.equals(src) && !name.equals(meta)) continue;
                it2.drop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropFromStructure(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(31);
        }
        this.myFiles.putMetaDataToCache(object, null);
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            DirInfo children2 = this.myStructure.remove(object);
            this.myFileStamps.remove(object);
            if (children2 != null) {
                for (ObjectPath file : children2.files) {
                    this.myFiles.putMetaDataToCache(object, null);
                    this.myFileStamps.remove(file);
                }
                for (ObjectPath dir : children2.dirs) {
                    this.dropFromStructure(dir);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeWriter() {
        block13: {
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
                if (!this.myWriter.close() || !this.myWriter.isExists()) break block13;
                boolean empty = false;
                Map<ObjectPath, DirInfo> map2 = this.myStructure;
                synchronized (map2) {
                    if (!this.hasChildren(this.myRoot)) {
                        this.myStructure.clear();
                        this.myFileStamps.clear();
                        this.myLoaded = false;
                        empty = true;
                    }
                }
                if (!empty) break block13;
                try {
                    this.myWriter.dropFile();
                    if (!this.myFiles.hasSrcOrMeta(this.myRoot)) {
                        this.myFiles.dropObject(this.myRoot, false);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private void fillStructure(@NotNull DbSrcZipFile file, @NotNull Map<CharSequence, Pair<String, String>> names) {
        if (file == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(32);
        }
        if (names == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(33);
        }
        HashMap<CharSequence, ObjectPath> paths = new HashMap<CharSequence, ObjectPath>();
        DbSrcZipFile.It it2 = file.iterate();
        while (it2.advance()) {
            String name = it2.getName();
            if (name.isEmpty() || name.charAt(0) != '/') continue;
            boolean dir = it2.isDirectory();
            if (!dir) {
                if (!name.endsWith(".sql")) continue;
                name = StringUtil.trimEnd((String)name, (String)".sql");
            } else {
                if (DbSrcBackendZipData.isGroup(name)) continue;
                name = StringUtil.trimEnd((String)name, (String)"/");
            }
            ObjectPath path = this.createSrcPath(name, paths, names);
            if (path == null) {
                this.reportCorruptedEntry(name);
                continue;
            }
            DirInfo parentDir = this.getOrCreateDirInfo(Objects.requireNonNull(path.parent));
            if (dir) {
                parentDir.dirs.add(path);
            } else {
                this.myFileStamps.put(path, new FileInfo(it2.getTimestamp(), it2.getSize()));
                parentDir.files.add(path);
            }
            this.getOrCreateDirInfo(this.myRoot);
        }
    }

    private DirInfo getOrCreateDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        DirInfo info = this.myStructure.get(path);
        if (info == null) {
            DirInfo parent2;
            if (!path.equals(this.myRoot) && (parent2 = this.getOrCreateDirInfo(path.parent)) != null) {
                parent2.dirs.add(path);
            }
            info = new DirInfo();
            this.myStructure.put(path, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DirInfo getDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        Map<ObjectPath, DirInfo> map2 = this.myStructure;
        synchronized (map2) {
            return this.myStructure.get(path);
        }
    }

    private static boolean isGroup(String path) {
        return StringUtil.countChars((CharSequence)path, (char)'/') % 2 == 0;
    }

    @Nullable
    private ObjectPath createSrcPath(@NotNull CharSequence name, @NotNull Map<CharSequence, ObjectPath> paths, @NotNull Map<CharSequence, Pair<String, String>> namesMapping) {
        ObjectPath parent2;
        ObjectPath path;
        if (name == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(34);
        }
        if (paths == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(35);
        }
        if (namesMapping == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(36);
        }
        if ((path = paths.get(name)) != null) {
            return path;
        }
        assert (StringUtil.startsWith((CharSequence)name, (CharSequence)"/"));
        Pair<String, String> realName = namesMapping.get(name);
        if (realName == null) {
            return null;
        }
        int ns = StringUtil.lastIndexOf((CharSequence)name, (char)'/', (int)0, (int)name.length());
        if (ns == -1) {
            return null;
        }
        int gs = StringUtil.lastIndexOf((CharSequence)name, (char)'/', (int)0, (int)ns);
        if (gs == -1) {
            return null;
        }
        String code = name.subSequence(gs + 1, ns).toString();
        ObjectKind kind = DbSrcUtilsCore.findKind(code);
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = parent2 = gs == 0 ? this.myRoot : this.createSrcPath(name.subSequence(0, gs), paths, namesMapping);
        if (parent2 == null) {
            return null;
        }
        path = DbSrcBackendUtils.createPath(parent2, (String)realName.first, kind, (String)realName.second);
        paths.put(name, path);
        return path;
    }

    @NotNull
    public Map<CharSequence, Pair<String, String>> extractNamesMapping(DbSrcZipFile file) {
        HashMap<CharSequence, Pair<String, String>> names = new HashMap<CharSequence, Pair<String, String>>();
        DbSrcZipFile.It it2 = file.iterate();
        while (it2.advance()) {
            Pair<String, String> fullName;
            String id;
            String name = it2.getName();
            if (it2.isDirectory() || !name.endsWith(".meta") || names.containsKey(id = StringUtil.trimEnd((String)name, (String)".meta"))) continue;
            try {
                fullName = DbSrcBackendUtils.extractNameAndIdentity(it2.getData());
            }
            catch (IOException e) {
                LOG.warn("Failed to read " + name + " from " + this.getPath(), (Throwable)e);
                fullName = null;
            }
            if (fullName != null) {
                names.put(id, fullName);
                continue;
            }
            this.reportCorruptedEntry(name);
        }
        HashMap<CharSequence, Pair<String, String>> hashMap = names;
        if (hashMap == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    @NotNull
    public String getPath() {
        String string = this.myWriter.getPath();
        if (string == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(38);
        }
        return string;
    }

    private void reportCorruptedEntry(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(@NotNull ObjectPath object, long timestamp) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(39);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".sql");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            String name = path.toString();
            byte[] data = ref.get().getData(name);
            if (data == null) {
                return;
            }
            ref.get().putData(name, data, timestamp, DbSrcBackendZipData.getDisplayName(object));
            Map<ObjectPath, DirInfo> map2 = this.myStructure;
            synchronized (map2) {
                FileInfo info = this.myFileStamps.get(object);
                assert (info != null);
                this.myFileStamps.put(object, new FileInfo(timestamp, info.size));
            }
        }
        finally {
            this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    @TestOnly
    public static void flushCloseQueue() {
        LazyData.ourCloseQueue.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findCascadeRemovalRootImpl";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNamesMapping";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveAll";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRoot";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRootImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherChild";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "dropObjectInner";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "clearSubEntries";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "dropFromStructure";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fillStructure";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSrcPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FileInfo {
        public final long stamp;
        public final long size;

        public FileInfo(long stamp, long size) {
            this.stamp = stamp - stamp % 2000L;
            this.size = size;
        }
    }

    public static final class DirInfo {
        public final Set<ObjectPath> dirs = new LinkedHashSet<ObjectPath>();
        public final Set<ObjectPath> files = new LinkedHashSet<ObjectPath>();
    }

    private static class LazyData {
        private static final MergingUpdateQueue ourCloseQueue = new MergingUpdateQueue("Close DbSrcBackend zips", 2000, true, null, (Disposable)ApplicationManager.getApplication(), null, Alarm.ThreadToUse.POOLED_THREAD);

        private LazyData() {
        }

        static {
            ourCloseQueue.setRestartTimerOnAdd(true);
        }
    }
}

