/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypesRegistry
implements TextDecomposition.PatternFactory {
    private static final ExtensionPointName<TypeDescriptorFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.urlParamEditorProvider");
    public static final TypesRegistry INSTANCE = new TypesRegistry();
    @Language(value="regexp")
    public static final String HOST_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    @Language(value="regexp")
    public static final String IPV6_COLON_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}";
    @Language(value="regexp")
    public static final String IPV6_DOT_QUAD_PATTERN = "(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    @Language(value="regexp")
    public static final String IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    @Language(value="regexp")
    public static final String HOST_N_IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}|[\\p{L}\\p{M}\\p{N}[-_.]]+";
    @Language(value="regexp")
    public static final String PARAMETER_PATTERN = "[^;=&]+";
    @Language(value="regexp")
    public static final String PORT_PATTERN = "[\\p{N}]{1,5}";
    @Language(value="regexp")
    public static final String DB_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    @Language(value="regexp")
    public static final String FILE_PATH_PATTERN = "(?!//)[^;?&]+?|/";
    @Language(value="regexp")
    public static final String USER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    @Language(value="regexp")
    public static final String PASSWORD_PATTERN = "[^&=;)/:@]+";
    @Language(value="regexp")
    public static final String PATH_PATTERN = "(?!//)[^;?&]+?|/";
    @Language(value="regexp")
    public static final String IDENTIFIER_PATTERN = "[^&=;)/:@]+";
    private final Map<String, TypeDescriptor> myTypes = new HashMap<String, TypeDescriptor>();

    private TypesRegistry() {
        this.put(new TextFieldTypeDescriptor("identifier", "[^&=;)/:@]+", DatabaseBundle.message("TypeDescriptor.param.identifier", new Object[0])));
        this.put(new TextFieldTypeDescriptor("param", PARAMETER_PATTERN, DatabaseBundle.message("TypeDescriptor.param.param", new Object[0])));
        this.put(new TextFieldTypeDescriptor("user", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", DatabaseBundle.message("TypeDescriptor.param.user", new Object[0])));
        this.put(new TextFieldTypeDescriptor("password", "[^&=;)/:@]+", DatabaseBundle.message("TypeDescriptor.param.password", new Object[0])));
        this.put(new TextFieldTypeDescriptor("host", HOST_PATTERN, DatabaseBundle.message("TypeDescriptor.param.host", new Object[0])));
        this.put(new TextFieldTypeDescriptor("host_ipv6", HOST_N_IPV6_PATTERN, DatabaseBundle.message("TypeDescriptor.param.host_ipv6", new Object[0])));
        this.put(new TextFieldTypeDescriptor("ipv6", IPV6_PATTERN, DatabaseBundle.message("TypeDescriptor.param.ipv6", new Object[0])));
        this.put(new TextFieldTypeDescriptor("port", PORT_PATTERN, DatabaseBundle.message("TypeDescriptor.param.port", new Object[0]), FieldSize.SMALL, new AnAction[0]));
        this.put(new DatabaseTypeDescriptor("database", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", DatabaseBundle.message("TypeDescriptor.param.database", new Object[0])));
        this.put(new TextFieldTypeDescriptor("file", "(?!//)[^;?&]+?|/", DatabaseBundle.message("TypeDescriptor.param.file", new Object[0]), FieldSize.LARGE, DatabaseUiService.getInstance().getSelectDbAction(true), DatabaseUiService.getInstance().getCreateDbAction()));
        this.put(new TextFieldTypeDescriptor("path", "(?!//)[^;?&]+?|/", DatabaseBundle.message("TypeDescriptor.param.path", new Object[0]), FieldSize.LARGE, DatabaseUiService.getInstance().getSelectDbAction(false)));
        this.put(new TextFieldTypeDescriptor("path_db", "(?!//)[^;?&]+?|/", DatabaseBundle.message("TypeDescriptor.param.path_db", new Object[0]), FieldSize.LARGE, DatabaseUiService.getInstance().getSelectDbPathFileAction()));
        this.put(new TextCBTypeDescriptor("true_box", "true", "", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "true", "false|", DatabaseBundle.message("TypeDescriptor.param.true_box", new Object[0])));
        this.put(new ComboBoxTypeDescriptor("variants", DatabaseBundle.message("TypeDescriptor.param.variants", new Object[0])));
        for (TypeDescriptorFactory factory : (TypeDescriptorFactory[])EP_NAME.getExtensions()) {
            factory.createTypeDescriptor((Consumer<? super TypeDescriptor>)((Consumer)o -> this.put((TypeDescriptor)o)));
        }
    }

    @Override
    @Nullable
    public Pattern getPattern(@NotNull String type, @Nullable String configuration, @Nullable String patternOverride) {
        TypeDescriptor descriptor2;
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(0);
        }
        return (descriptor2 = this.get(type)) == null ? null : descriptor2.getPattern(configuration, patternOverride);
    }

    public void put(@NotNull TypeDescriptor desc) {
        if (desc == null) {
            TypesRegistry.$$$reportNull$$$0(1);
        }
        TypeDescriptor prev = this.myTypes.put(desc.getName(), desc);
        assert (prev == null);
    }

    @Nullable
    public TypeDescriptor get(@NotNull String type) {
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(2);
        }
        type = StringUtil.trimStart((String)type, (String)"#");
        return this.myTypes.get(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class BaseTypeDescriptor
    implements TypeDescriptor {
        private final String myRegex;
        private final String myName;
        private final @NlsContexts.Label String myDefaultCaption;

        protected BaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(2);
            }
            this.myRegex = regex;
            this.myName = name;
            this.myDefaultCaption = defaultCaption;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NlsContexts.Label
        @NotNull
        protected static String formatFieldCaption(@NlsContexts.Label @NotNull String caption) {
            if (caption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(4);
            }
            String string = caption + ":";
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NlsContexts.Label
        @NotNull
        protected String formatCaption(@NotNull String param) {
            if (param == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(6);
            }
            if (param.equals(this.myName)) {
                String string = this.myDefaultCaption;
                if (string == null) {
                    BaseTypeDescriptor.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = DatabaseBundle.messageOr(BaseTypeDescriptor.getParameterKey(param), StringUtil.capitalize((String)param), new Object[0]);
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public static String getParameterKey(@NotNull String param) {
            if (param == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(9);
            }
            String string = "TypeDescriptor.param." + StringUtil.toLowerCase((String)param).replaceAll("[^\\w]", "_");
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        @NotNull
        public ParamEditor createField(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(11);
            }
            if (interchange == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(12);
            }
            ParamEditor paramEditor = this.createFieldImpl(this.formatCaption(caption), configuration, interchange);
            if (paramEditor == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(13);
            }
            return paramEditor;
        }

        @NotNull
        protected abstract ParamEditor createFieldImpl(@NlsContexts.Label @NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @Override
        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(14);
            }
            List<ParamEditor> list = Collections.emptyList();
            if (list == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = Pattern.compile(patternOverride != null ? patternOverride : this.myRegex);
            if (pattern == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(16);
            }
            return pattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatFieldCaption";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatCaption";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterKey";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createField";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSatellites";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "formatFieldCaption";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "formatCaption";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterKey";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createField";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createSatellites";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DatabaseTypeDescriptor
    extends BaseTypeDescriptor {
        DatabaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(2);
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            DatabaseDialectEx dialect;
            if (caption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (interchange == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (!(dialect = DbImplUtil.getDatabaseDialect(DbImplUtilCore.getDbms(interchange.getDriver()))).supportsLoadDatabaseList()) {
                ParamEditor paramEditor = DatabaseUiService.getInstance().createTextParamEditor(interchange, DatabaseTypeDescriptor.formatFieldCaption(caption), FieldSize.MEDIUM, new AnAction[0]);
                if (paramEditor == null) {
                    DatabaseTypeDescriptor.$$$reportNull$$$0(5);
                }
                return paramEditor;
            }
            ParamEditor paramEditor = DatabaseUiService.getInstance().createDatabaseParamEditor(DatabaseTypeDescriptor.formatFieldCaption(caption), interchange);
            if (paramEditor == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(6);
            }
            return paramEditor;
        }

        @Override
        @NotNull
        public ParamEditor createField(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(7);
            }
            if (interchange == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(8);
            }
            if (configuration != null) {
                caption = configuration;
            }
            ParamEditor paramEditor = super.createField(caption, configuration, interchange);
            if (paramEditor == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(9);
            }
            return paramEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldImpl";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createField";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextFieldTypeDescriptor
    extends BaseTypeDescriptor {
        private final FieldSize myFieldSize;
        private final AnAction[] myActions;

        TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(2);
            }
            this(name, regex, defaultCaption, FieldSize.MEDIUM, new AnAction[0]);
        }

        TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption, @NotNull FieldSize fieldSize, AnAction ... actions) {
            if (name == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (regex == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (defaultCaption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(5);
            }
            if (fieldSize == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(6);
            }
            if (actions == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(7);
            }
            super(name, regex, defaultCaption);
            this.myActions = actions;
            this.myFieldSize = fieldSize;
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(8);
            }
            if (interchange == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(9);
            }
            ParamEditor paramEditor = DatabaseUiService.getInstance().createTextParamEditor(interchange, TextFieldTypeDescriptor.formatFieldCaption(caption), this.myFieldSize, this.myActions);
            if (paramEditor == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(10);
            }
            return paramEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldSize";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextCBTypeDescriptor
    extends BaseTypeDescriptor {
        private final String myTrueValue;
        private final String myFalseValue;
        private final Pattern myTrueRegexp;
        private final Pattern myFalseRegexp;

        TextCBTypeDescriptor(@NotNull String name, @NotNull String trueValue, @NotNull String falseValue, @NotNull String regex, @NotNull String trueRegex, @NotNull String falseRegex, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (trueValue == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (falseValue == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(2);
            }
            if (regex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (trueRegex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (falseRegex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(5);
            }
            if (defaultCaption == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(6);
            }
            super(name, regex, defaultCaption);
            this.myTrueValue = trueValue;
            this.myFalseValue = falseValue;
            this.myTrueRegexp = PatternBuilder.compile(trueRegex);
            this.myFalseRegexp = PatternBuilder.compile(falseRegex);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(7);
            }
            if (interchange == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(8);
            }
            ParamEditor paramEditor = DatabaseUiService.getInstance().createCheckBoxParamEditor(interchange, caption, this.myTrueValue, this.myFalseValue, this.myTrueRegexp, this.myFalseRegexp);
            if (paramEditor == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(9);
            }
            return paramEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueRegex";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseRegex";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ComboBoxTypeDescriptor
    extends BaseTypeDescriptor {
        private static final Pattern CONFIG_PATTERN = Pattern.compile("(?:^|,)((?:[^=,]|\\\\=)+)=((?:[^=,]|\\\\=)*)");

        ComboBoxTypeDescriptor(@NotNull String name, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (defaultCaption == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(1);
            }
            super(name, "", defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(2);
            }
            if (interchange == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(3);
            }
            ParamEditor paramEditor = DatabaseUiService.getInstance().createComboBoxParamEditor(interchange, ComboBoxTypeDescriptor.formatFieldCaption(caption), configuration);
            if (paramEditor == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(4);
            }
            return paramEditor;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = ComboBoxTypeDescriptor.getPattern(configuration);
            Pattern pattern2 = pattern == null ? super.getPattern(configuration, patternOverride) : pattern;
            if (pattern2 == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(5);
            }
            return pattern2;
        }

        @Nullable
        public static List<Pair<String, String>> parseConfiguration(@Nullable String configuration) {
            if (StringUtil.isEmpty((String)configuration)) {
                return null;
            }
            ArrayList<Pair<String, String>> res2 = new ArrayList<Pair<String, String>>();
            Matcher matcher = CONFIG_PATTERN.matcher(configuration);
            int start2 = 0;
            while (matcher.find(start2)) {
                if (matcher.start() != start2) {
                    return null;
                }
                start2 = matcher.end();
                res2.add((Pair<String, String>)Pair.create((Object)matcher.group(1), (Object)matcher.group(2)));
            }
            if (configuration.length() != start2) {
                return null;
            }
            return res2;
        }

        @Nullable
        public static Pattern getPattern(@Nullable String configuration) {
            List<Pair<String, String>> parsed = ComboBoxTypeDescriptor.parseConfiguration(configuration);
            if (parsed == null) {
                return null;
            }
            PatternBuilder builder = PatternBuilder.build("");
            boolean first2 = true;
            for (Pair<String, String> pair : parsed) {
                if (!first2) {
                    builder.append("|");
                }
                first2 = false;
                builder.append(Pattern.quote((String)pair.second));
            }
            return builder.compile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TypeDescriptorFactory {
        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptor> var1);
    }

    public static interface TypeDescriptor {
        @NotNull
        public String getName();

        @NotNull
        public ParamEditor createField(@NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange var1);

        @NotNull
        public Pattern getPattern(@Nullable String var1, @Nullable String var2);
    }

    public static interface ParamEditor
    extends Disposable {
        @NotNull
        public String getText();

        public void setText(@NotNull String var1);

        public void addFocusListener(@NotNull FocusListener var1);

        @NotNull
        public JComponent getComponent();

        @NlsContexts.Label
        @Nullable
        public String getCaption();

        public FieldSize getFieldSize();

        public void setChangeListener(@NotNull Runnable var1);

        public JComponent getEditorComponent();
    }
}

