/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsStorage {
    private static final double MULTIPLIER = 1.5;
    private final double myMultiplier;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final RowsCounter myModifiedRowsCounter;
    private final RowsCounter myRowsWithUnparsedValuesCounter;
    private final TypesMutationsStorageImpl myTypesMutationsStorage;
    private final Queue<ModelIndex<DataConsumer.Row>> myInsertedRows;
    private final HashMap<ModelIndex<DataConsumer.Column>, DataConsumer.Column> myInsertedColumns;
    private final Set<ModelIndex<DataConsumer.Row>> myDeletedRows;
    private final Set<ModelIndex<DataConsumer.Column>> myDeletedColumns;
    private MutationData[][] myValues;
    private int myMaxRows;
    private int myRows;
    private int myMaxColumns;
    private int myColumns;

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(0);
        }
        this(model, rows, columns, 1.5);
    }

    private MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns, double multiplier) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(1);
        }
        this.myMultiplier = multiplier;
        this.myRows = rows;
        this.myColumns = columns;
        this.myMaxRows = this.getIncreasedValue(rows);
        this.myMaxColumns = this.getIncreasedValue(columns);
        this.myModel = model;
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModifiedRowsCounter = new ModifiedRowsCounter();
        this.myRowsWithUnparsedValuesCounter = new RowsWithUnparsedValuesCounter();
        this.myTypesMutationsStorage = new TypesMutationsStorageImpl();
        this.myInsertedRows = new PriorityQueue<ModelIndex<DataConsumer.Row>>((o1, o2) -> Integer.compare(o2.asInteger(), o1.asInteger()));
        this.myDeletedRows = new HashSet<ModelIndex<DataConsumer.Row>>();
        this.myDeletedColumns = new HashSet<ModelIndex<DataConsumer.Column>>();
        this.myInsertedColumns = new HashMap();
    }

    @Nullable
    public TypesMutationsStorage getTypesMutationsStorage() {
        return this.myTypesMutationsStorage;
    }

    public void set(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable CellMutation value2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(2);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(3);
        }
        if (!this.isValid(row, column2)) {
            return;
        }
        this.allocateSpace(row, column2);
        this.countModifications(value2, row, column2);
        this.myValues[row.asInteger()][column2.asInteger()] = value2 == null ? null : new MutationData(this.myTypesMutationsStorage == null ? value2.getValue() : this.myTypesMutationsStorage.fixNewValue(value2.getValue(), row, column2));
    }

    protected void allocateSpace(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(5);
        }
        int rowIdx = row.asInteger();
        int colIdx = column2.asInteger();
        if (rowIdx >= this.myMaxRows || colIdx >= this.myMaxColumns) {
            this.reallocate(Math.max(rowIdx, this.myMaxRows), Math.max(colIdx, this.myMaxColumns));
        }
        this.increase(rowIdx, colIdx);
        if (this.myValues[rowIdx] == null) {
            this.myValues[rowIdx] = new MutationData[this.myMaxColumns];
        }
    }

    public void shiftUpColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(6);
        }
        this.myModifiedRowsCounter.deleteColumn(column2);
        this.myRowsWithUnparsedValuesCounter.deleteColumn(column2);
        int idx = column2.asInteger();
        for (int i2 = 0; i2 < this.myValues.length; ++i2) {
            if (this.myValues[i2] == null) continue;
            System.arraycopy(this.myValues[i2], idx + 1, this.myValues[i2], idx, this.myColumns - 1 - idx);
            this.myValues[i2][this.myColumns - 1] = null;
        }
    }

    public void shiftUpRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(7);
        }
        int idx = row.asInteger();
        System.arraycopy(this.myValues, idx + 1, this.myValues, idx, this.myRows - 1 - idx);
        this.myValues[this.myRows - 1] = null;
        this.myModifiedRowsCounter.shiftUp(row);
        this.myRowsWithUnparsedValuesCounter.shiftUp(row);
    }

    public int rowCount() {
        return this.myRows;
    }

    public int columnCount() {
        return this.myColumns;
    }

    @NotNull
    public Set<ModelIndex<DataConsumer.Row>> getModifiedRows() {
        HashSet<ModelIndex<DataConsumer.Row>> modifiedRows = new HashSet<ModelIndex<DataConsumer.Row>>();
        for (int i2 : this.myModifiedRowsCounter.toArray()) {
            modifiedRows.add(ModelIndex.forRow(this.myModel, i2));
        }
        HashSet<ModelIndex<DataConsumer.Row>> hashSet = modifiedRows;
        if (hashSet == null) {
            MutationsStorage.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public void deleteColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            MutationsStorage.$$$reportNull$$$0(9);
        }
        if (!this.isValidColumn(columnIdx)) {
            return;
        }
        boolean isInserted = this.isInsertedColumn(columnIdx);
        this.clearColumn(columnIdx);
        if (isInserted) {
            this.insertedColumnRemoved(columnIdx);
        } else {
            this.myDeletedColumns.add(columnIdx);
        }
    }

    public void deleteRow(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            MutationsStorage.$$$reportNull$$$0(10);
        }
        if (!this.isValidRow(rowIdx)) {
            return;
        }
        boolean isInserted = this.isInsertedRow(rowIdx);
        this.clearRow(rowIdx);
        if (isInserted) {
            this.insertedRowRemoved(rowIdx);
        } else {
            this.myDeletedRows.add(rowIdx);
        }
    }

    private void insertedColumnRemoved(ModelIndex<DataConsumer.Column> columnIdx) {
        List<ModelIndex<DataConsumer.Column>> indexesToShift = MutationsStorage.findBiggerIndices(this.myInsertedColumns.keySet(), columnIdx);
        Map columnsToShift = ContainerUtil.map2Map(indexesToShift, key -> new Pair(key, (Object)this.myInsertedColumns.get(key)));
        for (ModelIndex<DataConsumer.Column> idx : indexesToShift) {
            this.myInsertedColumns.remove(idx);
        }
        JBIterable.from(columnsToShift.entrySet()).transform(keyValue -> new Pair(ModelIndex.forColumn(this.myModel, ((ModelIndex)keyValue.getKey()).asInteger() - 1), (Object)((DataConsumer.Column)keyValue.getValue()))).filter(keyValue -> ((ModelIndex)keyValue.getFirst()).asInteger() >= 0).forEach(keyValue -> this.myInsertedColumns.put((ModelIndex)keyValue.getFirst(), (DataConsumer.Column)keyValue.getSecond()));
        this.shiftUpColumn(columnIdx);
    }

    private void insertedRowRemoved(ModelIndex<DataConsumer.Row> rowIdx) {
        List<ModelIndex<DataConsumer.Row>> indexesToShift = MutationsStorage.findBiggerIndices(this.myInsertedRows, rowIdx);
        this.myInsertedRows.removeAll(indexesToShift);
        JBIterable.from(indexesToShift).transform(idx -> ModelIndex.forRow(this.myModel, idx.asInteger() - 1)).filter(idx -> idx.asInteger() >= 0).forEach(this.myInsertedRows::add);
        this.shiftUpRow(rowIdx);
    }

    @NotNull
    private static <T> List<ModelIndex<T>> findBiggerIndices(@NotNull Collection<ModelIndex<T>> indexes, @NotNull ModelIndex<T> idx) {
        if (indexes == null) {
            MutationsStorage.$$$reportNull$$$0(11);
        }
        if (idx == null) {
            MutationsStorage.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.filter(indexes, i2 -> i2.asInteger() > idx.asInteger());
        if (list == null) {
            MutationsStorage.$$$reportNull$$$0(13);
        }
        return list;
    }

    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(14);
        }
        return this.isValidRow(row) && this.myModifiedRowsCounter.contains(row.asInteger());
    }

    @Nullable
    public MutationData get(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(15);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(16);
        }
        return this.myTypesMutationsStorage != null ? this.myTypesMutationsStorage.get(row, column2) : this.getInner(row, column2);
    }

    @Nullable
    private MutationData getInner(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(17);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(18);
        }
        int rowIdx = row.asInteger();
        int colIdx = column2.asInteger();
        return !this.isValid(row, column2) || rowIdx >= this.myRows || colIdx >= this.myColumns || this.myValues[rowIdx] == null ? null : this.myValues[rowIdx][colIdx];
    }

    public boolean hasChanges() {
        return !this.myModifiedRowsCounter.isEmpty() || !this.myInsertedRows.isEmpty() || !this.myDeletedRows.isEmpty() || !this.myDeletedColumns.isEmpty();
    }

    public int getModifiedRowsCount() {
        return this.myModifiedRowsCounter.myRowsSet.size();
    }

    private boolean isValidRow(@Nullable ModelIndex<DataConsumer.Row> row) {
        return this.isValid(row, null);
    }

    private boolean isValidColumn(@Nullable ModelIndex<DataConsumer.Column> column2) {
        return this.isValid(null, column2);
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row, @Nullable ModelIndex<DataConsumer.Column> column2) {
        return !(row != null && !row.isValid(this.myModel) && !this.isInsertedRow(row) || column2 != null && !column2.isValid(this.myModel) && !this.isInsertedColumn(column2));
    }

    private void increase(int rows, int columns) {
        this.myRows = rows >= this.myRows ? rows + 1 : this.myRows;
        this.myColumns = columns >= this.myColumns ? columns + 1 : this.myColumns;
    }

    private void countModifications(@Nullable CellMutation value2, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(19);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(20);
        }
        MutationData oldData = this.myValues[row.asInteger()] == null ? null : this.myValues[row.asInteger()][column2.asInteger()];
        this.myModifiedRowsCounter.countModifications(value2, oldData, row, column2);
        this.myRowsWithUnparsedValuesCounter.countModifications(value2, oldData, row, column2);
    }

    private void reallocate(int rows, int columns) {
        this.myMaxRows = rows >= this.myMaxRows ? this.getIncreasedValue(rows) : this.myMaxRows;
        this.myMaxColumns = columns >= this.myMaxColumns ? this.getIncreasedValue(columns) : this.myMaxColumns;
        this.increase(rows, columns);
        this.myValues = MutationsStorage.copy(this.myValues, this.myMaxRows, this.myMaxColumns);
        this.myModifiedRowsCounter.reallocate();
        this.myRowsWithUnparsedValuesCounter.reallocate();
    }

    public boolean hasUnparsedValues() {
        return !this.myRowsWithUnparsedValuesCounter.isEmpty();
    }

    public boolean hasUnparsedValues(ModelIndex<DataConsumer.Row> row) {
        return this.myRowsWithUnparsedValuesCounter.contains(row.asInteger());
    }

    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(21);
        }
        return this.myInsertedRows.contains(row);
    }

    public boolean isInsertedColumn(@NotNull ModelIndex<DataConsumer.Column> idx) {
        if (idx == null) {
            MutationsStorage.$$$reportNull$$$0(22);
        }
        return this.myInsertedColumns.containsKey(idx);
    }

    public int getInsertedRowsCount() {
        return this.myInsertedRows.size();
    }

    public int getInsertedColumnsCount() {
        return this.myInsertedColumns.size();
    }

    public int getDeletedRowsCount() {
        return this.myDeletedRows.size();
    }

    public int getDeletedColumnsCount() {
        return this.myDeletedColumns.size();
    }

    public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(23);
        }
        return this.myDeletedRows.contains(row);
    }

    public boolean isDeletedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(24);
        }
        return this.myDeletedColumns.contains(column2);
    }

    public boolean isDeletedRows(ModelIndexSet<DataConsumer.Row> rows) {
        return this.myDeletedRows.containsAll(rows.asList());
    }

    @Nullable
    public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
        return this.myInsertedRows.peek();
    }

    public JBIterable<ModelIndex<DataConsumer.Row>> getDeletedRows() {
        return JBIterable.from(this.myDeletedRows);
    }

    public JBIterable<ModelIndex<DataConsumer.Column>> getDeletedColumns() {
        return JBIterable.from(this.myDeletedColumns);
    }

    public JBIterable<ModelIndex<DataConsumer.Row>> getInsertedRows() {
        return JBIterable.from(this.myInsertedRows);
    }

    public JBIterable<ModelIndex<DataConsumer.Column>> getInsertedColumns() {
        return JBIterable.from(this.myInsertedColumns.keySet());
    }

    public void insertRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(25);
        }
        this.myInsertedRows.add(row);
    }

    public void insertColumn(@NotNull ModelIndex<DataConsumer.Column> idx, @NotNull DataConsumer.Column column2) {
        if (idx == null) {
            MutationsStorage.$$$reportNull$$$0(26);
        }
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(27);
        }
        this.myInsertedColumns.put(idx, column2);
    }

    public void renameColumn(@NotNull ModelIndex<DataConsumer.Column> idx, @NotNull String newName) {
        DataConsumer.Column column2;
        if (idx == null) {
            MutationsStorage.$$$reportNull$$$0(28);
        }
        if (newName == null) {
            MutationsStorage.$$$reportNull$$$0(29);
        }
        if ((column2 = this.myInsertedColumns.get(idx)) == null) {
            return;
        }
        this.myInsertedColumns.put(idx, new DataConsumer.Column(idx.asInteger(), newName, column2.getType(), column2.getTypeName(), column2.getJavaClassName()));
    }

    public void removeColumnFromDeleted(@NotNull ModelIndex<DataConsumer.Column> index2) {
        if (index2 == null) {
            MutationsStorage.$$$reportNull$$$0(30);
        }
        this.myDeletedColumns.remove(index2);
    }

    private void clearColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            MutationsStorage.$$$reportNull$$$0(31);
        }
        this.myInsertedColumns.remove(column2);
        this.myDeletedColumns.remove(column2);
        this.myModifiedRowsCounter.deleteColumn(column2);
        this.myRowsWithUnparsedValuesCounter.deleteColumn(column2);
        for (int i2 = 0; i2 < this.myMaxRows; ++i2) {
            if (this.myValues[i2] == null) continue;
            this.myValues[i2][column2.asInteger()] = null;
        }
    }

    public void removeRowFromDeleted(@NotNull ModelIndex<DataConsumer.Row> index2) {
        if (index2 == null) {
            MutationsStorage.$$$reportNull$$$0(32);
        }
        this.myDeletedRows.remove(index2);
    }

    public void clearRow(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            MutationsStorage.$$$reportNull$$$0(33);
        }
        this.myInsertedRows.remove(rowIdx);
        this.myDeletedRows.remove(rowIdx);
        if (rowIdx.asInteger() < this.myRows) {
            this.myValues[rowIdx.asInteger()] = null;
        }
        this.myModifiedRowsCounter.deleteRow(rowIdx);
        this.myRowsWithUnparsedValuesCounter.deleteRow(rowIdx);
    }

    public void clearColumns() {
        this.myInsertedColumns.clear();
        this.myDeletedColumns.clear();
    }

    @Nullable
    public DataConsumer.Column getInsertedColumn(ModelIndex<DataConsumer.Column> idx) {
        return this.myInsertedColumns.get(idx);
    }

    private static MutationData[] @NotNull [] copy(MutationData[] @NotNull [] from, int rows, int columns) {
        MutationData[][] newArray = new MutationData[rows][];
        for (int i2 = 0; i2 < from.length; ++i2) {
            if (from[i2] == null) continue;
            newArray[i2] = new MutationData[columns];
            System.arraycopy(from[i2], 0, newArray[i2], 0, from[i2].length);
        }
        return newArray;
    }

    private int getIncreasedValue(int value2) {
        return (int)Math.round((double)value2 * this.myMultiplier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 12: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedRows";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findBiggerIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allocateSpace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shiftUpColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shiftUpRow";
                break;
            }
            case 8: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteRow";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findBiggerIndices";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInner";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "countModifications";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedColumn";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "renameColumn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeColumnFromDeleted";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "clearColumn";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeRowFromDeleted";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "clearRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypedValue {
        private final ReservedCellValue myValue;
        private final Domain myDomain;

        TypedValue(@NotNull ReservedCellValue value2, @NotNull Domain domain) {
            if (value2 == null) {
                TypedValue.$$$reportNull$$$0(0);
            }
            if (domain == null) {
                TypedValue.$$$reportNull$$$0(1);
            }
            this.myValue = value2;
            this.myDomain = domain;
        }

        @Nullable
        static Object unwrap(@Nullable Object value2) {
            return value2 instanceof TypedValue ? ((TypedValue)value2).myValue : value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "domain";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/MutationsStorage$TypedValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TypesMutationsStorageImpl
    implements TypesMutationsStorage {
        private TypesMutationsStorageImpl() {
        }

        @Override
        public void setType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Domain domain) {
            if (row == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(1);
            }
            if (!MutationsStorage.this.isValid(row, column2)) {
                return;
            }
            MutationsStorage.this.allocateSpace(row, column2);
            MutationData mutationData = MutationsStorage.this.getInner(row, column2);
            Object databaseValue = MutationsStorage.this.myModel.getValueAt(row, column2);
            Object value2 = TypedValue.unwrap(mutationData != null ? mutationData.getValue() : (MutationsStorage.this.isInsertedColumn(column2) ? ReservedCellValue.UNSET : databaseValue));
            if (domain == null) {
                if (mutationData == null) {
                    return;
                }
                MutationsStorage.this.myValues[row.asInteger()][column2.asInteger()] = value2 == databaseValue ? null : new MutationData(value2);
            } else if (value2 instanceof ReservedCellValue || value2 == null) {
                ReservedCellValue notNullValue = (ReservedCellValue)((Object)ObjectUtils.notNull((Object)value2, (Object)((Object)ReservedCellValue.NULL)));
                MutationsStorage.this.myValues[row.asInteger()][column2.asInteger()] = new MutationData(new TypedValue(notNullValue, domain));
            }
        }

        @Override
        @Nullable
        public Domain getType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            MutationData data;
            if (row == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(2);
            }
            if (column2 == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(3);
            }
            return (data = MutationsStorage.this.getInner(row, column2)) != null && data.getValue() instanceof TypedValue ? ((TypedValue)data.getValue()).myDomain : null;
        }

        public MutationData get(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(4);
            }
            if (column2 == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(5);
            }
            if (!MutationsStorage.this.isValid(row, column2)) {
                return null;
            }
            MutationData data = MutationsStorage.this.getInner(row, column2);
            if (data == null || !(data.getValue() instanceof TypedValue)) {
                return data;
            }
            TypedValue value2 = (TypedValue)data.getValue();
            return this.getFromDatabase(row, column2) == value2.myValue ? null : new MutationData((Object)value2.myValue);
        }

        private Object getFromDatabase(ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
            return MutationsStorage.this.isValid(row, column2) ? MutationsStorage.this.myModel.getValueAt(row, column2) : null;
        }

        public boolean equalToDatabase(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(6);
            }
            if (column2 == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(7);
            }
            if (!MutationsStorage.this.isValid(row, column2) || MutationsStorage.this.isInsertedRow(row) || MutationsStorage.this.isInsertedColumn(column2)) {
                return TypedValue.unwrap(value2) == ReservedCellValue.UNSET;
            }
            Object databaseValue = MutationsStorage.this.myModel.getValueAt(row, column2);
            return ObjectUtils.notNull((Object)TypedValue.unwrap(databaseValue), (Object)((Object)ReservedCellValue.NULL)) == ObjectUtils.notNull((Object)TypedValue.unwrap(value2), (Object)((Object)ReservedCellValue.NULL));
        }

        public Object fixNewValue(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(8);
            }
            if (column2 == null) {
                TypesMutationsStorageImpl.$$$reportNull$$$0(9);
            }
            if (!MutationsStorage.this.isValid(row, column2)) {
                return value2;
            }
            MutationData currentValue = MutationsStorage.this.getInner(row, column2);
            return currentValue != null && currentValue.getValue() instanceof TypedValue && value2 instanceof ReservedCellValue ? new TypedValue((ReservedCellValue)((Object)value2), ((TypedValue)currentValue.getValue()).myDomain) : value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage$TypesMutationsStorageImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equalToDatabase";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fixNewValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RowsWithUnparsedValuesCounter
    extends RowsCounter {
        private RowsWithUnparsedValuesCounter() {
        }

        @Override
        protected int countModificationsInner(@Nullable CellMutation value2, @Nullable MutationData oldValue, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                RowsWithUnparsedValuesCounter.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                RowsWithUnparsedValuesCounter.$$$reportNull$$$0(1);
            }
            return this.unwrap(value2) instanceof UnparsedValue && !(this.unwrap(oldValue) instanceof UnparsedValue) ? 1 : (this.unwrap(oldValue) instanceof UnparsedValue && !(this.unwrap(value2) instanceof UnparsedValue) ? -1 : 0);
        }

        @Nullable
        private Object unwrap(@Nullable CellMutation value2) {
            return value2 == null ? null : value2.getValue();
        }

        @Nullable
        private Object unwrap(@Nullable MutationData value2) {
            return value2 == null ? null : value2.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/MutationsStorage$RowsWithUnparsedValuesCounter";
            objectArray[2] = "countModificationsInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModifiedRowsCounter
    extends RowsCounter {
        private ModifiedRowsCounter() {
        }

        @Override
        protected int countModificationsInner(@Nullable CellMutation value2, @Nullable MutationData oldValue, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            boolean oldValueEqualToDatabase;
            if (row == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(1);
            }
            boolean newValueEqualToDatabase = value2 == null || this.equalToDatabase(value2.getValue(), row, column2);
            boolean bl = oldValueEqualToDatabase = oldValue == null || this.equalToDatabase(oldValue.getValue(), row, column2);
            return !newValueEqualToDatabase && oldValueEqualToDatabase ? 1 : (!oldValueEqualToDatabase && newValueEqualToDatabase ? -1 : 0);
        }

        boolean equalToDatabase(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(2);
            }
            if (column2 == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(3);
            }
            return MutationsStorage.this.myTypesMutationsStorage != null ? MutationsStorage.this.myTypesMutationsStorage.equalToDatabase(value2, row, column2) : value2 == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage$ModifiedRowsCounter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countModificationsInner";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equalToDatabase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class RowsCounter {
        private final TIntHashSet myRowsSet;
        private int[] myCount;

        RowsCounter() {
            this.myCount = new int[MutationsStorage.this.myMaxRows];
            this.myRowsSet = new TIntHashSet();
        }

        void shiftUp(@NotNull ModelIndex<DataConsumer.Row> row) {
            int[] oldModifiedRows;
            if (row == null) {
                RowsCounter.$$$reportNull$$$0(0);
            }
            int idx = row.asInteger();
            System.arraycopy(this.myCount, idx + 1, this.myCount, idx, MutationsStorage.this.myRows - 1 - idx);
            this.myCount[MutationsStorage.this.myRows - 1] = 0;
            this.myRowsSet.remove(idx);
            TIntHashSet newRowsSet = new TIntHashSet();
            for (int oldRowIdx : oldModifiedRows = this.myRowsSet.toArray()) {
                if (oldRowIdx > idx) {
                    newRowsSet.add(oldRowIdx - 1);
                    continue;
                }
                newRowsSet.add(oldRowIdx);
            }
            this.myRowsSet.clear();
            this.myRowsSet.addAll(newRowsSet.toArray());
        }

        void deleteColumn(@NotNull ModelIndex<DataConsumer.Column> idx) {
            if (idx == null) {
                RowsCounter.$$$reportNull$$$0(1);
            }
            for (int i2 = 0; i2 < MutationsStorage.this.myMaxRows; ++i2) {
                MutationData oldValue = MutationsStorage.this.myValues[i2] == null ? null : MutationsStorage.this.myValues[i2][idx.asInteger()];
                this.countModifications(null, oldValue, ModelIndex.forRow(MutationsStorage.this.myModel, i2), idx);
            }
        }

        void deleteRow(@NotNull ModelIndex<DataConsumer.Row> idx) {
            int i2;
            if (idx == null) {
                RowsCounter.$$$reportNull$$$0(2);
            }
            if ((i2 = idx.asInteger()) < MutationsStorage.this.myRows) {
                this.myCount[i2] = 0;
            }
            this.myRowsSet.remove(i2);
        }

        public boolean isEmpty() {
            return this.myRowsSet.isEmpty();
        }

        public void clear() {
            this.myCount = new int[MutationsStorage.this.myMaxRows];
            this.myRowsSet.clear();
        }

        public boolean contains(int row) {
            return this.myRowsSet.contains(row);
        }

        public void countModifications(@Nullable CellMutation value2, @Nullable MutationData oldValue, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                RowsCounter.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                RowsCounter.$$$reportNull$$$0(4);
            }
            int n = row.asInteger();
            this.myCount[n] = this.myCount[n] + this.countModificationsInner(value2, oldValue, row, column2);
            if (this.myCount[row.asInteger()] > 0) {
                this.myRowsSet.add(row.asInteger());
                return;
            }
            this.myRowsSet.remove(row.asInteger());
        }

        protected abstract int countModificationsInner(@Nullable CellMutation var1, @Nullable MutationData var2, @NotNull ModelIndex<DataConsumer.Row> var3, @NotNull ModelIndex<DataConsumer.Column> var4);

        public void reallocate() {
            int[] myNewCount = new int[MutationsStorage.this.myMaxRows];
            System.arraycopy(this.myCount, 0, myNewCount, 0, this.myCount.length);
            this.myCount = myNewCount;
        }

        public int @NotNull [] toArray() {
            int[] nArray = this.myRowsSet.toArray();
            if (nArray == null) {
                RowsCounter.$$$reportNull$$$0(5);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idx";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/MutationsStorage$RowsCounter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage$RowsCounter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "shiftUp";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRow";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "countModifications";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

