/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/debugger/SqlProgramSource;", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "modelElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/database/model/ObjectKind;Lcom/intellij/database/model/basic/BasicSourceAware;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiFile;)V", "getKind", "()Lcom/intellij/database/model/ObjectKind;", "lineOffsets", "", "getModelElement", "()Lcom/intellij/database/model/basic/BasicSourceAware;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "calculateLineOffsets", "getLineOffset", "", "lineNr", "intellij.database.impl"})
public final class SqlProgramSource {
    private int[] lineOffsets;
    @NotNull
    private final ObjectKind kind;
    @Nullable
    private final BasicSourceAware modelElement;
    @NotNull
    private final VirtualFile virtualFile;
    @Nullable
    private final PsiFile psiFile;

    public final int getLineOffset(int lineNr) {
        if (lineNr <= 1) {
            return 0;
        }
        int[] lo = this.lineOffsets;
        if (lo == null) {
            this.lineOffsets = lo = this.calculateLineOffsets();
        }
        int[] nArray = lo;
        boolean bl = false;
        if (nArray.length == 0) {
            return 0;
        }
        return lineNr <= lo.length ? lo[lineNr - 1] : ArraysKt.last((int[])lo);
    }

    private final int[] calculateLineOffsets() {
        if (this.psiFile == null) {
            return new int[0];
        }
        String string = this.psiFile.getText();
        if (string == null) {
            return new int[0];
        }
        String text2 = string;
        return SqlProgramSourceKt.calculateLineOffsets(text2);
    }

    @NotNull
    public final ObjectKind getKind() {
        return this.kind;
    }

    @Nullable
    public final BasicSourceAware getModelElement() {
        return this.modelElement;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    public SqlProgramSource(@NotNull ObjectKind kind, @Nullable BasicSourceAware modelElement, @NotNull VirtualFile virtualFile, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.kind = kind;
        this.modelElement = modelElement;
        this.virtualFile = virtualFile;
        this.psiFile = psiFile;
    }
}

