/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataExtractorProperties {
    private static final String CURRENT_ID = "database.data.extractors.current.id";
    private static final String CURRENT_EXPORT_ID = "database.data.extractors.current.export.id";
    private static final String SKIP_GENERATED = "database.data.extractors.sql.skip.generated";
    private static final String SKIP_COMPUTED = "database.data.extractors.sql.skip.computed";
    private static final String CREATE_TABLE = "database.data.extractors.sql.create.table";
    private static final String INCLUDE_QUERY = "database.data.extractors.include.query";
    private static final String OUTPUT_DIR = "database.data.extractors.output.dir";
    private static final List<String> FALSE_AS_DEFAULT_PROPS = Arrays.asList("database.data.extractors.sql.create.table", "database.data.extractors.sql.skip.generated");

    private DataExtractorProperties() {
    }

    @NotNull
    public static DataExtractorFactory.Text getCurrentExtractorFactory(@Nullable Project project) {
        PropertiesComponent storage = project == null ? null : PropertiesComponent.getInstance((Project)project);
        String factoryId = storage != null ? storage.getValue(CURRENT_ID) : null;
        DataExtractorFactory factory = factoryId == null ? null : DataExtractorFactories.findById(factoryId);
        DataExtractorFactory.Text text2 = (DataExtractorFactory.Text)ObjectUtils.tryCast((Object)factory, DataExtractorFactory.Text.class);
        DataExtractorFactory.Text text3 = text2 != null ? text2 : DataExtractorFactories.getDefault();
        if (text3 == null) {
            DataExtractorProperties.$$$reportNull$$$0(0);
        }
        return text3;
    }

    @NotNull
    public static DataExtractorFactory getCurrentExportExtractorFactory(@Nullable Project project) {
        PropertiesComponent storage = project == null ? null : PropertiesComponent.getInstance((Project)project);
        String factoryId = storage != null ? storage.getValue(CURRENT_EXPORT_ID) : null;
        DataExtractorFactory factory = factoryId == null ? null : DataExtractorFactories.findById(factoryId);
        return factory != null ? factory : DataExtractorProperties.getCurrentExtractorFactory(project);
    }

    public static void setCurrentExtractorFactory(@NotNull Project project, @NotNull DataExtractorFactory.Text f) {
        if (project == null) {
            DataExtractorProperties.$$$reportNull$$$0(1);
        }
        if (f == null) {
            DataExtractorProperties.$$$reportNull$$$0(2);
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
        component.setValue(CURRENT_ID, f.getId());
    }

    public static void setCurrentExportExtractorFactory(@NotNull Project project, @NotNull DataExtractorFactory f) {
        if (project == null) {
            DataExtractorProperties.$$$reportNull$$$0(3);
        }
        if (f == null) {
            DataExtractorProperties.$$$reportNull$$$0(4);
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
        component.setValue(CURRENT_EXPORT_ID, f.getId());
    }

    public static boolean isSkipGeneratedColumns() {
        return DataExtractorProperties.getAppProperty(SKIP_GENERATED);
    }

    public static void setSkipGeneratedColumns(boolean value2) {
        DataExtractorProperties.setAppProperty(SKIP_GENERATED, value2);
    }

    public static boolean isSkipComputed() {
        return DataExtractorProperties.getAppProperty(SKIP_COMPUTED);
    }

    public static void setSkipComputed(boolean value2) {
        DataExtractorProperties.setAppProperty(SKIP_COMPUTED, value2);
    }

    public static boolean isIncludeCreateTable() {
        return DataExtractorProperties.getAppProperty(CREATE_TABLE);
    }

    public static void setIncludeCreateTable(boolean value2) {
        DataExtractorProperties.setAppProperty(CREATE_TABLE, value2);
    }

    public static boolean isIncludeQuery() {
        return DataExtractorProperties.getAppProperty(INCLUDE_QUERY);
    }

    public static void setIncludeQuery(boolean value2) {
        DataExtractorProperties.setAppProperty(INCLUDE_QUERY, value2);
    }

    public static void setOutputDir(String value2) {
        if (DataExtractorProperties.getDefaultOutputDir().equals(value2) || StringUtil.isEmptyOrSpaces((String)value2)) {
            DataExtractorProperties.setAppProperty(OUTPUT_DIR, null);
        } else {
            DataExtractorProperties.setAppProperty(OUTPUT_DIR, value2);
        }
    }

    @NotNull
    public static String getOutputDir() {
        String value2 = PropertiesComponent.getInstance().getValue(OUTPUT_DIR);
        return value2 != null && !StringUtil.isEmptyOrSpaces((String)value2) ? value2 : DataExtractorProperties.getDefaultOutputDir();
    }

    @NotNull
    private static String getDefaultOutputDir() {
        String string = SystemProperties.getUserHome();
        if (string == null) {
            DataExtractorProperties.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean getAppProperty(@NotNull String property) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(6);
        }
        boolean defaultValue = !FALSE_AS_DEFAULT_PROPS.contains(property);
        return PropertiesComponent.getInstance().getBoolean(property, defaultValue);
    }

    private static void setAppProperty(@NotNull String property, boolean value2) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(7);
        }
        boolean defaultValue = !FALSE_AS_DEFAULT_PROPS.contains(property);
        PropertiesComponent.getInstance().setValue(property, value2, defaultValue);
    }

    private static void setAppProperty(@NotNull String property, @Nullable String value2) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(8);
        }
        PropertiesComponent.getInstance().setValue(property, value2);
    }

    @NotNull
    private static String getStringAppProperty(@NotNull String property) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(9);
        }
        String string = PropertiesComponent.getInstance().getValue(property, "");
        if (string == null) {
            DataExtractorProperties.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DataExtractorProperties";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DataExtractorProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOutputDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringAppProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentExtractorFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentExportExtractorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAppProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAppProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStringAppProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

