/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries.impl;

import com.intellij.database.layoutedQueries.impl.AdaptIntermediateCursor;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.exceptions.DBFetchingException;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateCursor;
import com.intellij.database.remote.jdba.util.Classes;
import com.intellij.database.remote.jdba.util.Collects;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class AdaptIntermediateStructCollectingCursor<T>
extends AdaptIntermediateCursor<T, List<Object[]>> {
    @NotNull
    private ResultLayout<T> myResultLayout;
    @NotNull
    private final Constructor myRowConstructor;
    @NotNull
    private final Field[] myRowClassFields;
    private transient Collection myContainer;
    private boolean myHasRows;

    public AdaptIntermediateStructCollectingCursor(@NotNull PrimeIntermediateCursor<List<Object[]>> remoteCursor, @NotNull ResultLayout<T> resultLayout) {
        if (remoteCursor == null) {
            AdaptIntermediateStructCollectingCursor.$$$reportNull$$$0(0);
        }
        if (resultLayout == null) {
            AdaptIntermediateStructCollectingCursor.$$$reportNull$$$0(1);
        }
        super(remoteCursor);
        assert (resultLayout.kind == ResultLayout.Kind.SINGLE_ROW || resultLayout.kind == ResultLayout.Kind.ARRAY || resultLayout.kind == ResultLayout.Kind.LIST || resultLayout.kind == ResultLayout.Kind.SET);
        assert (resultLayout.row.kind == RowLayout.Kind.STRUCT);
        Class rowClass = resultLayout.row.rowClass;
        this.myResultLayout = resultLayout;
        this.myRowConstructor = Classes.defaultConstructorOf((Class)rowClass);
        this.myRowConstructor.setAccessible(true);
        Object[] components = this.myResultLayout.row.components;
        int n = components.length;
        this.myRowClassFields = new Field[n];
        this.myHasRows = remoteCursor.hasRows();
        if (!this.hasRows()) {
            return;
        }
        boolean somethingMatched = false;
        for (int i2 = 0; i2 < n; ++i2) {
            String name = components[i2].name;
            try {
                Field field = rowClass.getDeclaredField(name);
                field.setAccessible(true);
                this.myRowClassFields[i2] = field;
                somethingMatched = true;
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (!somethingMatched) {
            String msg = String.format("The query result and the class %s have no common fields. Fields of the class: [%s].", rowClass.getName(), Collects.arrayToString((Object[])components, (String)", "));
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public boolean hasRows() {
        return this.myHasRows && super.hasRows();
    }

    public synchronized T fetch() {
        int n;
        List data;
        if (this.hasRows()) {
            data = (List)this.myRemoteCursor.fetch();
            n = data.size();
        } else {
            data = Collections.emptyList();
            n = 0;
        }
        this.prepareContainer(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Object row = this.makeRow((Object[])data.get(i2));
            this.myContainer.add(row);
        }
        return this.completeCollection();
    }

    private void prepareContainer(int capacity) {
        switch (this.myResultLayout.kind) {
            case SINGLE_ROW: 
            case ARRAY: 
            case LIST: {
                this.myContainer = new ArrayList(capacity);
                break;
            }
            case SET: {
                this.myContainer = this.myResultLayout.sorted ? new TreeSet() : new HashSet(capacity);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown how to collect a " + this.myResultLayout.kind);
            }
        }
    }

    private Object makeRow(Object[] componentValues) {
        Object row;
        try {
            row = this.myRowConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DBFetchingException(String.format("Failed to instantiate class %s: error %s: %s", this.myResultLayout.row.rowClass.getName(), e.getClass().getSimpleName(), e.getMessage()), e, null);
        }
        int n = this.myRowClassFields.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Field f = this.myRowClassFields[i2];
            Object value2 = componentValues[i2];
            if (value2 == null) continue;
            try {
                f.set(row, value2);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new DBFetchingException(String.format("Failed to assign field %s of class %s with a value of class %s: error %s: %s. The value: \"%s\"", f.getName(), row.getClass().getName(), value2.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage(), value2.toString()), (Exception)e, null);
            }
        }
        return row;
    }

    private T completeCollection() {
        Object[] result2;
        switch (this.myResultLayout.kind) {
            case SINGLE_ROW: {
                result2 = !this.myContainer.isEmpty() ? this.myContainer.iterator().next() : null;
                break;
            }
            case ARRAY: {
                int n = this.myContainer.size();
                Object[] array = (Object[])Array.newInstance(this.myResultLayout.row.rowClass, n);
                result2 = this.myContainer.toArray(array);
                break;
            }
            case LIST: {
                result2 = this.myContainer;
                break;
            }
            case SET: {
                result2 = this.myContainer;
                break;
            }
            default: {
                result2 = null;
                assert (false);
                break;
            }
        }
        return (T)result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "remoteCursor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resultLayout";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/layoutedQueries/impl/AdaptIntermediateStructCollectingCursor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

