/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import org.jetbrains.annotations.Nullable;

public enum ArgumentDirection {
    IN('I'),
    INOUT('M'),
    OUT('O'),
    RETURN('R'),
    RESULT('T'),
    SELF('S');

    public final char code;

    private ArgumentDirection(char code) {
        this.code = code;
    }

    @Nullable
    public static ArgumentDirection of(char code) {
        switch (Character.toUpperCase(code)) {
            case 'I': {
                return IN;
            }
            case 'M': {
                return INOUT;
            }
            case 'O': {
                return OUT;
            }
            case 'R': {
                return RETURN;
            }
            case 'T': {
                return RESULT;
            }
            case 'S': {
                return SELF;
            }
        }
        return null;
    }

    public boolean isIn() {
        return this == IN || this == INOUT;
    }

    public boolean isOut() {
        return this == INOUT || this == OUT;
    }

    public boolean isReturnOrResult() {
        return this == RETURN || this == RESULT;
    }
}

