/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.TIntArrayList;
import io.github.xstream.mxparser.MXParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.xmlpull.v1.XmlPullParser;

public final class DataSourceSnapshotManager {
    public static final DataSourceSnapshotManager INSTANCE = new DataSourceSnapshotManager();
    public static final boolean IGNORE_AUTO_MINI_CAT = !Registry.is((String)"database.snapshots.auto");
    private static boolean ourEmptyMiniCat = false;
    private final Map<Dbms, Map<Couple<Version>, Object>> myModels = ConcurrentFactoryMap.create(k -> ContainerUtil.createConcurrentSoftValueMap(), ContainerUtil::createConcurrentSoftValueMap);
    private final Map<BasicHierarchicalObject, BasicSnippet> myHiddenNamespacesCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    @TestOnly
    public static void setEmptyMiniCat(@NotNull Disposable p2) {
        if (p2 == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(0);
        }
        ourEmptyMiniCat = true;
        Disposer.register((Disposable)p2, () -> {
            ourEmptyMiniCat = false;
        });
    }

    public void apply(@Nullable Project project, @NotNull LocalDataSource dataSource2) {
        BaseModel model;
        if (dataSource2 == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(1);
        }
        if ((model = (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class)) == null) {
            return;
        }
        DataSourceSchemaMapping mapping = dataSource2.getSchemaMapping();
        DbImplUtilCore.performSrcOperation(null, model, ModalityState.defaultModalityState(), true, () -> model.modify(model.getRoot(), BasicModRoot.class, true, r -> {
            int autoMappedWildcards = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoot(r)).expandAndFilter(o -> o instanceof BasicNamespace || o instanceof BasicRoot)).traverse().filter(e -> this.isAutoMappedWildCard((BasicElement)e, mapping)).filterMap(e -> e.getDatabase()).unique().size();
            if (autoMappedWildcards > 10) {
                dataSource2.getSchemaMapping().setUseMiniCat(false);
                PlatformIdeService.getInstance().notification("Database view", PlatformIdeService.NotificationType.INFORMATION, DatabaseBundle.message("notification.title.too.many.pre.introspected.objects.are.used", new Object[0]), dataSource2.getName(), DatabaseBundle.message("notification.content.to.improve.performance.automatic.usage.pre.introspected.objects.disabled.you.can.select.necessary.schemas.manually", new Object[0]), project);
            }
            ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoot(r)).expandAndFilter(o -> o instanceof BasicNamespace || o instanceof BasicRoot)).filter(BasicHierarchicalObject.class).forEach(e -> this.merge((BasicHierarchicalObject)e, mapping));
        }));
    }

    public void clearOrReviveNamespaces(@NotNull BasicModModel model, @NotNull TreePattern scope) {
        if (model == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(3);
        }
        model.modify(BasicModRoot.class, r -> {
            for (BasicHierarchicalObject nsp : ((JBTreeTraverser)model.traverser().expandAndFilter(Conditions.instanceOf(BasicModNamespace.class))).bfsTraversal().filter(BasicMateNamespace.class).filter(BasicHierarchicalObject.class)) {
                if (((BasicMateNamespace)((Object)nsp)).isSubstituted()) continue;
                boolean introspected = DataSourceSchemaMapping.isIntrospected(scope, nsp);
                if (introspected) {
                    BasicSnippet snippet = this.myHiddenNamespacesCache.remove(nsp);
                    if (snippet == null || nsp.hasChildren()) continue;
                    snippet.recover(nsp);
                    continue;
                }
                if (!nsp.hasChildren()) continue;
                this.myHiddenNamespacesCache.put(nsp, BasicSnippet.build(nsp, this.myHiddenNamespacesCache));
                ((BaseModel)model).preserveSources(() -> {
                    for (ModFamily modFamily : nsp.getFamilies()) {
                        if (modFamily.getMetaObject().kindOf(BasicMateNamespace.class)) continue;
                        modFamily.clear();
                    }
                });
            }
        });
    }

    private void merge(@NotNull BasicHierarchicalObject e, @NotNull DataSourceSchemaMapping mapping) {
        Pair<String, ObjectPath> map2;
        BasicModel miniMod;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(5);
        }
        BasicModel basicModel = miniMod = (map2 = this.map(e, mapping)) == null ? null : this.getSnapshotModel(e);
        if (miniMod == null) {
            if (e instanceof BasicModMateNamespace) {
                ((BasicModMateNamespace)((Object)e)).setSubstituted(false);
            }
            return;
        }
        JBIterable<DasObject> objs = QNameUtil.findByPath(miniMod, (ObjectPath)map2.second);
        for (BasicHierarchicalObject target : objs.filter(BasicHierarchicalObject.class)) {
            DataSourceSnapshotManager.merge(e, target, true);
        }
    }

    @Nullable
    public Pair<String, ObjectPath> map(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(6);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(7);
        }
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return null;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return map2;
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return null;
        }
        return this.mapAuto(e, mapping);
    }

    @Nullable
    private Pair<String, ObjectPath> mapAuto(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        BasicDatabase db;
        ObjectPath basePath;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(8);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(9);
        }
        if (e.getKind() != ObjectKind.SCHEMA && e.getKind() != ObjectKind.DATABASE) {
            return null;
        }
        BasicNamespace nsp = (BasicNamespace)ObjectUtils.tryCast((Object)e, BasicNamespace.class);
        ObjectPath objectPath = basePath = nsp == null ? null : this.getBasePath(nsp);
        if (basePath == null) {
            return null;
        }
        ObjectPath dbPath = basePath.findParent(ObjectKind.DATABASE, false);
        if (dbPath != null && StringUtil.isEmpty((String)dbPath.name) && (db = e.getDatabase()) != null && !mapping.isIntrospected(db)) {
            return null;
        }
        return Pair.create((Object)"minicat", (Object)basePath);
    }

    private boolean isAutoMappedWildCard(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(10);
        }
        if (mapping == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(11);
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return false;
        }
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return false;
        }
        Pair<String, ObjectPath> map2 = mapping.map(path);
        if (map2 != null) {
            return false;
        }
        map2 = this.mapAuto(e, mapping);
        if (map2 == null) {
            return false;
        }
        ObjectPath db = ((ObjectPath)map2.second).findParent(ObjectKind.DATABASE, false);
        return db != null && StringUtil.isEmpty((String)db.name);
    }

    @Nullable
    private static BasicHierarchicalObject merge(@NotNull BasicHierarchicalObject e, @Nullable BasicHierarchicalObject target, boolean apply2) {
        BasicHierarchicalObject te;
        boolean exact;
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(12);
        }
        if (target == null) {
            return null;
        }
        boolean bl = exact = e.getMetaObject() == target.getMetaObject();
        if (exact) {
            te = e;
        } else {
            te = DataSourceSnapshotManager.merge(e, (BasicHierarchicalObject)target.getParent(), false);
            ObjectPath tp = BasicPaths.of(target);
            BasicHierarchicalObject basicHierarchicalObject = te = te == null ? null : (BasicHierarchicalObject)SqlModelBuilderUtils.createObject(te, tp.name, tp.isQuoted(), tp.getIdentity(), tp.kind);
            if (te == null) {
                return null;
            }
        }
        if (apply2) {
            if (te instanceof BasicModMateNamespace) {
                ((BasicModMateNamespace)((Object)te)).setSubstituted(true);
            }
            DataSourceSnapshotManager.substituteChildren(te, target);
        }
        return te;
    }

    public static void substituteChildren(@NotNull BasicHierarchicalObject where, @NotNull BasicHierarchicalObject what) {
        if (where == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(13);
        }
        if (what == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(14);
        }
        for (ModFamily modFamily : where.getFamilies()) {
            DataSourceSnapshotManager.substituteFamily(what, modFamily.asHierarchical());
        }
    }

    @NotNull
    private static ModFamily<? extends BasicHierarchicalObject> sameFamily(BasicHierarchicalObject e, ModFamily<? extends BasicHierarchicalObject> f) {
        ModFamily<BasicHierarchicalObject> modFamily = ((ModFamily)Objects.requireNonNull(e.familyOf(f.getMetaObject().kind))).asHierarchical();
        if (modFamily == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(15);
        }
        return modFamily;
    }

    private static void substitute(@NotNull BasicHierarchicalObject self, @NotNull BasicHierarchicalObject what, boolean recursive) {
        if (self == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(16);
        }
        if (what == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(17);
        }
        assert (what.getMetaObject() == self.getMetaObject()) : "Wrong object";
        BasicDataObject data = what.frozenData();
        if (self.hasData(data)) {
            return;
        }
        self.applyData(data);
        if (recursive) {
            for (ModFamily modFamily : self.getFamilies()) {
                DataSourceSnapshotManager.substituteFamily(what, modFamily.asHierarchical());
            }
        }
    }

    private static void substituteFamily(@NotNull BasicHierarchicalObject what, ModFamily<? extends BasicHierarchicalObject> family) {
        if (what == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(18);
        }
        DataSourceSnapshotManager.substituteFamilies(DataSourceSnapshotManager.sameFamily(what, family), family);
    }

    private static void substituteFamilies(@NotNull ModFamily<? extends BasicHierarchicalObject> what, @NotNull ModFamily<? extends BasicHierarchicalObject> where) {
        if (what == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(19);
        }
        if (where == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(20);
        }
        assert (what.getMetaObject() == where.getMetaObject()) : "Wrong object";
        if (where.size() == what.size()) {
            Iterator fromIt = what.iterator();
            Iterator iterator = where.iterator();
            while (fromIt.hasNext() && iterator.hasNext()) {
                DataSourceSnapshotManager.substitute((BasicHierarchicalObject)iterator.next(), (BasicHierarchicalObject)fromIt.next(), true);
            }
        } else {
            where.clear();
            for (BasicHierarchicalObject basicHierarchicalObject : what) {
                DataSourceSnapshotManager.substituteChildren(where.createNewOne(basicHierarchicalObject.frozenData()), basicHierarchicalObject);
            }
        }
    }

    private BasicModel getSnapshotModel(@NotNull BasicElement e) {
        if (e == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(21);
        }
        Dbms dbms = e.getMetaObject().getModel().getDbms();
        BasicModel model = e.getModel();
        Version version = (Version)ObjectUtils.notNull((Object)(model == null ? null : model.getRoot().getServerVersion()), (Object)Version.INFINITY);
        return this.getSnapshotModel(dbms, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BasicModel getSnapshotModel(@NotNull Dbms dbms, @NotNull Version version) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(22);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(23);
        }
        if (ourEmptyMiniCat) {
            return null;
        }
        Map<Couple<Version>, Object> models = this.myModels.get(dbms);
        Object res2 = DataSourceSnapshotManager.findModel(models, version);
        if (res2 == null) {
            Map<Couple<Version>, Object> map2 = models;
            synchronized (map2) {
                res2 = DataSourceSnapshotManager.findModel(models, version);
                if (res2 == null) {
                    Pair<Couple<Version>, BasicModel> loaded = DataSourceSnapshotManager.loadModel(dbms, version);
                    if (loaded == null) {
                        models.put((Couple<Version>)Couple.of((Object)Version.ZERO, (Object)Version.INFINITY), ObjectUtils.NULL);
                        return null;
                    }
                    models.put((Couple<Version>)((Couple)loaded.first), loaded.second);
                    return (BasicModel)loaded.second;
                }
            }
        }
        return res2 == ObjectUtils.NULL ? null : (BasicModel)res2;
    }

    @Nullable
    public ModelNameIndex getSnapshotModelIndex(@NotNull Dbms dbms, @NotNull Version version) {
        BasicModel model;
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(24);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(25);
        }
        return (model = this.getSnapshotModel(dbms, version)) instanceof BaseModel ? model.getNameIndex() : null;
    }

    @Nullable
    private static Object findModel(@NotNull Map<Couple<Version>, ?> models, @NotNull Version version) {
        if (models == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(26);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(27);
        }
        for (Map.Entry<Couple<Version>, ?> entry : models.entrySet()) {
            if (!version.isOrGreater((Version)entry.getKey().first) || version.isOrGreater((Version)entry.getKey().second) && version != Version.INFINITY) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean canSubstitute(@NotNull BasicNamespace nsp, boolean ignoreWildcard) {
        BasicModel snap;
        if (nsp == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(28);
        }
        if ((snap = this.getSnapshotModel(nsp)) == null) {
            return false;
        }
        JBIterable targets2 = DataSourceSnapshotManager.getTargets((BasicHierarchicalObject)((Object)nsp), snap.getRoot());
        if (ignoreWildcard) {
            targets2 = targets2.filter(o -> !o.getName().isEmpty());
        }
        return targets2.isNotEmpty();
    }

    @Nullable
    public ObjectPath getBasePath(@NotNull BasicNamespace nsp) {
        BasicModel snap;
        if (nsp == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(29);
        }
        if ((snap = this.getSnapshotModel(nsp)) == null) {
            return null;
        }
        BasicElement tgt = (BasicElement)DataSourceSnapshotManager.getTargets((BasicHierarchicalObject)((Object)nsp), snap.getRoot()).first();
        return tgt == null ? null : (ObjectPath)BasicPaths.of(tgt).reduce(null, (parent2, cur2) -> cur2.getIdentity() == null && parent2 == cur2.parent ? cur2 : ObjectPath.create(cur2.name, cur2.kind, cur2.isQuoted(), null, parent2));
    }

    @NotNull
    private static JBIterable<BasicElement> getTargets(@NotNull BasicHierarchicalObject to, @NotNull BasicRoot r) {
        if (to == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(30);
        }
        if (r == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(31);
        }
        if (to instanceof BasicRoot) {
            JBIterable jBIterable = JBIterable.of((Object)r);
            if (jBIterable == null) {
                DataSourceSnapshotManager.$$$reportNull$$$0(32);
            }
            return jBIterable;
        }
        if (to.getParent() == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DataSourceSnapshotManager.$$$reportNull$$$0(33);
            }
            return jBIterable;
        }
        JBIterable<BasicElement> targets2 = DataSourceSnapshotManager.getTargets((BasicHierarchicalObject)to.getParent(), r);
        JBIterable jBIterable = targets2.flatten(o -> JBIterable.of((Object[])new String[]{"", to.getName()}).filterMap(name -> (BasicElement)o.getChildren().filter(c2 -> c2.getKind() == to.getKind() && c2.getName().equals(name)).first()));
        if (jBIterable == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(35);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(36);
        }
        try (InputStream is = DataSourceSnapshotManager.getMiniCatStream(dbms);){
            if (is == null) {
                Pair<Couple<Version>, BasicModel> pair2 = null;
                return pair2;
            }
            Pair<Couple<Version>, BasicModel> pair = DataSourceSnapshotManager.loadModel(dbms, version, is);
            return pair;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getMiniCatStream(@NotNull Dbms dbms) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(37);
        }
        String name = dbms == Dbms.HSQL ? "hsql" : StringUtil.toLowerCase((String)dbms.getName());
        Class<?> ctx = DbImplUtilCore.getDatabaseDialect(dbms).getClass();
        InputStream res2 = ctx.getResourceAsStream("/" + ctx.getPackage().getName().replace('.', '/') + "/" + name + ".minicat.xml");
        if (res2 != null) {
            return res2;
        }
        if (dbms == Dbms.MARIA) {
            name = "maria";
        }
        return ctx.getResourceAsStream("/" + name + ".xml");
    }

    @NotNull
    public static Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version, InputStream is) {
        if (dbms == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(38);
        }
        if (version == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(39);
        }
        ModelImporter importer = new ModelImporter(new ModelFactory(BlackHoleTextStorage.INSTANCE));
        importer.expectedVersion = version;
        importer.currentFormat = true;
        BasicModModel model = importer.deserialize((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), (XmlPullParser)new MXParser()), dbms.getName() + "/minicat");
        ((BaseModel)model).setFrozen(true);
        Pair pair = Pair.create((Object)Couple.of((Object)importer.versionRange[0], (Object)importer.versionRange[1]), (Object)model);
        if (pair == null) {
            DataSourceSnapshotManager.$$$reportNull$$$0(40);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/DataSourceSnapshotManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 22: 
            case 24: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/DataSourceSnapshotManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sameFamily";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyMiniCat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearOrReviveNamespaces";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mapAuto";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAutoMappedWildCard";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "substituteChildren";
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 40: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "substituteFamily";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "substituteFamilies";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshotModel";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshotModelIndex";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findModel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBasePath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTargets";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMiniCatStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class BasicSnippet {
        ObjectPath path;
        BasicDataObject root;
        List<BasicDataObject> nodes = new ArrayList<BasicDataObject>();
        TIntArrayList children = new TIntArrayList();

        BasicSnippet() {
        }

        public static BasicSnippet build(BasicHierarchicalObject r, Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
            BasicSnippet snippet = new BasicSnippet();
            snippet.root = r.frozenData();
            snippet.path = BasicPaths.of(r);
            BasicSnippet.layout(r, snippet, subSnippets);
            return snippet;
        }

        private static void layout(BasicHierarchicalObject r, BasicSnippet snippet, Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
            if (!r.hasChildren()) {
                BasicSnippet sub = subSnippets.remove(r);
                if (sub != null) {
                    snippet.nodes.addAll(sub.nodes);
                    sub.children.forEach(c2 -> {
                        snippet.children.add(c2);
                        return true;
                    });
                } else {
                    snippet.children.add(0);
                }
            } else {
                int b2 = snippet.nodes.size();
                JBIterable children2 = r.getChildren().filter(BasicHierarchicalObject.class);
                for (BasicHierarchicalObject child : children2) {
                    snippet.nodes.add(child.frozenData());
                }
                snippet.children.add(snippet.nodes.size() - b2);
                for (BasicHierarchicalObject e : children2) {
                    BasicSnippet.layout(e, snippet, subSnippets);
                }
            }
        }

        public void recover(BasicHierarchicalObject to) {
            this.recover(to, new int[]{0}, new int[]{0});
        }

        private void recover(BasicHierarchicalObject to, int[] ni, int[] ci) {
            to.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
            int b2 = ni[0];
            int c2 = this.children.get(ci[0]);
            ni[0] = b2 + c2;
            ci[0] = ci[0] + 1;
            for (int i2 = 0; i2 < c2; ++i2) {
                BasicDataObject e = this.nodes.get(b2 + i2);
                ModFamily family = (ModFamily)Objects.requireNonNull(to.familyOf(e.getKind()));
                BasicHierarchicalObject h = BasicSnippet.getOrCreate(family, e);
                this.recover(h, ni, ci);
            }
            to.getFamilies().forEach(ModFamily::removeSyncPendingChildren);
        }

        @NotNull
        private static BasicHierarchicalObject getOrCreate(ModFamily<? extends BasicHierarchicalObject> family, BasicDataObject e) {
            BasicHierarchicalObject h = family.find(o -> o.hasData(e));
            if (h == null) {
                h = family.createNewOne(e);
            } else {
                h.resetSyncPending();
            }
            BasicHierarchicalObject basicHierarchicalObject = h;
            if (basicHierarchicalObject == null) {
                BasicSnippet.$$$reportNull$$$0(0);
            }
            return basicHierarchicalObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataSourceSnapshotManager$BasicSnippet", "getOrCreate"));
        }
    }
}

