/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseViewStructureProvider;
import com.intellij.database.view.NodeGroup;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IconManager;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbPresentation
extends DbPresentationCore {
    public static final Comparator<String> NAMES_COMPARATOR = (s1, s2) -> StringUtil.compare((String)s1, (String)s2, (boolean)true);
    private static final TObjectIntHashMap<ObjectKind> KIND_WEIGHTS = DbPresentation.buildWeights(ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.DB_LINK, ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA, ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.CLUSTER, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.PACKAGE, ObjectKind.OPERATOR, ObjectKind.SEQUENCE, ObjectKind.ALIAS_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.COLLATION, ObjectKind.SYNONYM, ObjectKind.EXCEPTION, ObjectKind.VARIABLE, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.INDEX, ObjectKind.CHECK, ObjectKind.DEFAULT, ObjectKind.RULE, ObjectKind.TRIGGER, ObjectKind.PARTITION);

    public static boolean isUnnamed(@NotNull DasObject o) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)o.getName())) {
            return false;
        }
        if (o.getKind() != ObjectKind.ROUTINE) {
            return true;
        }
        DasObject parent2 = o.getDasParent();
        return parent2 == null || parent2.getKind() != ObjectKind.PACKAGE;
    }

    public static int getWeight(@NotNull ObjectKind kind, int groupCount) {
        int w;
        if (kind == null) {
            DbPresentation.$$$reportNull$$$0(1);
        }
        return (w = KIND_WEIGHTS.get((Object)kind)) != 0 ? w : 1000000 + kind.getOrder() * 1000 + groupCount;
    }

    public static int getWeight(@NotNull Object o, boolean sortPositioned) {
        int weight;
        BasicElement element2;
        Dbms dbms;
        int weight2;
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(2);
        }
        if (o instanceof BasicElement && (weight2 = DatabaseViewStructureProvider.forDbms(dbms = DbImplUtilCore.getDbms(element2 = (BasicElement)o)).getWeight(element2)) != -1) {
            return weight2;
        }
        if (o instanceof NodeGroup) {
            return ((NodeGroup)o).getWeight();
        }
        ObjectKind kind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        int n = weight = o instanceof WeighedItem ? ((WeighedItem)o).getWeight() : KIND_WEIGHTS.get((Object)kind);
        if (kind == ObjectKind.KEY && o instanceof DasTableKey && ((DasTableKey)o).isPrimary()) {
            --weight;
        }
        if (!sortPositioned && o instanceof DasPositioned) {
            return weight + ((DasPositioned)o).getPosition();
        }
        return weight;
    }

    @NotNull
    private static TObjectIntHashMap<ObjectKind> buildWeights(ObjectKind ... kinds) {
        TObjectIntHashMap res2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < kinds.length; ++i2) {
            res2.put((Object)kinds[i2], 1000 * (i2 + 1));
        }
        res2.compact();
        TObjectIntHashMap tObjectIntHashMap = res2;
        if (tObjectIntHashMap == null) {
            DbPresentation.$$$reportNull$$$0(3);
        }
        return tObjectIntHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnnamed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    extends PresentationProvider<DasObject> {
        @Nullable
        public String getName(@Nullable DasObject object) {
            return object == null ? null : DbPresentationCore.getPresentableName(object, true);
        }

        @Nullable
        public Icon getIcon(@Nullable DasObject object) {
            if (object == null) {
                return null;
            }
            Icon baseIcon = DbPresentationCore.getIcon(object.getKind());
            return IconManager.getInstance().createDeferredIcon(baseIcon, (Object)object, DbPresentationCore::getIcon);
        }

        @Nullable
        public String getTypeName(DasObject object) {
            if (object == null) {
                return null;
            }
            Dbms dbms = DbImplUtil.getDbms(object);
            return DbPresentationCore.getPresentableName(object.getKind(), dbms);
        }
    }
}

