/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbRoutineImpl
extends DbElementImpl<DasRoutine, DbElement>
implements DbRoutine {
    protected DbRoutineImpl(DbElement parent2, @NotNull DasRoutine delegate) {
        if (delegate == null) {
            DbRoutineImpl.$$$reportNull$$$0(0);
        }
        super(parent2, delegate);
    }

    @Override
    public String getPackageName() {
        return ((DasRoutine)this.myDelegate).getPackageName();
    }

    @Override
    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = ((DasRoutine)this.myDelegate).getRoutineKind();
        if (kind == null) {
            DbRoutineImpl.$$$reportNull$$$0(1);
        }
        return kind;
    }

    @Override
    @NotNull
    public Iterable<? extends DasArgument> getArguments() {
        Iterable<? extends DasArgument> iterable = ((DasRoutine)this.myDelegate).getArguments();
        if (iterable == null) {
            DbRoutineImpl.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Override
    @Nullable
    public DasArgument getReturnArgument() {
        return ((DasRoutine)this.myDelegate).getReturnArgument();
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation(boolean hover) {
        StringBuilder sb = this.createDocHeaderColored().cast(StringBuilder.class);
        if (!this.appendDefinition(sb)) {
            sb.append("<br><code><pre>");
            sb.append(this.sql2Html(DatabaseDefinitionHelper.generateDefinition(this, new StringBuilder())));
            sb.append("</pre></code>");
            if (!hover && DbImplUtilCore.canConnectTo(this) && DbImplUtilCore.getDatabaseDialect(this).supportsProcedureDefinition()) {
                this.scheduleAsyncDocumentationUpdate(sb, this::loadSlowDocumentationInner);
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbRoutineImpl.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    private void loadSlowDocumentationInner(CharOut sb, ConnectionProvider provider) throws Exception {
        sb.append("<br>");
        StringBuilder builder = new StringBuilder();
        DbImplUtil.tryLoadProcedureDefinition(provider, this, builder);
        if (!builder.toString().trim().isEmpty()) {
            sb.append("<b>Definition:</b><br><code><pre>");
            sb.append(this.sql2Html(builder));
            sb.append("</pre></code>");
        } else {
            sb.append("<b>No definition found</b>");
        }
    }

    public String getPresentableText() {
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(this);
        String proto = dialect.sqlDefinePrototype(DatabaseDialogsHelper.createDdlBuilder(this, true), this, false, false).getStatement();
        return StringUtil.notNullize((String)super.getPresentableText()) + StringUtil.shortenTextWithEllipsis((String)proto, (int)50, (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbRoutineImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbRoutineImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

