/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class SqlNotebookDeleteHandler
extends EditorActionHandler.ForEachCaret {
    private final EditorActionHandler myOriginalHandler;

    public SqlNotebookDeleteHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            SqlNotebookDeleteHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            SqlNotebookDeleteHandler.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(editor.getProject(), file);
        if (console == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        Collection<? extends DatabaseInEditorResults.Result> results2 = console.getEmbeddedResults(editor);
        for (DatabaseInEditorResults.Result result2 : results2) {
            if (!result2.isShown() || !result2.isStable() || !this.canPerform(result2, caret.getOffset())) continue;
            result2.hide();
            return;
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            SqlNotebookDeleteHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            SqlNotebookDeleteHandler.$$$reportNull$$$0(3);
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    abstract boolean canPerform(@NotNull DatabaseInEditorResults.Result var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/SqlNotebookDeleteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DeleteHandler
    extends SqlNotebookDeleteHandler {
        public DeleteHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        boolean canPerform(@NotNull DatabaseInEditorResults.Result result2, int offset) {
            if (result2 == null) {
                DeleteHandler.$$$reportNull$$$0(0);
            }
            return result2.getOffset() == offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/run/SqlNotebookDeleteHandler$DeleteHandler", "canPerform"));
        }
    }

    public static class BackspaceHandler
    extends SqlNotebookDeleteHandler {
        public BackspaceHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        boolean canPerform(@NotNull DatabaseInEditorResults.Result result2, int offset) {
            if (result2 == null) {
                BackspaceHandler.$$$reportNull$$$0(0);
            }
            return result2.getOffset() == offset - 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/run/SqlNotebookDeleteHandler$BackspaceHandler", "canPerform"));
        }
    }
}

