/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/run/actions/ChangeCellTypeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/data/types/domain/Domain;)V", "getDomain", "()Lcom/intellij/database/data/types/domain/Domain;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.database.impl"})
public final class ChangeCellTypeAction
extends ToggleAction
implements DumbAware {
    private final DataGrid grid;
    @NotNull
    private final Domain domain;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setText(this.domain.simpleName());
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> row = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> column2 = modelIndex2;
        return StringUtil.equalsIgnoreCase((CharSequence)this.domain.simpleName(), (CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(this.grid, row, column2));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ModelIndexSet<DataConsumer.Column> columns;
        ModelIndexSet<DataConsumer.Row> rows;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SelectionModel selectionModel = this.grid.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
                ModelIndexSet<DataConsumer.Row> modelIndexSet = selectionModel.getSelectedRows();
                Intrinsics.checkNotNullExpressionValue(modelIndexSet, (String)"grid.selectionModel.selectedRows");
                rows = modelIndexSet;
                SelectionModel selectionModel2 = this.grid.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
                ModelIndexSet<DataConsumer.Column> modelIndexSet2 = selectionModel2.getSelectedColumns();
                Intrinsics.checkNotNullExpressionValue(modelIndexSet2, (String)"grid.selectionModel.selectedColumns");
                columns = modelIndexSet2;
                JBIterable jBIterable = rows.asIterable();
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"rows.asIterable()");
                if (jBIterable.isEmpty()) break block2;
                JBIterable jBIterable2 = columns.asIterable();
                Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"columns.asIterable()");
                if (!jBIterable2.isEmpty()) break block3;
            }
            return;
        }
        this.grid.changeCellType(rows, columns, this.domain);
    }

    @NotNull
    public final Domain getDomain() {
        return this.domain;
    }

    public ChangeCellTypeAction(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this.grid = grid;
        this.domain = domain;
    }
}

