/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.AddRowAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.awt.RelativePoint;
import org.jetbrains.annotations.NotNull;

public class CloneRowAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(0);
        }
        boolean available = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && AddRowAction.canAddRow(dataGrid) && !dataGrid.isEditing();
        e.getPresentation().setEnabledAndVisible(available);
    }

    private static boolean hasTruncatedData(DataConsumer.Row row) {
        for (int i2 = 0; i2 < row.getSize(); ++i2) {
            Object value2 = row.getValue(i2);
            if (!(value2 instanceof LobInfo) || !((LobInfo)value2).isTruncated()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ModelIndex<DataConsumer.Row> selectedRow;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(1);
        }
        ModelIndex<DataConsumer.Row> modelIndex = selectedRow = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null ? dataGrid.getSelectionModel().getSelectedRow() : null;
        if (selectedRow != null && selectedRow.isValid(dataGrid)) {
            DataConsumer.Row row = (DataConsumer.Row)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(selectedRow);
            if (row != null && CloneRowAction.hasTruncatedData(row)) {
                String message2 = DatabaseBundle.message("Console.TableResult.cannotCloneRow", new Object[0]);
                CloneRowAction.showBalloon(dataGrid, message2);
            } else {
                CloneRowAction.cloneRow(dataGrid, selectedRow);
            }
        }
    }

    private static void cloneRow(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (grid == null) {
            CloneRowAction.$$$reportNull$$$0(2);
        }
        if (rowToClone == null) {
            CloneRowAction.$$$reportNull$$$0(3);
        }
        if ((mutator = DataGridUtil.getRowsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.cloneRow(AddRowAction.newInsertOrCloneRowRequestSource(grid), rowToClone));
            return;
        }
        mutator.cloneRow(AddRowAction.newInsertOrCloneRowRequestSource(grid), rowToClone);
    }

    private static void showBalloon(@NotNull DataGrid dataGrid, @NlsContexts.PopupContent @NotNull String message2) {
        if (dataGrid == null) {
            CloneRowAction.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            CloneRowAction.$$$reportNull$$$0(5);
        }
        Pair<RelativePoint, Balloon.Position> position = DataGridUtil.getBestPositionForBalloon(dataGrid);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.WARNING, null).createBalloon().show((RelativePoint)position.first, (Balloon.Position)position.second);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToClone";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/CloneRowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cloneRow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showBalloon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

