/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class ShowDumpDialogAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(0);
        }
        DumpSource<?> source = DumpAction.getDumpSource(e);
        e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid != null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(grid.isReady() && !grid.isEmpty());
            e.getPresentation().setText(DatabaseBundle.message("action.Console.TableResult.ShowDumpDialogAction.text", new Object[0]));
            return;
        }
        if (source == null || e.getProject() == null) {
            return;
        }
        if (source instanceof DumpSource.ConsoleSource) {
            ShowDumpDialogAction.updateConsolePresentation((DumpSource.ConsoleSource)source, e);
        } else {
            this.updatePresentation(source, e);
        }
    }

    private static void updateConsolePresentation(@NotNull DumpSource.ConsoleSource source, @NotNull AnActionEvent e) {
        if (source == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(2);
        }
        int size = source.estimateSize();
        e.getPresentation().setEnabledAndVisible(size != 0);
        if (size == 0) {
            return;
        }
        e.getPresentation().setText(DatabaseBundle.message("action.Console.TableResult.ShowDumpDialogAction.ConsoleText", size));
        e.getPresentation().setIcon(AllIcons.Actions.Execute);
    }

    private void updatePresentation(@NotNull DumpSource<?> target, @NotNull AnActionEvent e) {
        if (target == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setText(DatabaseBundle.message("action.Console.TableResult.ShowDumpDialogAction.DatabaseViewText", DumpAction.getSize(target)), true);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        DumpSource<?> source = DumpAction.getDumpSource(e);
        if (project != null && source != null) {
            new DumpDataDialog(project, source, (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/ShowDumpDialogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateConsolePresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

