/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.ui.TableResultPanel;
import gnu.trove.TIntHashSet;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class HiddenColumnsSelectionHolder {
    private final TIntHashSet mySelectedHiddenColumns;
    private boolean myWholeRowSelected;
    private boolean myIgnoreChanges;

    public HiddenColumnsSelectionHolder() {
        this.mySelectedHiddenColumns = new TIntHashSet();
    }

    private HiddenColumnsSelectionHolder(HiddenColumnsSelectionHolder copy) {
        this.mySelectedHiddenColumns = new TIntHashSet(copy.mySelectedHiddenColumns.toArray());
        this.myWholeRowSelected = copy.myWholeRowSelected;
        this.myIgnoreChanges = copy.myIgnoreChanges;
    }

    public void setWholeRowSelected(boolean selected) {
        if (this.myIgnoreChanges) {
            return;
        }
        this.myWholeRowSelected = selected;
    }

    public void columnHidden(int modelIndex) {
        this.mySelectedHiddenColumns.add(modelIndex);
    }

    public void columnShown(int modelIndex) {
        this.mySelectedHiddenColumns.remove(modelIndex);
    }

    public void startAdjusting() {
        this.myIgnoreChanges = true;
    }

    public void endAdjusting() {
        this.myIgnoreChanges = false;
    }

    public boolean contains(int modelIndex) {
        return this.myWholeRowSelected || this.mySelectedHiddenColumns.contains(modelIndex);
    }

    public HiddenColumnsSelectionHolder copy() {
        return new HiddenColumnsSelectionHolder(this);
    }

    public int[] selectedModelIndices(@NotNull TableResultPanel panel2) {
        if (panel2 == null) {
            HiddenColumnsSelectionHolder.$$$reportNull$$$0(0);
        }
        return this.myWholeRowSelected ? IntStream.range(0, panel2.getDataModel().getColumnCount()).toArray() : this.mySelectedHiddenColumns.toArray();
    }

    public void reset() {
        this.mySelectedHiddenColumns.clear();
        this.myWholeRowSelected = false;
        this.myIgnoreChanges = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/HiddenColumnsSelectionHolder", "selectedModelIndices"));
    }
}

