/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.AddRowAction;
import com.intellij.database.run.actions.ChoosePasteFormatAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridPasteProvider
implements PasteProvider {
    private final DataGrid myGrid;

    public GridPasteProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            GridPasteProvider.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        GridTransferableData data;
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(1);
        }
        if ((data = GridPasteProvider.getTransferableData(DataGridUtil.getProject(this.myGrid))) == null) {
            return;
        }
        SelectionModel model = this.myGrid.getSelectionModel();
        ModelIndexSet rows = model.getSelectedRows();
        ModelIndexSet columns = model.getSelectedColumns();
        data = GridPasteProvider.adjustDataToSelection(data, rows.size(), true);
        data = GridPasteProvider.adjustDataToSelection(data, columns.size(), false);
        int minRow = Math.max(0, DataGridUtil.min(rows.toView(this.myGrid)));
        int maxRow = minRow + data.getRowsCount() - 1;
        int minCol = Math.max(0, DataGridUtil.min(columns.toView(this.myGrid)));
        int rowOffset = minRow - data.getFirstRowIdx();
        int colOffset = minCol - data.getFirstColumnIdx();
        for (int newRowIdx = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount(); newRowIdx <= maxRow; ++newRowIdx) {
            AddRowAction.addRow(this.myGrid);
        }
        List conversions = JBIterable.from(data.getConversions()).map(conversion -> conversion.copy().secondGrid(this.myGrid).secondSystem(DbImplUtil.getMaybeLocalDataSource(DataGridUtil.getDatabaseSystem(this.myGrid))).secondDbms(DataGridUtil.getDbms(this.myGrid)).offset(rowOffset, colOffset).build()).filter(DataTypeConversion::isValid).map(DataTypeConversion::convert).toList();
        this.myGrid.getDataSupport().finishBuildingAndApply(conversions);
    }

    @NotNull
    private static GridTransferableData adjustDataToSelection(@NotNull GridTransferableData data, int selectedCount, boolean isRow) {
        int dataCount;
        int duplicateCount;
        if (data == null) {
            GridPasteProvider.$$$reportNull$$$0(2);
        }
        if ((duplicateCount = selectedCount / (dataCount = isRow ? data.getRowsCount() : data.getColumnsCount())) <= 1) {
            GridTransferableData gridTransferableData = data;
            if (gridTransferableData == null) {
                GridPasteProvider.$$$reportNull$$$0(3);
            }
            return gridTransferableData;
        }
        ArrayList<DataTypeConversion.Builder> newConversions = new ArrayList<DataTypeConversion.Builder>(data.getConversions());
        for (int i2 = 1; i2 < duplicateCount; ++i2) {
            for (DataTypeConversion.Builder conversion : data.getConversions()) {
                newConversions.add(isRow ? conversion.copy().firstRowIdx(conversion.firstRowIdx() + i2 * dataCount) : conversion.copy().firstColumnIdx(conversion.firstColumnIdx() + i2 * dataCount));
            }
        }
        return new GridTransferableData(newConversions, data.getTransferable(), data.getFirstRowIdx(), data.getFirstColumnIdx(), isRow ? dataCount * duplicateCount : dataCount);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        CopyPasteManager manager;
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(4);
        }
        return (manager = CopyPasteManager.getInstance()).getContents(GridTransferableData.ourFlavor) instanceof GridTransferableData || manager.getContents(DataFlavor.stringFlavor) != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(5);
        }
        return this.myGrid.isReady() && this.myGrid.isEditable();
    }

    @Nullable
    private static GridTransferableData getTransferableData(@NotNull Project project) {
        Object data;
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(6);
        }
        return (data = CopyPasteManager.getInstance().getContents(GridTransferableData.ourFlavor)) instanceof GridTransferableData ? (GridTransferableData)data : GridPasteProvider.createDataFromText(project);
    }

    @Nullable
    private static GridTransferableData createDataFromText(@NotNull Project project) {
        Object data;
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(7);
        }
        if (!((data = CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) instanceof String)) {
            return null;
        }
        String text2 = (String)data;
        return GridPasteProvider.retrieveDataFromText(project, text2);
    }

    @NotNull
    private static GridTransferableData retrieveDataFromText(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            GridPasteProvider.$$$reportNull$$$0(9);
        }
        ChoosePasteFormatAction.PasteType type = ChoosePasteFormatAction.PasteType.get();
        List<String[]> parsed = type.getParser().parse(project, text2);
        ArrayList<DataTypeConversion.Builder> conversions = new ArrayList<DataTypeConversion.Builder>();
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>();
        for (int i2 = 0; i2 < parsed.size(); ++i2) {
            String[] record = parsed.get(i2);
            for (int j = 0; j < record.length; ++j) {
                String value2 = record[j];
                if (columns.size() <= j) {
                    columns.add(new DataConsumer.Column(j, "dummy", 12, "text", String.class.getName()));
                }
                DataConsumer.Column column2 = (DataConsumer.Column)columns.get(j);
                conversions.add(GridPasteProvider.createBuilder(i2, column2, value2));
            }
        }
        return new GridTransferableData(conversions, (Transferable)new TextTransferable(text2), 0, 0, parsed.size());
    }

    @NotNull
    private static DataTypeConversion.Builder createBuilder(int row, @NotNull DataConsumer.Column column2, Object value2) {
        if (column2 == null) {
            GridPasteProvider.$$$reportNull$$$0(10);
        }
        DataTypeConversion.Builder builder = new DataTypeConversion.Builder().firstColumn(column2).firstRowIdx(row).firstColumnIdx(column2.columnNum).firstDbms(Dbms.UNKNOWN).firstSystem(null).value(value2);
        if (builder == null) {
            GridPasteProvider.$$$reportNull$$$0(11);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDataToSelection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustDataToSelection";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTransferableData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataFromText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "retrieveDataFromText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

