/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.ObjectUtils;
import java.text.ParseException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridFormattersUtil
extends DataGridFormattersUtilCore {
    private DataGridFormattersUtil() {
    }

    public static boolean useLenientFormatterForTemporalObjects(@NotNull DataGrid grid) {
        Dbms dbms;
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(0);
        }
        if ((dbms = DataGridUtil.getDbms(grid)) != Dbms.MYSQL) {
            return dbms.is(Dbms.SQLITE) || dbms.is(Dbms.SNOWFLAKE);
        }
        DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource(system);
        return dataSource2 != null && dataSource2.getExactDriverVersion().isOrGreater(8);
    }

    @NotNull
    public static Date getBoundedValue(@NotNull Object value2, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull DataGrid grid) {
        if (value2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(3);
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        DataConsumer.Column gridColumn = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dbms, gridColumn);
        Date date = resolver.bound(value2);
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(4);
        }
        return date;
    }

    @NotNull
    public static Date getDateFrom(@Nullable Object o, @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(6);
        }
        if (o instanceof String) {
            Date date;
            Date fromNumber = DataGridFormattersUtil.parseDateFromNumber((String)o);
            if (fromNumber != null) {
                Date date2 = fromNumber;
                if (date2 == null) {
                    DataGridFormattersUtil.$$$reportNull$$$0(7);
                }
                return date2;
            }
            DataConsumer.Column c2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2);
            Formatter format = grid.getObjectFormatter().getTimestampFormat(c2, DataGridUtil.getDbms(grid));
            try {
                Date res2 = (Date)ObjectUtils.tryCast((Object)format.parse((String)o), Date.class);
                date = (Date)ObjectUtils.notNull((Object)res2, (Object)DataGridFormattersUtil.getUtcDate());
            }
            catch (ParseException e) {
                DataGridFormattersUtil.getUtcDate();
            }
            if (date == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(8);
            }
            return date;
        }
        Date date = o instanceof Double ? new Date(DataGridFormattersUtil.fromJulian((Double)o)) : (o instanceof Number ? new Date(((Number)o).longValue()) : (o instanceof Date ? (Date)o : DataGridFormattersUtil.getUtcDate()));
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(9);
        }
        return date;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundedValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useLenientFormatterForTemporalObjects";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoundedValue";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDateFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

