/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.actions.ChangeCellEditorFileEncodingAction;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EventObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultBlobEditorFactory
implements GridCellEditorFactory {
    DefaultBlobEditorFactory() {
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(2);
        }
        switch (GridCellEditorsUtil.guessJdbcTypeForEditing(grid, row, column2)) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(3);
        }
        if (rowIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(4);
        }
        if (columnIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(5);
        }
        return value2 instanceof ObjectFormatter.TextInfo ? () -> {
            ObjectFormatter.TextInfo textInfo = (ObjectFormatter.TextInfo)value2;
            int length = CharsetToolkit.getBOMLength((byte[])textInfo.bytes, (Charset)textInfo.charset);
            return new GridCellEditorFactory.ValueFormatterResult(textInfo.text, textInfo.charset, Arrays.copyOf(textInfo.bytes, length));
        } : new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value2);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (dbms, value2) -> value2 == null || value2 instanceof ObjectFormatter.TextInfo;
        if (isEditableChecker == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(6);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(9);
        }
        GridCellEditorFactory.ValueParser valueParser = (text2, document) -> {
            VirtualFile file = document == null ? null : FileDocumentManager.getInstance().getFile(document);
            Charset charset = file == null ? StandardCharsets.UTF_8 : file.getCharset();
            byte[] bytes = text2.getBytes(charset);
            byte[] bom = file == null ? null : file.getBOM();
            return new ObjectFormatter.TextInfo(text2, bom == null ? bytes : ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes), charset);
        };
        if (valueParser == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(10);
        }
        return valueParser;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(11);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(12);
        }
        if (column2 == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(13);
        }
        return new BlobTextCellEditor(grid, row, column2, object, initiator, this.getIsEditableChecker(), this.getValueParser(grid, row, column2), this.getValueFormatter(grid, row, column2, object));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlobTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private final GridCellEditorFactory.ValueParser myValueParser;

        BlobTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object value2, EventObject initiator, @NotNull GridCellEditorFactory.IsEditableChecker editableChecker, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                BlobTextCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                BlobTextCellEditor.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                BlobTextCellEditor.$$$reportNull$$$0(2);
            }
            if (editableChecker == null) {
                BlobTextCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                BlobTextCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                BlobTextCellEditor.$$$reportNull$$$0(5);
            }
            super(grid, row, column2, value2, initiator, editableChecker, valueFormatter);
            this.myValueParser = valueParser;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.isValueEditable() ? this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument()) : this.myValue;
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                BlobTextCellEditor.$$$reportNull$$$0(6);
            }
            if (LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY.is(dataId)) {
                return this;
            }
            if (ChangeCellEditorFileEncodingAction.ENCODING_CHANGE_SUPPORTED_KEY.is(dataId) && this.isValueEditable()) {
                return Boolean.TRUE;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return this.getVirtualFile();
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return new VirtualFile[]{this.getVirtualFile()};
            }
            return null;
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                BlobTextCellEditor.$$$reportNull$$$0(7);
            }
            this.myValue = DbImplUtil.blobFromFile(file);
            this.myGrid.stopEditing();
        }

        private VirtualFile getVirtualFile() {
            return FileDocumentManager.getInstance().getFile(this.myTextField.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editableChecker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory$BlobTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

