/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.table.GridSelectionGrowerStrategy;
import com.intellij.database.run.ui.table.TableResultView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GridSelectionGrower {
    private final TableResultPanel myPanel;
    private final TableResultView myTable;
    private boolean myAdjusting;
    private GridSelection<DataConsumer.Row, DataConsumer.Column> myPrevious;
    private final List<GridSelection<DataConsumer.Row, DataConsumer.Column>> myGrowthHistory;

    GridSelectionGrower(@NotNull TableResultPanel panel2, @NotNull TableResultView table) {
        if (panel2 == null) {
            GridSelectionGrower.$$$reportNull$$$0(0);
        }
        if (table == null) {
            GridSelectionGrower.$$$reportNull$$$0(1);
        }
        this.myGrowthHistory = new ArrayList<GridSelection<DataConsumer.Row, DataConsumer.Column>>();
        this.myPanel = panel2;
        this.myTable = table;
        this.myTable.addSelectionChangedListener(() -> {
            if (!this.myAdjusting) {
                this.myGrowthHistory.clear();
            }
        });
    }

    void growSelection() {
        if (this.myAdjusting) {
            return;
        }
        try {
            this.myAdjusting = true;
            this.growSelectionInternal();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    void shrinkSelection() {
        if (this.myAdjusting) {
            return;
        }
        try {
            this.myAdjusting = true;
            this.shrinkSelectionInternal();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    void reset() {
        if (this.myAdjusting) {
            return;
        }
        this.myPrevious = null;
    }

    private void growSelectionInternal() {
        GridSelectionGrowerStrategy grower = GridSelectionGrowerStrategy.of(this.myPanel, this.myTable);
        if (grower == null) {
            return;
        }
        this.myGrowthHistory.add(this.myPanel.getSelectionModel().store());
        if (grower.isNeedRestore() && this.myPrevious != null) {
            this.restore();
        }
        this.myPrevious = grower.isNeedStore() ? this.myPanel.getSelectionModel().store() : this.myPrevious;
        grower.changeSelection(this.myPanel, this.myTable);
    }

    private void shrinkSelectionInternal() {
        if (this.myGrowthHistory.isEmpty()) {
            return;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> previous = this.myGrowthHistory.get(this.myGrowthHistory.size() - 1);
        this.myPanel.getAutoscrollLocker().runWithLock(() -> this.myPanel.getSelectionModel().restore(previous));
        this.myGrowthHistory.remove(this.myGrowthHistory.size() - 1);
    }

    private void restore() {
        this.myPanel.getAutoscrollLocker().runWithLock(() -> this.myPanel.getSelectionModel().restore(this.myPrevious));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/table/GridSelectionGrower";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

