/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.treetable.ColumnNode;
import com.intellij.database.run.ui.treetable.GridTreeTable;
import com.intellij.database.run.ui.treetable.GridTreeTableModel;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.database.run.ui.treetable.NodeKt;
import com.intellij.database.run.ui.treetable.RowNode;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntUnaryOperator;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public final class TreeTableRawIndexConverter
implements RawIndexConverter {
    private final TableResultPanel myResultPanel;
    private final GridTreeTable myTreeTable;

    public TreeTableRawIndexConverter(@NotNull TableResultPanel panel2, @NotNull GridTreeTable treeTable) {
        if (panel2 == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(0);
        }
        if (treeTable == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(1);
        }
        this.myResultPanel = panel2;
        this.myTreeTable = treeTable;
    }

    @Override
    public boolean isValidViewRowIdx(int viewRowIdx) {
        return viewRowIdx >= 0 && viewRowIdx < this.myTreeTable.getTree().getRowCount();
    }

    @Override
    public boolean isValidViewColumnIdx(int viewColumnIdx) {
        return viewColumnIdx >= 0 && viewColumnIdx < this.myTreeTable.getTable().getColumnCount() + 1;
    }

    @Override
    @NotNull
    public IntUnaryOperator row2View() {
        IntUnaryOperator intUnaryOperator = index2 -> {
            if (!this.isValidModelRowIdx(index2)) {
                return -1;
            }
            GridTreeTableModel model = this.myTreeTable.getModel();
            TreePath rowPath = new TreePath(new Object[]{model.getRoot(), model.getChild(model.getRoot(), index2)});
            return this.myTreeTable.getTree().getRowForPath(rowPath);
        };
        if (intUnaryOperator == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(2);
        }
        return intUnaryOperator;
    }

    @Override
    @NotNull
    public IntUnaryOperator column2View() {
        IntUnaryOperator intUnaryOperator = index2 -> {
            if (!this.isValidModelColumnIdx(index2)) {
                return -1;
            }
            return 0;
        };
        if (intUnaryOperator == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(3);
        }
        return intUnaryOperator;
    }

    @Override
    @NotNull
    public RawIndexConverter.PairPairFunction<Integer> rowAndColumn2Model() {
        RawIndexConverter.PairPairFunction<Integer> pairPairFunction = (row, column2) -> {
            if (!this.isValidViewRowIdx((int)row) || !this.isValidViewColumnIdx((int)column2)) {
                return new Pair((Object)-1, (Object)-1);
            }
            TreePath path = this.myTreeTable.getTree().getPathForRow(row.intValue());
            if (path == null) {
                return new Pair((Object)-1, (Object)-1);
            }
            ColumnNode columnNode = (ColumnNode)ContainerUtil.find((Object[])path.getPath(), node -> node instanceof ColumnNode);
            return new Pair((Object)this.row2Model().applyAsInt((int)row), (Object)(columnNode == null ? -1 : columnNode.getColumnIdx().asInteger()));
        };
        if (pairPairFunction == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(4);
        }
        return pairPairFunction;
    }

    @Override
    @NotNull
    public RawIndexConverter.PairPairFunction<Integer> rowAndColumn2View() {
        RawIndexConverter.PairPairFunction<Integer> pairPairFunction = (row, column2) -> {
            int viewColumn = 0;
            if (!this.isValidModelColumnIdx((int)column2)) {
                viewColumn = -1;
            }
            if (!this.isValidModelRowIdx((int)row)) {
                return new Pair((Object)-1, (Object)viewColumn);
            }
            GridTreeTableModel model = this.myTreeTable.getModel();
            RowNode rowNode = (RowNode)ObjectUtils.tryCast((Object)model.getChild(model.getRoot(), (int)row), RowNode.class);
            if (rowNode == null) {
                return new Pair((Object)-1, (Object)viewColumn);
            }
            kotlin.Pair<List<Node>, Node> pathAndNode = NodeKt.dfs((Node)rowNode, (Function2<? super List<? extends Node>, ? super Node, Boolean>)((Function2)(path, node) -> node instanceof ColumnNode && ((ColumnNode)node).getColumnIdx().asInteger() == column2.intValue()));
            ArrayList<Node> l = new ArrayList<Node>();
            l.add(model.getRoot());
            if (pathAndNode == null) {
                l.add(rowNode);
            } else {
                l.addAll((Collection)pathAndNode.getFirst());
            }
            int viewRow = this.myTreeTable.getTree().getRowForPath(new TreePath(l.toArray()));
            return new Pair((Object)viewRow, (Object)viewColumn);
        };
        if (pairPairFunction == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(5);
        }
        return pairPairFunction;
    }

    @Override
    @NotNull
    public IntUnaryOperator row2Model() {
        IntUnaryOperator intUnaryOperator = index2 -> {
            if (!this.isValidViewRowIdx(index2)) {
                return -1;
            }
            TreePath path = this.myTreeTable.getTree().getPathForRow(index2);
            for (Object node : path.getPath()) {
                if (!(node instanceof RowNode)) continue;
                return ((RowNode)node).getRowIdx().asInteger();
            }
            return -1;
        };
        if (intUnaryOperator == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(6);
        }
        return intUnaryOperator;
    }

    @Override
    @NotNull
    public IntUnaryOperator column2Model() {
        IntUnaryOperator intUnaryOperator = index2 -> {
            if (!this.isValidViewColumnIdx(index2)) {
                return -1;
            }
            return index2;
        };
        if (intUnaryOperator == null) {
            TreeTableRawIndexConverter.$$$reportNull$$$0(7);
        }
        return intUnaryOperator;
    }

    private boolean isValidModelRowIdx(int modelRowIdx) {
        return modelRowIdx >= 0 && modelRowIdx < this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount();
    }

    private boolean isValidModelColumnIdx(int modelColumnIdx) {
        return modelColumnIdx >= 0 && modelColumnIdx < this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeTable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/treetable/TreeTableRawIndexConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/treetable/TreeTableRawIndexConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "row2View";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "column2View";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "rowAndColumn2Model";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rowAndColumn2View";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "row2Model";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "column2Model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

