/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserParametersTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UserParametersComponent
implements ConfigurableUi<DatabaseSettings>,
Disposable {
    private JPanel myPanel;
    private JPanel myParamPatternPlaceholder;
    private JCheckBox myUsePatternsInLiterals;
    private JCheckBox myUsePatternsInSql;
    private JBCheckBox myProcessStrings;
    private final UserParametersTable myPattenList;

    public UserParametersComponent() {
        this.$$$setupUI$$$();
        this.myPattenList = new UserParametersTable(this);
        this.myParamPatternPlaceholder.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DatabaseBundle.message("settings.parameter.patterns", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myParamPatternPlaceholder.add((Component)this.myPattenList.getComponent(), "Center");
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            UserParametersComponent.$$$reportNull$$$0(0);
        }
        this.myPattenList.reset(settings);
        this.myUsePatternsInLiterals.setSelected(settings.getUserPatterns().inLiterals);
        this.myUsePatternsInSql.setSelected(settings.getUserPatterns().inScripts);
        this.myProcessStrings.setSelected(settings.getUserPatterns().processStrings);
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            UserParametersComponent.$$$reportNull$$$0(1);
        }
        if (this.myPattenList.isModified(settings)) {
            return true;
        }
        if (!Comparing.equal((Object)settings.getUserPatterns().inLiterals, (Object)this.myUsePatternsInLiterals.isSelected())) {
            return true;
        }
        if (!Comparing.equal((Object)settings.getUserPatterns().inScripts, (Object)this.myUsePatternsInSql.isSelected())) {
            return true;
        }
        return !Comparing.equal((Object)settings.getUserPatterns().processStrings, (Object)this.myProcessStrings.isSelected());
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            UserParametersComponent.$$$reportNull$$$0(2);
        }
        settings.getUserPatterns().inLiterals = this.myUsePatternsInLiterals.isSelected();
        settings.getUserPatterns().inScripts = this.myUsePatternsInSql.isSelected();
        settings.getUserPatterns().processStrings = this.myProcessStrings.isSelected();
        this.myPattenList.apply(settings);
        DatabaseSettings.fireSettingsChanged();
        FileContentUtil.reparseOpenedFiles();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            UserParametersComponent.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/UserParametersComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/UserParametersComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myParamPatternPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.myUsePatternsInLiterals = jBCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", UserParametersComponent.class).getString("settings.enable.in.string.literals.with.sql.injection"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBCheckBox jBCheckBox3 = new JBCheckBox();
        this.myUsePatternsInSql = jBCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", UserParametersComponent.class).getString("settings.enable.in.console.and.sql.files"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProcessStrings = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", UserParametersComponent.class).getString("settings.substitute.inside.sql.strings"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

