/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcConsoleUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbUIUtil {
    private static final String OPEN_FILE_DESC = "Open file";
    public static final JBColor WARNING = new JBColor(15111424, 10322434);

    private DbUIUtil() {
    }

    public static <DS extends DasDataSource> void configureDataSourceComboBox(@NotNull Project project, JComboBox<DS> comboBox, Iterable<DS> dataSources, @Nullable DS selection, boolean allowNull) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(0);
        }
        ArrayList copy = ContainerUtil.newArrayList(dataSources);
        copy.sort((o1, o2) -> Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getName()))));
        if (allowNull) {
            copy.add(0, null);
        }
        comboBox.setModel((ComboBoxModel<DS>)new CollectionComboBoxModel((List)copy, selection));
        if (comboBox instanceof ComboBox) {
            int width = comboBox.getFontMetrics(comboBox.getFont()).stringWidth("long enough data source name with icon123");
            ((ComboBox)comboBox).setMinimumAndPreferredWidth(width);
        }
        comboBox.setRenderer((ListCellRenderer<DS>)SimpleListCellRenderer.create((label, element2, index2) -> {
            Color color;
            boolean valid = !(element2 instanceof PsiElement) || ((PsiElement)element2).isValid();
            label.setIcon(element2 != null ? element2.getIcon(0) : null);
            String name = element2 == null ? DatabaseBundle.message("label.none", new Object[0]) : element2.getName();
            label.setText(StringUtil.notNullize((String)name));
            if (!valid) {
                label.setForeground((Color)JBColor.RED);
            }
            if ((color = DatabaseColorManager.getColor(project, element2)) != null) {
                label.setBackground(color);
            }
        }));
        comboBox.setEditable(false);
    }

    public static Color softHighlightOf(Color c1) {
        if (c1 == null) {
            return null;
        }
        int i2 = 16;
        return new JBColor(new Color(Math.max(0, c1.getRed() - i2), Math.max(0, c1.getGreen() - i2), Math.max(0, c1.getBlue() - i2)), new Color(Math.min(255, c1.getRed() + i2), Math.min(255, c1.getGreen() + i2), Math.min(255, c1.getBlue() + i2)));
    }

    public static boolean isIntervalModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            DbUIUtil.$$$reportNull$$$0(1);
        }
        return 0 != (e.getModifiersEx() & 0x40);
    }

    public static boolean isExclusiveModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            DbUIUtil.$$$reportNull$$$0(2);
        }
        return 0 != (e.getModifiersEx() & 0x180);
    }

    @Nullable
    public static VirtualFile openInConsole(@Nullable DbElement o, @NotNull String text2) {
        if (text2 == null) {
            DbUIUtil.$$$reportNull$$$0(3);
        }
        return o == null ? null : DbUIUtil.openInConsole(o.getDataSource(), o, text2, false);
    }

    @Nullable
    public static VirtualFile openInConsole(@NotNull DbDataSource dataSource2, @Nullable DbElement o, @NotNull String text2, boolean existing) {
        LocalDataSource localDataSource;
        if (dataSource2 == null) {
            DbUIUtil.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            DbUIUtil.$$$reportNull$$$0(5);
        }
        if ((localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), LocalDataSource.class)) == null) {
            return null;
        }
        return DbUIUtil.openInConsole(dataSource2.getProject(), localDataSource, o, text2, existing);
    }

    @Nullable
    public static VirtualFile openInConsole(Project project, @NotNull LocalDataSource dataSource2, @Nullable DbElement o, @NotNull String text2, boolean existing) {
        VirtualFile file;
        if (dataSource2 == null) {
            DbUIUtil.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            DbUIUtil.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = file = existing ? DatabaseEditorHelper.getConsoleVirtualFile(dataSource2) : DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource2);
        if (file == null) {
            return null;
        }
        DbUIUtil.openInConsole(project, (DasDataSource)dataSource2, file, text2, o);
        return file;
    }

    public static void openInConsole(@NotNull Project project, @NotNull DasDataSource dataSource2, @NotNull VirtualFile file, @NotNull String text2, @Nullable DasObject o) {
        Document doc;
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(8);
        }
        if (dataSource2 == null) {
            DbUIUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            DbUIUtil.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            DbUIUtil.$$$reportNull$$$0(11);
        }
        if ((doc = FileDocumentManager.getInstance().getDocument(file)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
                int length;
                doc.insertString(length, (CharSequence)((length = doc.getTextLength()) == 0 ? text2 : "\n" + text2));
            }, DatabaseBundle.message("command.name.open.query.in.console", new Object[0]), null));
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            DatabaseEditorHelper.openConsoleForFile(project, dataSource2, DasUtil.getParentOfClass(o, DasNamespace.class, false), file);
        }
    }

    @NotNull
    public static Notification createNotification(@NotNull DasDataSource system, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
        if (system == null) {
            DbUIUtil.$$$reportNull$$$0(12);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(14);
        }
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(system.getName(), content, type);
        if (notification == null) {
            DbUIUtil.$$$reportNull$$$0(15);
        }
        return notification;
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NotNull DasDataSource system, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @NotNull String path) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(16);
        }
        if (system == null) {
            DbUIUtil.$$$reportNull$$$0(17);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(18);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(19);
        }
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(20);
        }
        return DbUIUtil.createFileLinkNotification(project, system.getName(), content, type, path);
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @NotNull String path) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(21);
        }
        if (title == null) {
            DbUIUtil.$$$reportNull$$$0(22);
        }
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(23);
        }
        if (type == null) {
            DbUIUtil.$$$reportNull$$$0(24);
        }
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(25);
        }
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DbUIUtil.getContent(content, path), type).setListener((NotificationListener)new FileNotificationListener(project, path));
        if (notification == null) {
            DbUIUtil.$$$reportNull$$$0(26);
        }
        return notification;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getContent(@NlsContexts.NotificationContent @NotNull String content, @NotNull String path) {
        if (content == null) {
            DbUIUtil.$$$reportNull$$$0(27);
        }
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(28);
        }
        String string = content + (StringUtil.isEmpty((String)content) ? "" : " ") + DbUIUtil.wrapInOpenFileLink(path);
        if (string == null) {
            DbUIUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String wrapInOpenFileLink(@NotNull String path) {
        if (path == null) {
            DbUIUtil.$$$reportNull$$$0(30);
        }
        String string = "<a href=\"Open file\">" + PathUtil.getFileName((String)path) + "</a>";
        if (string == null) {
            DbUIUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static ConsoleView addConsole(@NotNull Project project, @NlsContexts.TabTitle @NotNull String taskName, final @NotNull BooleanGetter canRerun, final @NotNull Runnable rerunRunnable, final @NotNull AtomicReference<ProgressIndicator> indicatorRef) {
        if (project == null) {
            DbUIUtil.$$$reportNull$$$0(32);
        }
        if (taskName == null) {
            DbUIUtil.$$$reportNull$$$0(33);
        }
        if (canRerun == null) {
            DbUIUtil.$$$reportNull$$$0(34);
        }
        if (rerunRunnable == null) {
            DbUIUtil.$$$reportNull$$$0(35);
        }
        if (indicatorRef == null) {
            DbUIUtil.$$$reportNull$$$0(36);
        }
        final ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("RunnerToolbar", (ActionGroup)toolbarActions, false);
        toolbar2.setTargetComponent(consoleView.getComponent());
        consoleComponent.add((Component)toolbar2.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, taskName){

            public boolean isContentReuseProhibited() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                return indicator != null && indicator.isRunning();
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }
        });
        Executor executor2 = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new DumbAwareAction(DatabaseBundle.messagePointer("action.DbUIUtil.run.dashboard.rerun.action.name.text", new Object[0]), AllIcons.Actions.Rerun){

            public void update(@NotNull AnActionEvent e) {
                ProgressIndicator indicator;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean enabled = ((indicator = (ProgressIndicator)indicatorRef.get()) == null || !indicator.isRunning()) && canRerun.get();
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                consoleView.clear();
                rerunRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/util/DbUIUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        toolbarActions.add((AnAction)new DumbAwareAction(DatabaseBundle.messagePointer("action.DbUIUtil.stop.text", new Object[0]), AllIcons.Actions.Suspend){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                e.getPresentation().setEnabled(indicator != null && indicator.isRunning());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ProgressIndicator indicator;
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((indicator = (ProgressIndicator)indicatorRef.get()) != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/util/DbUIUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        toolbarActions.addSeparator();
        JdbcConsoleUtil.addLeftToolbarConsoleActions(toolbarActions, consoleView);
        toolbarActions.addSeparator();
        toolbarActions.add(ActionManager.getInstance().getAction("PinActiveTab"));
        toolbarActions.add((AnAction)new CloseAction(executor2, descriptor2, project));
        RunContentManager.getInstance((Project)project).showRunContent(executor2, descriptor2);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            DbUIUtil.$$$reportNull$$$0(37);
        }
        return consoleView2;
    }

    public static void showPopup(@NotNull JBPopup popup2, @Nullable Editor editor, @Nullable AnActionEvent event) {
        Object eventSource;
        if (popup2 == null) {
            DbUIUtil.$$$reportNull$$$0(38);
        }
        InputEvent inputEvent = event == null ? null : event.getInputEvent();
        Object object = eventSource = inputEvent == null ? null : inputEvent.getSource();
        if (editor != null && editor.getComponent().isShowing()) {
            popup2.showInBestPositionFor(editor);
        } else if (event != null) {
            if (eventSource instanceof InplaceButton || eventSource instanceof ActionButton) {
                popup2.setMinimumSize(((JComponent)eventSource).getSize());
                popup2.showUnderneathOf((Component)eventSource);
            } else {
                popup2.showInBestPositionFor(event.getDataContext());
            }
        }
    }

    @NotNull
    public static JComponent createActionComponent(AnAction action2, JComponent target) {
        return DbUIUtil.createToolbar(new DefaultActionGroup(new AnAction[]{action2}), target);
    }

    @NotNull
    public static JComponent createToolbar(DefaultActionGroup group, JComponent target) {
        ActionManager manager = ActionManager.getInstance();
        ActionToolbar toolbar2 = manager.createActionToolbar("toolbar", (ActionGroup)group, true);
        toolbar2.setTargetComponent(target);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setLayoutPolicy(0);
        toolbar2.getComponent().setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = toolbar2.getComponent();
        if (jComponent == null) {
            DbUIUtil.$$$reportNull$$$0(39);
        }
        return jComponent;
    }

    public static void setError(@NotNull JComponent comp, @NlsContexts.Tooltip @Nullable String error2) {
        if (comp == null) {
            DbUIUtil.$$$reportNull$$$0(40);
        }
        comp.putClientProperty("JComponent.outline", error2 == null ? null : "error");
        comp.setToolTipText(error2);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbUIUtil.$$$reportNull$$$0(41);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbUIUtil.$$$reportNull$$$0(42);
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeOnPooledThreadSync(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbUIUtil.$$$reportNull$$$0(43);
        }
        DbImplUtil.invokeOnPooledThreadSync(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbUIUtil";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canRerun";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunRunnable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbUIUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLinkNotification";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInOpenFileLink";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "addConsole";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureDataSourceComboBox";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIntervalModifierSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExclusiveModifierSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openInConsole";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 39: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFileLinkNotification";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "wrapInOpenFileLink";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addConsole";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnPooledThreadSync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FileNotificationListener
    implements NotificationListener {
        private final String myPath;
        private final Project myProject;

        public FileNotificationListener(@NotNull Project project, @NotNull String path) {
            if (project == null) {
                FileNotificationListener.$$$reportNull$$$0(0);
            }
            if (path == null) {
                FileNotificationListener.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                FileNotificationListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                FileNotificationListener.$$$reportNull$$$0(3);
            }
            if (!DbUIUtil.OPEN_FILE_DESC.equals(event.getDescription())) {
                return;
            }
            File file = new File(this.myPath);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.content.can.t.access.file", this.myPath), NotificationType.WARNING).notify(this.myProject);
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            FileNotificationListener.showFile(this.myProject, virtualFile);
        }

        private static void showFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                FileNotificationListener.$$$reportNull$$$0(4);
            }
            if (virtualFile == null) {
                FileNotificationListener.$$$reportNull$$$0(5);
            }
            if (virtualFile.isDirectory()) {
                RevealFileAction.openDirectory((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) || virtualFile.getFileType().isBinary()) {
                RevealFileAction.openFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, virtualFile), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/DbUIUtil$FileNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

