/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourcesSideTab
extends DatabaseConfigSideTab {
    DataSourceErrorsConfigurable myErrorsConfigurable;
    AnAction myAddAction;

    public DataSourcesSideTab(@NotNull DatabaseConfigEditorImpl editor) {
        if (editor == null) {
            DataSourcesSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message("tab.title.data.sources", new Object[0]), editor);
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this.myEditor, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().revalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
        });
    }

    Collection<DbDataSource> getAllDataSources(DatabaseConfigEditorImpl.DataSourceSettings settings) {
        LinkedHashSet<DbDataSource> result2 = new LinkedHashSet<DbDataSource>(settings.facade.getDataSources());
        result2.addAll(settings.newDataSources);
        result2.removeAll(this.myRemovedObjects);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DataSourcesSideTab.$$$reportNull$$$0(1);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List<@NlsContexts.Separator String> sections = Arrays.asList(DatabaseBundle.message("separator.global.data.sources", new Object[0]), DatabaseBundle.message("separator.project.data.sources", new Object[0]), DatabaseBundle.message("separator.ddl.data.sources", new Object[0]), DatabaseBundle.message("separator.imported.data.sources", new Object[0]));
            List items2 = this.sectionize(this.getAllDataSources(settings), this::createItem, o -> o.isGlobal() ? 0 : (o.isImported() ? 3 : (((DbDataSourceImpl)o.getObject()).getDelegate() instanceof SqlDataSource ? 2 : 1)));
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                this.mySidePanel.addSeparator(sections.get(i2));
                List list = items2.get(i2);
                list.sort(Comparator.comparing(SidePanelItem.DataSourceItem::getName, DbPresentation.NAMES_COMPARATOR));
                for (SidePanelItem item : list) {
                    addedItems.add(this.addToSidePanel(item));
                }
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
            if (keepSelection) {
                this.restoreSelection(selection);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @NotNull
    public SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj) {
        SidePanelItem.DataSourceItem item;
        if (obj == null) {
            DataSourcesSideTab.$$$reportNull$$$0(2);
        }
        if ((item = (SidePanelItem.DataSourceItem)this.getSidePanelItem(obj)) == null) {
            item = new SidePanelItem.DataSourceItem(this.myEditor, (DbDataSourceImpl)obj);
        }
        SidePanelItem.DataSourceItem dataSourceItem = this.createItem(item);
        if (dataSourceItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(3);
        }
        return dataSourceItem;
    }

    @NotNull
    public SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj) {
        SidePanelItem.ErrorsItem item;
        if (obj == null) {
            DataSourcesSideTab.$$$reportNull$$$0(4);
        }
        if ((item = (SidePanelItem.ErrorsItem)this.getSidePanelItem(obj)) == null) {
            item = new SidePanelItem.ErrorsItem(this.myEditor, obj);
        }
        SidePanelItem.ErrorsItem errorsItem = this.createItem(item);
        if (errorsItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(5);
        }
        return errorsItem;
    }

    @Override
    public void disposeUi() {
        super.disposeUi();
        this.myErrorsConfigurable.disposeUIResources();
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.DataSourceItem dataSourceItem;
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(6);
        }
        if ((dataSourceItem = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(item, SidePanelItem.DataSourceItem.class)) == null) {
            return;
        }
        DbDataSource dataSource2 = (DbDataSource)dataSourceItem.getObject();
        AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dataSourceItem.getConfigurable();
        this.copy(dataSource2, configurable);
    }

    DasDataSource copy(DbDataSource dataSource2, AbstractDataSourceConfigurable<?, ?> configurable) {
        DatabaseCredentials credentials;
        DatabaseSystem delegate;
        if (configurable instanceof DataSourceConfigurable) {
            delegate = ((DataSourceConfigurable)configurable).getTempDataSourceForConnection();
            credentials = this.myEditor.getSecretService();
        } else if (configurable != null) {
            delegate = configurable.getTempDataSource();
            credentials = this.myEditor.getSecretService();
        } else {
            delegate = dataSource2.getDelegate();
            credentials = DatabaseCredentials.getInstance();
        }
        String newName = this.myEditor.generateObjectName(null, delegate.getName());
        DataSourceManager<DasDataSource> dbManager = this.myEditor.getSettings().facade.getDataSourceManager(dataSource2);
        DasDataSource databaseSystem = dbManager.copyDataSource(newName, delegate);
        credentials.copyAllCredentials(delegate, databaseSystem, this.myEditor.getSecretService());
        this.onDataSourceCreated(this.myEditor.getSettings().facade, dbManager, databaseSystem);
        return databaseSystem;
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(7);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target) {
        ActionManager actionManager = ActionManager.getInstance();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        DatabaseConfigSideTab.CopyAction copyAction = new DatabaseConfigSideTab.CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        BackAction backAction = new BackAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        DatabaseConfigSideTab.ResetAction revertAction = new DatabaseConfigSideTab.ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        SourceLoadingAction sourceLoading = new SourceLoadingAction();
        left.addAll(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction});
        right.addAll(new AnAction[]{backAction, forwardAction});
        context.add(this.myAddAction);
        context.add((AnAction)removeAction);
        context.add((AnAction)copyAction);
        context.add((AnAction)scopeAction);
        context.addSeparator();
        context.add((AnAction)editDefaultsAction);
        context.add((AnAction)new ChooseDriverGroup());
        context.addSeparator();
        context.add((AnAction)revertAction);
        context.add((AnAction)sourceLoading);
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(10);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    public boolean isUsed(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DataSourcesSideTab.$$$reportNull$$$0(11);
        }
        for (DbDataSource ds : this.getAllDataSources(this.myEditor.getSettings())) {
            SidePanelItem.DataSourceItem item;
            LocalDataSource dataSource2;
            DatabaseDriver dsDriver;
            if (this.myRemovedObjects.contains(ds) || (dsDriver = (dataSource2 = (item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(this.getSidePanelItem(ds), SidePanelItem.DataSourceItem.class)) == null ? null : item.extractActualLocalDataSource()) == null ? null : dataSource2.getDatabaseDriver()) != driver) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onApply() throws ConfigurationException {
        DbDeleteProvider.closeAllFilesBeforeDataSourceRemoval(this.myEditor.getSettings().facade.getProject(), (Set)JBIterable.from((Iterable)this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo(new LinkedHashSet()));
        super.onApply();
    }

    void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull DasDataSource dataSource2) {
        if (facade == null) {
            DataSourcesSideTab.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            DataSourcesSideTab.$$$reportNull$$$0(13);
        }
        if (dataSource2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(14);
        }
        DbDataSource element2 = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        this.myEditor.getSettings().newDataSources.add(element2);
        this.myEditor.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, null);
        DatabaseConfigEditorImpl.createEditorIfNeeded(this.createItem(element2));
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(element2, true);
    }

    private List<AnAction> getAddActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        DatabaseConfigEditorImpl.DataSourceSettings settings = this.myEditor.getSettings();
        DbPsiFacade facade = settings.facade;
        LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(facade.getProject());
        Function toTemp = o -> this.isRemoved(o) ? null : this.myEditor.getTempTargetOrTarget(o).get();
        JBIterable newDrivers = JBIterable.from(settings.newDrivers).filterMap(toTemp);
        JBIterable existingDrivers = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filterMap(toTemp);
        actions.addAll(defaultManager.getCreateDataSourceActions(newDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)d2 -> this.onDataSourceCreated(facade, defaultManager, (DasDataSource)d2))));
        actions.add((AnAction)Separator.getInstance());
        actions.addAll(defaultManager.getCreateDataSourceActions(existingDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)d2 -> this.onDataSourceCreated(facade, defaultManager, (DasDataSource)d2))));
        actions.add((AnAction)Separator.getInstance());
        for (DataSourceManager<?> manager : DataSourceManager.getManagers(facade.getProject())) {
            if (manager == defaultManager) continue;
            ContainerUtil.addIfNotNull(actions, (Object)manager.getCreateDataSourceAction(d2 -> this.onDataSourceCreated(facade, manager, (DasDataSource)d2)));
        }
        actions.add((AnAction)new AddDataSourceFromUrl(this::onDataSourceCreated));
        actions.add((AnAction)new AddDataSourceFromPath.FromDialog(this::onDataSourceCreated));
        return actions;
    }

    @Nullable
    public static DataSourcesSideTab getDataSourcesTab(@Nullable AnActionEvent e) {
        return e == null ? null : (DataSourcesSideTab)ObjectUtils.tryCast((Object)e.getData(SIDE_PANEL), DataSourcesSideTab.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDataSources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocalDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AddAction
    extends ActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        private AddAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.add.text", new Object[0]), null, IconUtil.getAddIcon());
        }

        public boolean isPopup() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20);
            DbUIUtil.showPopup((JBPopup)popup2, null, e);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    AddAction.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }
            List<AnAction> actions = dataSourcesTab.getAddActions();
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        ChooseDriverGroup() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.change.driver.text", new Object[0]), DatabaseBundle.message("action.DatabaseConfigEditor.change.data.source.driver.description", new Object[0]), null);
        }

        public boolean isPopup() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                ChooseDriverGroup.$$$reportNull$$$0(0);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> dataSources = dataSourcesTab.getSelectedLocalDataSources();
            JBIterable<DatabaseDriver> drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource));
            e.getPresentation().setVisible(!dataSources.isEmpty());
            e.getPresentation().setEnabled(drivers.take(2).size() > 1);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            final DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            final JBIterable<SidePanelItem.DataSourceItem> dataSources = dataSourcesTab.getSelectedLocalDataSources();
            List drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource)).filterMap(o -> dataSourcesTab.myEditor.getTempTargetOrTarget(o).get()).toList();
            if (drivers.size() < 2) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            final Set selection = dataSourcesTab.getSelectedItems().toSet();
            ArrayList<1> res2 = new ArrayList<1>();
            for (final DatabaseDriver driver : drivers) {
                res2.add(new DumbAwareAction(driver.getName(), null, driver.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e1) {
                        if (e1 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (SidePanelItem.DataSourceItem item : dataSources) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class);
                            if (configurable == null) continue;
                            configurable.setDriver(driver);
                        }
                        dataSourcesTab.restoreSelection(selection);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup$1", "actionPerformed"));
                    }
                });
            }
            AnAction[] anActionArray = res2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooseDriverGroup.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SourceLoadingAction
    extends ActionGroup {
        private final AnAction[] mySetActions = new AnAction[]{new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.none.text", new Object[0]), DBIntrospectionOptions.SourceLoading.NO_SOURCES), new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.except.system.schemas.text", new Object[0]), DBIntrospectionOptions.SourceLoading.USER_SOURCES), new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.all.schemas.text", new Object[0]), DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES)};

        SourceLoadingAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.load.sources.text", new Object[0]), DatabaseBundle.message("action.DatabaseConfigEditor.which.sources.to.load.description", new Object[0]), AllIcons.Actions.Download);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.mySetActions == null) {
                SourceLoadingAction.$$$reportNull$$$0(0);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                SourceLoadingAction.$$$reportNull$$$0(1);
            }
            boolean enabled = (dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) != null && !dataSourcesTab.getSelectedLocalDataSources().isEmpty();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class SetValueAction
        extends DumbAwareAction {
            private final DBIntrospectionOptions.SourceLoading myMode;

            SetValueAction(@NotNull @NlsActions.ActionText String caption, @NotNull DBIntrospectionOptions.SourceLoading mode) {
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (mode == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                super(caption);
                this.myMode = mode;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DataSourcesSideTab dataSourcesTab;
                if (e == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                    return;
                }
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class);
                    if (configurable == null) continue;
                    configurable.setSourceLoading(this.myMode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class DataSourceScopeAction
    extends DumbAwareAction {
        DataSourceScopeAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.data.source.scope.text", new Object[0]), null, AllIcons.ToolbarDecorator.Import);
        }

        boolean isIDEScopeSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(0);
            }
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            boolean isIDEScope = true;
            if (dataSourcesTab != null) {
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    isIDEScope &= item.isGlobal();
                }
            }
            return isIDEScope;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(1);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setEnabled(!dataSourcesTab.getSelectedLocalDataSources().filter(ds -> DataSourceScopeAction.canMoveToScope(e.getProject(), ds, null)).isEmpty());
            }
            e.getPresentation().setText(DatabaseBundle.message(this.isIDEScopeSelected(e) ? "action.DatabaseConfigEditor.move.to.project.text" : "action.DatabaseConfigEditor.make.global.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(2);
            }
            boolean isIDEScope = this.isIDEScopeSelected(e);
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e);
            if (dataSourcesTab == null) {
                return;
            }
            for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable;
                if (!DataSourceScopeAction.canMoveToScope(e.getProject(), item, !isIDEScope) || (configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class)) == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
            DatabaseConfigEditorImpl editor = dataSourcesTab.myEditor;
            editor.refillSidePanel(editor.getSettings(), true);
        }

        private static boolean canMoveToScope(Project project, SidePanelItem.DataSourceItem item, Boolean global) {
            LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)item.getObject()).getDelegate(), LocalDataSource.class);
            if (ds == null) {
                return false;
            }
            String id = ds.getUniqueId();
            if (global == null) {
                global = !ds.isGlobal();
            }
            DataSourceStorage storage = DbSrcUtils.getDataSourceStorage(global != false ? null : project);
            for (LocalDataSource source : storage.getDataSources()) {
                if (source.isGlobal() != global.booleanValue() || !id.equals(source.getUniqueId()) || source == ds) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$DataSourceScopeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIDEScopeSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        GoToDriverAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.go.to.driver.text", new Object[0]), null, AllIcons.General.Settings);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(0);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(DataSourcesSideTab.getDataSourcesTab(e) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            LocalDataSource localDataSource;
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(1);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection = dataSourcesTab.getSelectedDataSources();
            SidePanelItem.DataSourceItem dataSource2 = (SidePanelItem.DataSourceItem)selection.first();
            LocalDataSource localDataSource2 = localDataSource = dataSource2 == null ? null : dataSource2.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            dataSourcesTab.myEditor.navigateTo(localDataSource.getDatabaseDriver(), false);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            DataSourcesSideTab dataSourcesTab;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(2);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e)) == null) {
                return false;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection = dataSourcesTab.getSelectedDataSources();
            if (selection.size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = Objects.requireNonNull((SidePanelItem.DataSourceItem)selection.first()).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$GoToDriverAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

