/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.text.TextResultView;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpDataForm {
    private static final List<DataConsumer.Column> PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "id", 4, "int", "java.lang.Integer"), new DataConsumer.Column(1, "first_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(3, "birth", 12, "varchar", "java.lang.String"));
    private static final List<DataConsumer.Row> PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create(0, new Object[]{10001, "Georgi", "Facello", "M", "1953-09-02"}), DataConsumer.Row.create(1, new Object[]{10002, "Bezalel", "Simmel", "F", "1964-06-02"}), DataConsumer.Row.create(2, new Object[]{10003, "Parto", "Bamford", "M", "1959-12-03"}), DataConsumer.Row.create(3, new Object[]{10004, "Chirstian", "Koblick", "M", "1954-05-01"}), DataConsumer.Row.create(4, new Object[]{10005, "Kyoichi", "Maliniak", "M", "1955-01-21"}), DataConsumer.Row.create(5, new Object[]{10006, "Anneke", "Preusig", "F", "1953-04-20"}), DataConsumer.Row.create(6, new Object[]{10007, "Tzvetan", "Zielinski", "F", "1957-05-23"}), DataConsumer.Row.create(7, new Object[]{10008, "Saniya", "Kalloufi", "M", "1958-02-19"}), DataConsumer.Row.create(8, new Object[]{10009, "Sumant", "Peac", "F", "1952-04-19"}), DataConsumer.Row.create(9, new Object[]{10010, "Duangkaew", "Piveteau", "F", "1963-06-01"}));
    private static final List<DataConsumer.Column> MONGO_PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "_id", 1111, "objectId", "org.bson.types.ObjectId"), new DataConsumer.Column(1, "first_name", 12, "string", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "string", "java.lang.String"), new DataConsumer.Column(3, "gender", 12, "string", "java.lang.String"), new DataConsumer.Column(4, "phones", 1111, "array", "java.lang.List"));
    private static final List<DataConsumer.Row> MONGO_PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create(0, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e5e7711f704714f53ebf2af"), "Georgi", "Facello", "M", Arrays.asList("136-73018", "458-97405")}), DataConsumer.Row.create(1, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6a"), "Bezalel", "Simmel", "F", Collections.singletonList("869-28540")}), DataConsumer.Row.create(2, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401e"), "Parto", "Bamford", "M", Arrays.asList("752-48018", "752-25445")}), DataConsumer.Row.create(3, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401f"), "Chirstian", "Koblick", "M", Collections.emptyList()}), DataConsumer.Row.create(4, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a70"), "Kyoichi", "Maliniak", "M", Collections.singletonList("985-85742")}), DataConsumer.Row.create(5, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6e"), "Anneke", "Preusig", "F", Collections.emptyList()}), DataConsumer.Row.create(6, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6c"), "Tzvetan", "Zielinski", "F", Collections.singletonList("574-76427")}), DataConsumer.Row.create(7, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a79"), "Saniya", "Kalloufi", "M", Collections.singletonList("362-98543")}), DataConsumer.Row.create(8, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7a"), "Sumant", "Peac", "F", Arrays.asList("462-24753", "324524")}), DataConsumer.Row.create(9, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7c"), "Duangkaew", "Piveteau", "F", Collections.singletonList("356-08750")}));
    private static final int MAX_ROWS_FOR_PREVIEW = 10;
    private static final int MAX_SOURCE_HEIGHT = 100;
    private static final Logger LOG = Logger.getInstance(DumpDataForm.class);
    private static final Set<String> EXTRACTORS_NO_TRANSPOSE = ContainerUtil.set((Object[])new String[]{"SQL-Insert-Statements.sql.groovy", "JSON-Groovy.json.groovy"});
    private final DumpDataDialog myDialog;
    private final Project myProject;
    private final DumpSource<?> mySource;
    private final EditorEx myViewer;
    public JPanel myPanel;
    private JBCheckBox myAddComputed;
    private JBCheckBox myAddGenerated;
    private JBCheckBox myAddTableDefinition;
    private LabeledComponent<JComponent> myPreviewLabeledComponent;
    private JBCheckBox myTranspose;
    private JBLabel myAddColumnsLabel;
    private LabeledComponent<TextFieldWithBrowseButton> myOutputFileOrDirectory;
    private final OutputPathManager myOutputPathManager;
    private LabeledComponent<ComboBox<DataExtractorFactory>> myExtractorCombobox;
    private LabeledComponent<JBScrollPane> mySourceLabeledComponent;
    private JBCheckBox myAddColumnHeader;
    private JBCheckBox myAddRowHeader;
    private JBCheckBox myAddQuery;

    public DumpDataForm(@NotNull DumpDataDialog dialog2, @NotNull Project project, @NotNull DumpSource<?> source) {
        if (dialog2 == null) {
            DumpDataForm.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DumpDataForm.$$$reportNull$$$0(1);
        }
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(2);
        }
        this.myDialog = dialog2;
        this.myProject = project;
        this.mySource = source;
        this.$$$setupUI$$$();
        String sourceText = DumpDataForm.getSourceText(this.mySource);
        if (sourceText == null) {
            this.mySourceLabeledComponent.setVisible(false);
        } else {
            JEditorPane pane = new JEditorPane();
            pane.setMargin((Insets)JBUI.insets((int)5));
            pane.setEditable(false);
            pane.setText(sourceText);
            pane.setBackground(UIUtil.getPanelBackground());
            JBScrollPane scrollPane = (JBScrollPane)this.mySourceLabeledComponent.getComponent();
            scrollPane.setViewportView((Component)pane);
            if (scrollPane.getPreferredSize().height > 100) {
                scrollPane.setPreferredSize(new Dimension(-1, 100));
            }
        }
        ArrayList<DataExtractorFactory> factories = new ArrayList<DataExtractorFactory>();
        factories.addAll(DataExtractorFactories.getLegacy());
        factories.addAll(DataExtractorFactories.getCsvFormats());
        List scripts = DataExtractorFactories.getScripts();
        scripts = ContainerUtil.sorted(scripts, Comparator.comparing(s2 -> StringUtil.toLowerCase((String)s2.getName())));
        factories.addAll(scripts);
        String currentFactoryId = DataExtractorProperties.getCurrentExportExtractorFactory(this.myProject).getId();
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        comboBox.setSwingPopup(false);
        comboBox.setModel(new DefaultComboBoxModel<DataExtractorFactory>(factories.toArray(new DataExtractorFactory[0])));
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", DataExtractorFactories::getDisplayName));
        DataExtractorFactory currentFactory = (DataExtractorFactory)ContainerUtil.find(factories, factory -> currentFactoryId.equals(factory.getId()));
        comboBox.setSelectedItem((Object)currentFactory);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateCheckboxes();
                this.updateFileExtension();
            }
        });
        this.updateCheckboxes();
        this.myAddComputed.setSelected(!DataExtractorProperties.isSkipComputed());
        this.myAddComputed.addItemListener(e -> this.settingsChanged());
        this.myAddGenerated.setSelected(!DataExtractorProperties.isSkipGeneratedColumns());
        this.myAddGenerated.addItemListener(e -> this.settingsChanged());
        this.myAddTableDefinition.setSelected(DataExtractorProperties.isIncludeCreateTable());
        this.myAddTableDefinition.addItemListener(e -> this.settingsChanged());
        this.myTranspose.setSelected(this.mySource instanceof DumpSource.DataGridSource && ((DumpSource.DataGridSource)this.mySource).getGrid().getResultView().isTransposed());
        this.myTranspose.addItemListener(e -> this.settingsChanged());
        this.myAddColumnHeader.addItemListener(e -> this.settingsChanged());
        this.myAddRowHeader.addItemListener(e -> this.settingsChanged());
        this.myAddQuery.setSelected(DataExtractorProperties.isIncludeQuery());
        this.myAddQuery.addItemListener(e -> this.settingsChanged());
        this.myOutputPathManager = DumpAction.getSize(source) == 1 ? new OutputFilePathManager() : new OutputDirectoryPathManager();
        this.myOutputFileOrDirectory.setText(this.myOutputPathManager.getFieldName());
        final String defaultFileName = ExtractionHelper.prepareFileName(DumpDataForm.getName(this.mySource));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).setText(this.myOutputPathManager.getFilePath(DataExtractorProperties.getOutputDir(), defaultFileName, currentFactory.getFileExtension()));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DumpDataForm.this.myOutputPathManager.focusGained((TextFieldWithBrowseButton)DumpDataForm.this.myOutputFileOrDirectory.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        descriptor2.setTitle(DatabaseBundle.message("settings.database.DumpDialog.FileChooser.Title", new Object[0]));
        ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).addBrowseFolderListener(new TextBrowseFolderListener(descriptor2, project){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                DataExtractorFactory factory;
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((factory = DumpDataForm.this.getFactory()) == null) {
                    String string = super.chosenFileToResultingText(chosenFile);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = DumpDataForm.this.myOutputPathManager.adjustChosenFile(chosenFile, defaultFileName, factory.getFileExtension());
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myViewer = TextResultView.createEditor(this.myProject, "dumpDataPreview");
        Disposer.register((Disposable)dialog2.getDisposable(), () -> EditorFactory.getInstance().releaseEditor((Editor)this.myViewer));
        this.myPreviewLabeledComponent.setComponent(this.myViewer.getComponent());
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.settingsChanged();
            }
        });
    }

    @NotNull
    private static <T> String getName(DumpSource<T> source) {
        JBIterable<T> sources = source.getSources();
        Object first2 = sources.first();
        String name = first2 == null ? null : source.getNameProvider().getName(first2);
        String string = name == null ? "" : name;
        if (string == null) {
            DumpDataForm.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public OutputPathManager getOutputPathManager() {
        OutputPathManager outputPathManager = this.myOutputPathManager;
        if (outputPathManager == null) {
            DumpDataForm.$$$reportNull$$$0(4);
        }
        return outputPathManager;
    }

    @NlsSafe
    @Nullable
    private static String getSourceText(@Nullable DumpSource<?> source) {
        if (source instanceof DumpSource.DataGridSource) {
            DasTable table = DataGridUtilCore.getDatabaseTable(((DumpSource.DataGridSource)source).getGrid());
            return table == null ? null : QNameUtil.getQualifiedName(table);
        }
        if (source instanceof DumpSource.DbTablesSource) {
            StringBuilder sb = new StringBuilder();
            for (DbElement target : ((DumpSource.DbTablesSource)source).getSources()) {
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append(QNameUtil.getQualifiedName(target));
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        return null;
    }

    @NotNull
    public JTextField getOutputFileOrDirectoryField() {
        JTextField jTextField = ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getTextField();
        if (jTextField == null) {
            DumpDataForm.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @NotNull
    public ComboBox<DataExtractorFactory> getExtractorComboBox() {
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        if (comboBox == null) {
            DumpDataForm.$$$reportNull$$$0(6);
        }
        return comboBox;
    }

    private void updateFileExtension() {
        DataExtractorFactory factory = this.getFactory();
        if (factory != null) {
            String text2 = this.myOutputPathManager.updateFileExtension(((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getText(), factory.getFileExtension());
            ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).setText(text2);
        }
    }

    private void updateCheckboxes() {
        DataExtractorFactory factory = this.getFactory();
        if (factory == null) {
            return;
        }
        this.myTranspose.setVisible(DumpDataForm.supportsTranspose(factory));
        this.myAddTableDefinition.setVisible(DumpDataForm.supportsAddTableDefinition(factory));
        boolean supportsComputedOrGenerated = DumpDataForm.supportsAddComputedOrGeneratedColumns(factory);
        this.myAddColumnsLabel.setVisible(supportsComputedOrGenerated);
        this.myAddComputed.setVisible(supportsComputedOrGenerated);
        this.myAddGenerated.setVisible(supportsComputedOrGenerated);
        this.myAddColumnHeader.setVisible(factory instanceof DataExtractorFactories.Format);
        this.myAddRowHeader.setVisible(factory instanceof DataExtractorFactories.Format);
        this.myAddQuery.setVisible(factory instanceof DataExtractorFactories.Xlsx);
        if (factory instanceof DataExtractorFactories.Format) {
            CsvFormat format = ((DataExtractorFactories.Format)factory).getFormat();
            this.myAddColumnHeader.setSelected(format.headerRecord != null);
            this.myAddRowHeader.setSelected(format.rowNumbers);
        }
    }

    @Nullable
    DataExtractorFactory getFactory() {
        return (DataExtractorFactory)ObjectUtils.tryCast((Object)((ComboBox)this.myExtractorCombobox.getComponent()).getSelectedItem(), DataExtractorFactory.class);
    }

    private static boolean supportsAddComputedOrGeneratedColumns(DataExtractorFactory factory) {
        return factory instanceof DataExtractorFactories.SqlInserts;
    }

    private static boolean supportsTranspose(DataExtractorFactory factory) {
        return !(factory instanceof DataExtractorFactories.SqlInserts) && !(factory instanceof DataExtractorFactories.SqlUpdates) && !(factory instanceof DataExtractorFactories.Xlsx) && (!(factory instanceof DataExtractorFactories.Script) || !EXTRACTORS_NO_TRANSPOSE.contains(factory.getName()));
    }

    private static boolean supportsAddTableDefinition(DataExtractorFactory factory) {
        return factory instanceof DataExtractorFactories.SqlInserts;
    }

    private void settingsChanged() {
        this.saveState();
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(), ModalityState.stateForComponent((Component)this.myDialog.getWindow()));
    }

    void updatePreview() {
        DataExtractor extractor;
        List<DataConsumer.Column> columns;
        List<DataConsumer.Row> rows;
        DataGrid grid = this.mySource instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)this.mySource).getGrid() : null;
        DasTable table = grid != null ? DataGridUtilCore.getDatabaseTable(grid) : null;
        Dbms dbms = DumpAction.getDbms(this.mySource);
        if (grid != null) {
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            rows = model.getRows(ModelIndexSet.forRows(grid, IntStream.range(0, Math.min(10, model.getRowCount())).toArray()));
            columns = model.getColumns();
        } else {
            rows = dbms.isMongo() ? MONGO_PREVIEW_ROWS : PREVIEW_ROWS;
            columns = dbms.isMongo() ? MONGO_PREVIEW_COLUMNS : PREVIEW_COLUMNS;
        }
        DataExtractorFactory extractorFactory = this.getFactory();
        DataExtractor dataExtractor = extractorFactory == null ? null : (extractor = extractorFactory.createExtractor(this.myProject, dbms, grid != null ? grid.getObjectFormatter() : null, table));
        if (extractor == null) {
            LOG.error("Cannot create data extractor. DataExtractorFactory: " + (extractorFactory == null ? "unknown" : extractorFactory.getName()));
            TextResultView.updateEditorText(this.myViewer, this.myProject, "", (Language)PlainTextLanguage.INSTANCE);
            return;
        }
        if (extractor instanceof DataExtractor.Binary) {
            TextResultView.updateEditorText(this.myViewer, this.myProject, "Extractor is binary. Preview is not available", (Language)PlainTextLanguage.INSTANCE);
            return;
        }
        StringBuilder sb = new StringBuilder();
        ExtractorsUtil.extract(CharOut.Util.newSink(sb), DumpAction.getDbms(this.mySource), this.getExtractorConfig(), columns, (DataExtractor.Text)extractor, rows, grid != null ? grid.getVisibleColumns().asArray() : new int[]{});
        TextResultView.updateEditorText(this.myViewer, this.myProject, sb.toString(), this.guessLanguage());
    }

    @NotNull
    private Language guessLanguage() {
        DataExtractorFactory selectedFactory = this.getFactory();
        return DumpDataForm.guessLanguage(selectedFactory == null ? null : selectedFactory.getFileExtension());
    }

    @NotNull
    private static Language guessLanguage(@Nullable String extension) {
        if (extension == null) {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            if (plainTextLanguage == null) {
                DumpDataForm.$$$reportNull$$$0(7);
            }
            return plainTextLanguage;
        }
        Language language = (Language)ObjectUtils.notNull((Object)LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension(extension)), (Object)PlainTextLanguage.INSTANCE);
        if (language == null) {
            DumpDataForm.$$$reportNull$$$0(8);
        }
        return language;
    }

    public ExtractionConfig getExtractorConfig() {
        return new ExtractionConfig(DumpDataForm.get(this.myAddTableDefinition), DumpDataForm.get(this.myTranspose), DumpDataForm.get(this.myAddComputed), DumpDataForm.get(this.myAddGenerated), DumpDataForm.get(this.myAddColumnHeader), DumpDataForm.get(this.myAddRowHeader), DumpDataForm.get(this.myAddQuery));
    }

    private static boolean get(@NotNull JBCheckBox checkBox) {
        if (checkBox == null) {
            DumpDataForm.$$$reportNull$$$0(9);
        }
        return checkBox.isEnabled() && checkBox.isSelected();
    }

    public void saveState() {
        if (DumpDataForm.enabled(this.myAddComputed)) {
            DataExtractorProperties.setSkipComputed(!this.myAddComputed.isSelected());
        }
        if (DumpDataForm.enabled(this.myAddGenerated)) {
            DataExtractorProperties.setSkipGeneratedColumns(!this.myAddGenerated.isSelected());
        }
        if (DumpDataForm.enabled(this.myAddTableDefinition)) {
            DataExtractorProperties.setIncludeCreateTable(this.myAddTableDefinition.isSelected());
        }
        if (DumpDataForm.enabled(this.myAddQuery)) {
            DataExtractorProperties.setIncludeQuery(this.myAddQuery.isSelected());
        }
        String filePath = ((TextFieldWithBrowseButton)this.myOutputFileOrDirectory.getComponent()).getText();
        DataExtractorProperties.setOutputDir(DumpDataForm.getDir(filePath));
        DataExtractorFactory factory = this.getFactory();
        if (factory != null) {
            DataExtractorProperties.setCurrentExportExtractorFactory(this.myProject, factory);
        }
    }

    private static boolean enabled(JBCheckBox checkbox) {
        return checkbox.isVisible() && checkbox.isEnabled();
    }

    private static String getDir(String filePath) {
        int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        return lastSlash == -1 ? (StringUtil.containsChar((String)filePath, (char)'.') ? "" : filePath) : (filePath.length() - 1 == lastSlash ? filePath.substring(0, filePath.length() - 1) : (filePath.indexOf(46, lastSlash) == -1 ? filePath : filePath.substring(0, lastSlash)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileOrDirectoryField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorComboBox";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox7;
        LabeledComponent labeledComponent4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, new Dimension(400, 500), null));
        this.myPreviewLabeledComponent = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Preview"));
        jPanel2.add((Component)labeledComponent4, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 8, 2, 1, 3, new Dimension(400, -1), new Dimension(400, -1), new Dimension(400, -1)));
        this.myAddComputed = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.ComputedColumns"));
        jPanel3.add((Component)jBCheckBox7, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAddColumnsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumns"));
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddGenerated = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.GeneratedColumns"));
        jPanel3.add((Component)jBCheckBox6, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 2, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(9, 2, 1, 2, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        this.myTranspose = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Transpose"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(4, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddTableDefinition = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddTableDefinition"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myOutputFileOrDirectory = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.SaveTo.File"));
        jPanel3.add((Component)labeledComponent3, new GridConstraints(10, 0, 1, 4, 0, 1, 3, 3, null, null, null));
        this.myExtractorCombobox = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Extractor"));
        jPanel3.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 3, null, new Dimension(295, -1), new Dimension(295, -1)));
        this.mySourceLabeledComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBScrollPane");
        labeledComponent.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Source"));
        jPanel3.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(11, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myAddColumnHeader = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumnHeader"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddRowHeader = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddRowHeader"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddQuery = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Excel.AddQuery"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class OutputDirectoryPathManager
    implements OutputPathManager {
        private OutputDirectoryPathManager() {
        }

        @Override
        @NotNull
        public String getFilePath(@NotNull String dirPath, @NotNull String defaultName, @NotNull String extension) {
            if (dirPath == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(0);
            }
            if (defaultName == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(1);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(2);
            }
            String string = dirPath;
            if (string == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFieldName() {
            String string = DatabaseBundle.message("settings.database.DumpDialog.SaveTo.Directory", new Object[0]);
            if (string == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String updateFileExtension(@NotNull String filePath, @NotNull String extension) {
            if (filePath == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(5);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(6);
            }
            String string = filePath;
            if (string == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String adjustChosenFile(@NotNull VirtualFile file, @NotNull String defaultName, @NotNull String extension) {
            if (file == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(8);
            }
            if (defaultName == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(9);
            }
            if (extension == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(10);
            }
            String string = file.isDirectory() ? file.getPresentableUrl() : file.getParent().getPresentableUrl();
            if (string == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(11);
            }
            return string;
        }

        @Override
        public String validatePath(String path) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            return virtualFile == null ? DatabaseBundle.message("settings.database.DumpDialog.Errors.DirNotExist", new Object[0]) : (!virtualFile.isDirectory() ? DatabaseBundle.message("settings.database.DumpDialog.Errors.NotDir", new Object[0]) : null);
        }

        @Override
        public void focusGained(@NotNull TextFieldWithBrowseButton field) {
            if (field == null) {
                OutputDirectoryPathManager.$$$reportNull$$$0(12);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirPath";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$OutputDirectoryPathManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$OutputDirectoryPathManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateFileExtension";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustChosenFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilePath";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFileExtension";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustChosenFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "focusGained";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OutputFilePathManager
    implements OutputPathManager {
        private OutputFilePathManager() {
        }

        @Override
        @NotNull
        public String getFilePath(@NotNull String dirPath, @NotNull String defaultName, @NotNull String extension) {
            if (dirPath == null) {
                OutputFilePathManager.$$$reportNull$$$0(0);
            }
            if (defaultName == null) {
                OutputFilePathManager.$$$reportNull$$$0(1);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(2);
            }
            String string = dirPath + File.separatorChar + defaultName + "." + extension;
            if (string == null) {
                OutputFilePathManager.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFieldName() {
            String string = DatabaseBundle.message("settings.database.DumpDialog.SaveTo.File", new Object[0]);
            if (string == null) {
                OutputFilePathManager.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void focusGained(@NotNull TextFieldWithBrowseButton field) {
            String filePath;
            int start2;
            if (field == null) {
                OutputFilePathManager.$$$reportNull$$$0(5);
            }
            if ((start2 = Math.max((filePath = field.getText()).lastIndexOf(47), filePath.lastIndexOf(92)) + 1) >= filePath.length()) {
                return;
            }
            int end2 = StringUtilRt.lastIndexOf((CharSequence)filePath, (char)'.', (int)start2, (int)filePath.length());
            if (end2 != -1) {
                field.getTextField().select(start2, end2);
            }
        }

        @Override
        @NotNull
        public String updateFileExtension(@NotNull String filePath, @NotNull String extension) {
            if (filePath == null) {
                OutputFilePathManager.$$$reportNull$$$0(6);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(7);
            }
            if (StringUtil.isEmptyOrSpaces((String)filePath)) {
                String string = filePath;
                if (string == null) {
                    OutputFilePathManager.$$$reportNull$$$0(8);
                }
                return string;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (virtualFile != null && virtualFile.isDirectory() || FileUtilRt.extensionEquals((String)filePath, (String)extension)) {
                String string = filePath;
                if (string == null) {
                    OutputFilePathManager.$$$reportNull$$$0(9);
                }
                return string;
            }
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            if (lastSlash == filePath.length() - 1) {
                String string = filePath;
                if (string == null) {
                    OutputFilePathManager.$$$reportNull$$$0(10);
                }
                return string;
            }
            String name = FileUtilRt.getNameWithoutExtension((String)(lastSlash == -1 ? filePath : filePath.substring(lastSlash + 1)));
            String string = PathUtil.getParentPath((String)filePath) + File.separatorChar + name + "." + extension;
            if (string == null) {
                OutputFilePathManager.$$$reportNull$$$0(11);
            }
            return string;
        }

        @Override
        @NotNull
        public String adjustChosenFile(@NotNull VirtualFile file, @NotNull String defaultName, @NotNull String extension) {
            if (file == null) {
                OutputFilePathManager.$$$reportNull$$$0(12);
            }
            if (defaultName == null) {
                OutputFilePathManager.$$$reportNull$$$0(13);
            }
            if (extension == null) {
                OutputFilePathManager.$$$reportNull$$$0(14);
            }
            String string = file.isDirectory() ? this.getFilePath(file.getPresentableUrl(), defaultName, extension) : file.getPresentableUrl();
            if (string == null) {
                OutputFilePathManager.$$$reportNull$$$0(15);
            }
            return string;
        }

        @Override
        public String validatePath(String path) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return virtualFile.isDirectory() ? DatabaseBundle.message("settings.database.DumpDialog.Errors.NotFile", new Object[0]) : null;
            }
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(PathUtil.getParentPath((String)path));
            return parentFile == null || !parentFile.isDirectory() ? DatabaseBundle.message("settings.database.DumpDialog.Errors.ParentDirNotExist", new Object[0]) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirPath";
                    break;
                }
                case 1: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 2: 
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm$OutputFilePathManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm$OutputFilePathManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateFileExtension";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustChosenFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilePath";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "focusGained";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFileExtension";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustChosenFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface OutputPathManager {
        @NotNull
        public String getFilePath(@NotNull String var1, @NotNull String var2, @NotNull String var3);

        @NlsContexts.Label
        @NotNull
        public String getFieldName();

        @NotNull
        public String updateFileExtension(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String adjustChosenFile(@NotNull VirtualFile var1, @NotNull String var2, @NotNull String var3);

        @NlsContexts.DialogMessage
        @Nullable
        public String validatePath(String var1);

        public void focusGained(@NotNull TextFieldWithBrowseButton var1);
    }
}

