/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class FullTextSearchForm {
    private EditorTextField mySearchText;
    private IntegerField myMaximumHitsCount;
    public JPanel myPanel;
    private JBCheckBox myMatchCaseCheckBox;
    private JPanel myTargetsPlaceholder;
    private JPanel myTargetsPanel;
    private JBList<DbElement> myTargetsList;
    private ComboBox<FullTextSearchOptions.SearchScope> mySearchCombobox;
    private ComboBox<FullTextSearchOptions.Location> myLocationInStringCombobox;
    private JPanel mySqlPreviewPanel;
    private Collection<DbElement> myTargets;
    private final Project myProject;

    public FullTextSearchForm(@NotNull Project project) {
        if (project == null) {
            FullTextSearchForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myTargets = new ArrayList<DbElement>();
        this.myProject = project;
        HideableDecorator executionOptionsDecorator = new HideableDecorator(this.myTargetsPlaceholder, DatabaseBundle.message("FullTextSearch.targets", new Object[0]), false);
        executionOptionsDecorator.setOn(true);
        executionOptionsDecorator.setContentComponent((JComponent)this.myTargetsPanel);
        this.mySearchCombobox.setModel((ComboBoxModel)new EnumComboBoxModel(FullTextSearchOptions.SearchScope.class));
        this.mySearchCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", FullTextSearchOptions.SearchScope::getName));
        this.myLocationInStringCombobox.setModel((ComboBoxModel)new EnumComboBoxModel(FullTextSearchOptions.Location.class));
        this.myLocationInStringCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", FullTextSearchOptions.Location::getName));
        SimpleListCellRenderer<DbElement> renderer = new SimpleListCellRenderer<DbElement>(){

            public void customize(@NotNull JList list, DbElement value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(value2.getDataSource().getIcon());
                this.setText(FullTextSearchForm.getFullName(value2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/FullTextSearchForm$1", "customize"));
            }
        };
        this.myTargetsList.setCellRenderer((ListCellRenderer)renderer);
        this.myTargetsList.setModel((ListModel)JBList.createDefaultListModel((Object[])new DbElement[0]));
        JComponent component = ListWithFilter.wrap(this.myTargetsList, (JScrollPane)ScrollPaneFactory.createScrollPane(this.myTargetsList), arg_0 -> this.lambda$new$0((SimpleListCellRenderer)renderer, arg_0));
        this.myTargetsPanel.add((Component)component, "Center");
    }

    private void addUpdateSqlPreviewListeners() {
        this.myTargetsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FullTextSearchForm.this.updateSqlPreview(true);
            }
        });
        this.mySearchText.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                FullTextSearchForm.this.updateSqlPreview();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/FullTextSearchForm$3", "documentChanged"));
            }
        });
        this.myMaximumHitsCount.getDocument().addDocumentListener(new javax.swing.event.DocumentListener(){

            @Override
            public void insertUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }

            @Override
            public void removeUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }

            @Override
            public void changedUpdate(javax.swing.event.DocumentEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }
        });
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                FullTextSearchForm.this.updateSqlPreview();
            }
        };
        this.myLocationInStringCombobox.addItemListener(itemListener);
        this.mySearchCombobox.addItemListener(itemListener);
        this.myMatchCaseCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FullTextSearchForm.this.updateSqlPreview();
            }
        });
    }

    public void updateSqlPreview() {
        this.updateSqlPreview(false);
    }

    public void updateSqlPreview(boolean recreatePanel) {
        DbElement selectedElement = (DbElement)this.myTargetsList.getSelectedValue();
        SqlPreviewPanel oldPanel = null;
        if (this.mySqlPreviewPanel.getComponentCount() == 1 && (oldPanel = (SqlPreviewPanel)ObjectUtils.tryCast((Object)this.mySqlPreviewPanel.getComponent(0), SqlPreviewPanel.class)) != null && !oldPanel.getHideableDecorator().isExpanded()) {
            return;
        }
        SqlPreviewPanel preview = oldPanel;
        if (recreatePanel || preview == null) {
            this.mySqlPreviewPanel.removeAll();
            preview = new SqlPreviewPanel(this.myProject, selectedElement.getDataSource(), null, "", this.getClass().getName(), true, () -> {});
            this.mySqlPreviewPanel.add((Component)preview, "Center");
        }
        String query = FtsUtilKt.getQueryForFirstNElements(selectedElement, 100, this.getOptions());
        preview.getPreviewComponent().setQuery(query);
        String name = StringUtil.shortenTextWithEllipsis((String)selectedElement.getName(), (int)40, (int)10);
        preview.setTitle(DatabaseBundle.message("FullTextSearch.preview", name));
    }

    public boolean isValid() {
        try {
            this.myMaximumHitsCount.validateContent();
            return true;
        }
        catch (ConfigurationException ignored) {
            return false;
        }
    }

    public EditorTextField getSearchText() {
        return this.mySearchText;
    }

    public IntegerField getMaximumHitsCount() {
        return this.myMaximumHitsCount;
    }

    @NotNull
    public FullTextSearchOptions.Location getLocation() {
        FullTextSearchOptions.Location location = (FullTextSearchOptions.Location)((Object)this.myLocationInStringCombobox.getModel().getSelectedItem());
        if (location == null) {
            FullTextSearchForm.$$$reportNull$$$0(1);
        }
        return location;
    }

    public void apply(@NotNull FullTextSearchOptions options, @NotNull Collection<DbElement> targets2) {
        int maxNumOfFetchedRows;
        if (options == null) {
            FullTextSearchForm.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            FullTextSearchForm.$$$reportNull$$$0(3);
        }
        if ((maxNumOfFetchedRows = options.getMaxNumOfFetchedRows()) >= this.myMaximumHitsCount.getMinValue() && maxNumOfFetchedRows <= this.myMaximumHitsCount.getMaxValue()) {
            this.myMaximumHitsCount.setValue(Integer.valueOf(maxNumOfFetchedRows));
        }
        this.mySearchText.setText(options.getText());
        this.mySearchText.selectAll();
        ((EnumComboBoxModel)this.myLocationInStringCombobox.getModel()).setSelectedItem((Enum)options.getLocation());
        ((EnumComboBoxModel)this.mySearchCombobox.getModel()).setSelectedItem((Enum)options.getSearchScope());
        this.myTargets = targets2;
        DefaultListModel model = (DefaultListModel)((FilteringListModel)this.myTargetsList.getModel()).getOriginalModel();
        for (DbElement target : this.myTargets) {
            model.addElement(target);
        }
        this.addUpdateSqlPreviewListeners();
        this.myTargetsList.setSelectedIndex(0);
        DbElement selectedValue = (DbElement)this.myTargetsList.getSelectedValue();
        boolean supportsIlike = DbImplUtilCore.getJdbcHelper(selectedValue.getDbms()).supportsIlike();
        this.myMatchCaseCheckBox.setEnabled(supportsIlike);
        this.myMatchCaseCheckBox.setSelected(!supportsIlike || options.isMatchCase());
    }

    @NlsSafe
    private static String getFullName(@NotNull DbElement target) {
        if (target == null) {
            FullTextSearchForm.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder(target.getName());
        for (DbElement parent2 = target.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            sb.insert(0, ".").insert(0, parent2.getName());
        }
        return sb.toString();
    }

    @NotNull
    public String getText() {
        String string = StringUtil.notNullize((String)this.mySearchText.getText());
        if (string == null) {
            FullTextSearchForm.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Collection<DbElement> getTargets() {
        Collection<DbElement> collection = this.myTargets;
        if (collection == null) {
            FullTextSearchForm.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public ComboBox<FullTextSearchOptions.SearchScope> getSearchScopeCombobox() {
        return this.mySearchCombobox;
    }

    @NotNull
    public FullTextSearchOptions getOptions() {
        return new FullTextSearchOptions(this.getText(), this.myMatchCaseCheckBox.isSelected(), (FullTextSearchOptions.SearchScope)((Object)ObjectUtils.notNull((Object)((Object)((FullTextSearchOptions.SearchScope)((Object)this.mySearchCombobox.getSelectedItem()))), (Object)((Object)FullTextSearchOptions.DEFAULT_SEARCH_SCOPE))), (FullTextSearchOptions.Location)((Object)ObjectUtils.notNull((Object)((Object)((FullTextSearchOptions.Location)((Object)this.myLocationInStringCombobox.getSelectedItem()))), (Object)((Object)FullTextSearchOptions.DEFAULT_LOCATION))), this.myMaximumHitsCount.getValue());
    }

    private /* synthetic */ String lambda$new$0(SimpleListCellRenderer renderer, DbElement element2) {
        return ((JBLabel)renderer.getListCellRendererComponent(this.myTargetsList, (Object)element2, -1, false, false)).getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/FullTextSearchForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/FullTextSearchForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        ComboBox comboBox;
        IntegerField integerField;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        EditorTextField editorTextField2;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 1, null, null, null));
        this.mySearchText = editorTextField2 = new EditorTextField();
        jPanel5.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(300, -1), null));
        this.myMatchCaseCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.match.case"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationInStringCombobox = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(20, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 1, 1, 2, 8, 2, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.show.first"));
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaximumHitsCount = integerField = new IntegerField();
        integerField.setHorizontalAlignment(4);
        integerField.setMaxValue(1000);
        integerField.setMinValue(1);
        jPanel6.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, new Dimension(50, -1), new Dimension(50, 30), new Dimension(50, -1)));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.matches.per.table"));
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", FullTextSearchForm.class).getString("FullTextSearch.search.in"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySearchCombobox = comboBox = new ComboBox();
        comboBox.setEditable(false);
        jPanel4.add((Component)comboBox, new GridConstraints(1, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.mySqlPreviewPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 7, null, new Dimension(400, 200), null));
        this.myTargetsPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 5, 1, 0, 3, 0, 3, null, new Dimension(200, -1), null));
        this.myTargetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.myTargetsList = jBList = new JBList();
        jPanel.add((Component)jBList, "Center");
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

