/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewComponent {
    private final EditorTextField myPreviewEditor;
    private final EventDispatcher<OpenInConsoleListener> myDispatcher;
    private final DbDataSource myDataSource;

    public SqlPreviewComponent(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            SqlPreviewComponent.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            SqlPreviewComponent.$$$reportNull$$$0(1);
        }
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(2);
        }
        this.myDispatcher = EventDispatcher.create(OpenInConsoleListener.class);
        this.myDataSource = dataSource2;
        this.myPreviewEditor = DatabaseDialogsHelper.createLanguageEditorArea(project, this.myDataSource, searchPath, "", isViewer);
        this.setQuery(query);
    }

    public SqlPreviewComponent(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer, @NotNull Runnable closeDialog) {
        if (project == null) {
            SqlPreviewComponent.$$$reportNull$$$0(3);
        }
        if (dataSource2 == null) {
            SqlPreviewComponent.$$$reportNull$$$0(4);
        }
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(5);
        }
        if (closeDialog == null) {
            SqlPreviewComponent.$$$reportNull$$$0(6);
        }
        this(project, dataSource2, searchPath, query, isViewer);
        this.subscribeOpenInConsole(closeDialog::run);
    }

    public JComponent createToolbar() {
        JComponent open = DbUIUtil.createToolbar(new DefaultActionGroup(this.createActions(this.myDataSource)), (JComponent)this.myPreviewEditor);
        ((ActionToolbarImpl)open).setMiniMode(true);
        return open;
    }

    public void subscribeOpenInConsole(@NotNull OpenInConsoleListener listener2) {
        if (listener2 == null) {
            SqlPreviewComponent.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public EditorTextField getEditor() {
        return this.myPreviewEditor;
    }

    @NotNull
    public List<AnAction> createActions(final @NotNull DbDataSource delegate) {
        if (delegate == null) {
            SqlPreviewComponent.$$$reportNull$$$0(8);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new DumbAwareAction(DatabaseBundle.messagePointer("action.SqlPreviewPanel.open.query.in.console.text", new Object[0]), AllIcons.Actions.MoveTo2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String query;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbUIUtil.openInConsole(delegate, delegate, query = SqlPreviewComponent.this.getQuery(), true) == null) {
                    DbUIUtil.openInConsole(delegate, delegate, query, false);
                }
                ((OpenInConsoleListener)SqlPreviewComponent.this.myDispatcher.getMulticaster()).open();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/SqlPreviewComponent$1", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            SqlPreviewComponent.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public String getQuery() {
        return this.myPreviewEditor.getText();
    }

    public void setQuery(@NotNull String query) {
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(10);
        }
        this.myPreviewEditor.setText(query);
        this.myPreviewEditor.setCaretPosition(0);
        new UiNotifyConnector.Once((Component)this.myPreviewEditor, new Activatable(){

            public void showNotify() {
                Editor editor = SqlPreviewComponent.this.myPreviewEditor.getEditor();
                if (editor == null) {
                    return;
                }
                ScrollingModel model = editor.getScrollingModel();
                model.disableAnimation();
                model.scrollVertically(0);
                model.enableAnimation();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SqlPreviewComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SqlPreviewComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "subscribeOpenInConsole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OpenInConsoleListener
    extends EventListener {
        public void open();
    }
}

