/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlHighlightUsagesFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        MyValueToColumnHandler handler;
        if (editor == null) {
            SqlHighlightUsagesFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SqlHighlightUsagesFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            SqlHighlightUsagesFactory.$$$reportNull$$$0(2);
        }
        if ((handler = MyValueToColumnHandler.create(editor, file, target)) == null) {
            handler = MyColumnToValueHandler.createForInsertColumn(editor, file, target);
        }
        if (handler == null) {
            handler = MyColumnToValueHandler.createForViewColumn(editor, file, target);
        }
        return handler;
    }

    public static void processColumnElements(@NotNull PsiElement target, int fromIndex, int toIndex, @NotNull BiConsumer<@Nullable ? super PsiElement, ? super @Nullable String> consumer2) {
        SqlResultSetExpression query;
        if (target == null) {
            SqlHighlightUsagesFactory.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            SqlHighlightUsagesFactory.$$$reportNull$$$0(4);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(query = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)target, SqlResultSetExpression.class, (boolean)true)), SqlQueryExpression.class, (boolean)true) != null) {
            return;
        }
        SqlDmlInstruction instruction2 = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)query, SqlDmlInstruction.class, (boolean)true);
        if (instruction2 != null) {
            SqlTableType targetType = instruction2.getTargetType();
            for (int id = fromIndex; id < Math.min(toIndex, targetType.getColumnCount()); ++id) {
                consumer2.accept((PsiElement)targetType.getColumnElement(id), targetType.getColumnName(id));
            }
            return;
        }
        SqlCreateViewStatement createView = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)target, SqlCreateViewStatement.class, (boolean)true);
        if (createView != null) {
            SqlDefinition[] aliases = createView.getColumnAliases();
            for (int i2 = fromIndex; i2 < Math.min(toIndex, aliases.length); ++i2) {
                SqlDefinition alias = aliases[i2];
                consumer2.accept((PsiElement)alias, alias.getName());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/SqlHighlightUsagesFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightUsagesHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processColumnElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyValueToColumnHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        final PsiElement myTarget;
        final int myFromIndex;
        final int myToIndex;

        protected MyValueToColumnHandler(Editor editor, PsiFile file, PsiElement target, int fromIndex, int toIndex) {
            super(editor, file);
            this.myTarget = target;
            this.myFromIndex = fromIndex;
            this.myToIndex = toIndex;
        }

        @NotNull
        public List<PsiElement> getTargets() {
            return new SmartList((Object)this.myTarget);
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            if (targets2 == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(0);
            }
            if (selectionConsumer == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(1);
            }
            selectionConsumer.consume(targets2);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets2) {
            if (targets2 == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(2);
            }
            SqlHighlightUsagesFactory.processColumnElements(this.myTarget, this.myFromIndex, this.myToIndex, (e, name) -> this.addOccurrence((PsiElement)e));
        }

        @Nullable
        public static MyValueToColumnHandler create(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement element2) {
            IntRange indices;
            if (editor == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                MyValueToColumnHandler.$$$reportNull$$$0(5);
            }
            return (indices = SqlImplUtil.getImmediateColumnSourceIndices(element2, null, false)) != null ? new MyValueToColumnHandler(editor, file, element2, indices.getStart(), indices.getEndInclusive() + 1) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionConsumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectTargets";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeUsages";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyColumnToValueHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        final PsiElement myTarget;
        final SqlElement myColumnHolder;
        final int myIndex;

        protected MyColumnToValueHandler(Editor editor, PsiFile file, PsiElement element2, SqlElement columnHolder, int index2) {
            super(editor, file);
            this.myTarget = element2;
            this.myColumnHolder = columnHolder;
            this.myIndex = index2;
        }

        @NotNull
        public List<PsiElement> getTargets() {
            return new SmartList((Object)this.myTarget);
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            if (targets2 == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(0);
            }
            if (selectionConsumer == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(1);
            }
            selectionConsumer.consume(targets2);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets2) {
            if (targets2 == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(2);
            }
            this.computeUsagesInValues();
            this.computeUsagesInQuery();
        }

        private void computeUsagesInValues() {
            SqlValuesExpression expression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)this.myColumnHolder, SqlValuesExpression.class);
            if (expression == null) {
                return;
            }
            for (SqlExpression p2 : expression.getExpressions().filter(SqlParenthesizedExpression.class)) {
                PsiElement child = (PsiElement)SqlImplUtil.sqlChildren((PsiElement)p2).filter(Conditions.instanceOf((Class[])new Class[]{PsiErrorElement.class, SqlExpression.class})).skip(this.myIndex).first();
                if (child == null) continue;
                this.addOccurrence(child);
            }
        }

        private void computeUsagesInQuery() {
            SqlQueryExpression query;
            Object object = this.myColumnHolder instanceof SqlInsertDmlInstruction ? ((SqlInsertDmlInstruction)this.myColumnHolder).getQueryExpression() : (query = this.myColumnHolder instanceof SqlCreateViewStatement ? ((SqlCreateViewStatement)this.myColumnHolder).getQueryExpression() : null);
            if (!(query instanceof SqlQueryExpression)) {
                return;
            }
            SqlType type = query.getSqlType();
            if (!(type instanceof SqlTableType)) {
                return;
            }
            PsiElement element2 = ((SqlTableType)type).getImmediateSourceColumnElement(this.myIndex);
            while (element2 instanceof SqlImplicitTarget) {
                element2 = ((SqlImplicitTarget)element2).getContextElement();
            }
            if (element2 == null) {
                return;
            }
            SqlSelectClause selectClause = query.getSelectClause();
            if (PsiTreeUtil.isAncestor((PsiElement)selectClause, (PsiElement)element2, (boolean)true)) {
                this.addOccurrence(element2);
            }
        }

        @Nullable
        public static HighlightUsagesHandlerBase createForInsertColumn(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement element2) {
            if (editor == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(3);
            }
            if (file == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(5);
            }
            if (!(file instanceof SqlFile)) {
                return null;
            }
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceExpression.class);
            if (ref == null || ref.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
                return null;
            }
            SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlReferenceList.class);
            if (refList == null) {
                return null;
            }
            SqlTableColumnsList tableColList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)refList, SqlTableColumnsList.class);
            if (tableColList == null) {
                return null;
            }
            SqlDmlInstruction dml = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)tableColList, SqlDmlInstruction.class);
            if (dml == null || !(dml.getParent() instanceof SqlInsertStatement)) {
                return null;
            }
            List list = refList.getReferenceList();
            int id = list.indexOf(ref);
            return new MyColumnToValueHandler(editor, file, element2, (SqlElement)dml, id);
        }

        @Nullable
        public static HighlightUsagesHandlerBase createForViewColumn(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement element2) {
            if (editor == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(6);
            }
            if (file == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(7);
            }
            if (element2 == null) {
                MyColumnToValueHandler.$$$reportNull$$$0(8);
            }
            if (!(file instanceof SqlFile)) {
                return null;
            }
            SqlColumnAliasDefinition columnAlias = (SqlColumnAliasDefinition)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlColumnAliasDefinition.class);
            if (columnAlias == null) {
                return null;
            }
            int index2 = SqlImplUtil.revSiblings((PsiElement)columnAlias).filter(SqlColumnAliasDefinition.class).size() - 1;
            SqlCreateViewStatement createView = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)columnAlias, SqlCreateViewStatement.class);
            if (createView == null) {
                return null;
            }
            return new MyColumnToValueHandler(editor, file, element2, (SqlElement)createView, index2);
        }

        public boolean highlightReferences() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionConsumer";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectTargets";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeUsages";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createForInsertColumn";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createForViewColumn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

