/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final Tokenizer DEFINITION_TOKENIZER = new MyDefinitionTokenizer();
    private static final Tokenizer STRING_TOKENIZER = new StringTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        IElementType nodeType;
        IElementType iElementType = nodeType = element2 instanceof LeafPsiElement ? ((LeafPsiElement)element2).getElementType() : null;
        if (nodeType == SqlTokens.SQL_STRING_TOKEN) {
            Tokenizer tokenizer = STRING_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (nodeType == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element2 instanceof SqlAsExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element2 instanceof PsiNameIdentifierOwner) {
            Tokenizer tokenizer = DEFINITION_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element2);
        if (tokenizer == null) {
            SqlSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlSpellcheckingStrategy", "getTokenizer"));
    }

    private static class StringTokenizer
    extends EscapeSequenceTokenizer<SqlStringTokenElement> {
        private StringTokenizer() {
        }

        public void tokenize(@NotNull SqlStringTokenElement element2, TokenConsumer consumer2) {
            if (element2 == null) {
                StringTokenizer.$$$reportNull$$$0(0);
            }
            if (InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectedPsiFiles(element2.getParent()) != null) {
                return;
            }
            String text2 = element2.getText();
            TextRange range = element2.getRangeInElement();
            if (!text2.contains("\\") || !SqlStringLiteralEscaper.supportsSlashEscapes(element2, text2)) {
                consumer2.consumeToken((PsiElement)element2, text2, false, 0, range, (Splitter)PlainTextSplitter.getInstance());
            } else {
                String relevantText = range.substring(text2);
                StringBuilder unescapedText = new StringBuilder();
                int[] offsets = new int[relevantText.length() + 1];
                CodeInsightUtilCore.parseStringCharacters((String)relevantText, (StringBuilder)unescapedText, (int[])offsets);
                StringTokenizer.processTextWithOffsets((PsiElement)element2, (TokenConsumer)consumer2, (StringBuilder)unescapedText, (int[])offsets, (int)range.getStartOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlSpellcheckingStrategy$StringTokenizer", "tokenize"));
        }
    }

    private static class MyDefinitionTokenizer
    extends Tokenizer<PsiNameIdentifierOwner> {
        private MyDefinitionTokenizer() {
        }

        public void tokenize(@NotNull PsiNameIdentifierOwner element2, TokenConsumer consumer2) {
            if (element2 == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(0);
            }
            for (PsiElement identifier : MyDefinitionTokenizer.tokenize(element2)) {
                int start2;
                String text2;
                if (identifier == null) {
                    return;
                }
                if (identifier.getTextRange().isEmpty()) {
                    return;
                }
                int stop = text2.length();
                for (start2 = StringUtil.startsWithIgnoreCase((String)(text2 = identifier.getText()), (String)"u&") ? 2 : 0; !(start2 >= stop || Character.isLetter(text2.charAt(start2)) && text2.charAt(start2) != '@'); ++start2) {
                }
                while (stop > start2 && !Character.isLetter(text2.charAt(stop - 1))) {
                    --stop;
                }
                if (stop <= start2) continue;
                consumer2.consumeToken(identifier, text2, true, 0, TextRange.from((int)start2, (int)(stop - start2)), (Splitter)IdentifierSplitter.getInstance());
            }
        }

        @NotNull
        private static Collection<PsiElement> tokenize(@NotNull PsiNameIdentifierOwner element2) {
            SqlLanguageDialectEx dialect;
            PsiElement nameIdentifier;
            if (element2 == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(1);
            }
            if ((nameIdentifier = element2.getNameIdentifier()) instanceof SqlIdentifier) {
                List<PsiElement> list = Collections.singletonList(nameIdentifier);
                if (list == null) {
                    MyDefinitionTokenizer.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (nameIdentifier instanceof SqlReferenceExpression && (dialect = SqlImplUtil.getSqlDialectSafe(nameIdentifier)).isMultiIdReference((SqlReferenceExpression)nameIdentifier)) {
                List list = SqlImplUtil.sqlChildren((PsiElement)((SqlReferenceExpression)nameIdentifier).getIdentifier()).filter(e -> PsiUtilCore.getElementType((PsiElement)e) == SqlTokens.SQL_IDENT).toList();
                if (list == null) {
                    MyDefinitionTokenizer.$$$reportNull$$$0(3);
                }
                return list;
            }
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)nameIdentifier, SqlIdentifier.class);
            if (collection == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(4);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlSpellcheckingStrategy$MyDefinitionTokenizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlSpellcheckingStrategy$MyDefinitionTokenizer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tokenize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenize";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

