/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.DasUtil;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class SqlDataSourceUpdateQueue {
    private final Project myProject;
    private final Set<ComputedModel> myQueue;
    private volatile ProgressIndicator myProcessing;
    private ComputedModel myCurrent;

    SqlDataSourceUpdateQueue(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceUpdateQueue.$$$reportNull$$$0(0);
        }
        this.myQueue = new LinkedHashSet<ComputedModel>();
        this.myProject = project;
        Disposer.register((Disposable)project, this::stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(@NotNull ComputedModel dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceUpdateQueue.$$$reportNull$$$0(1);
        }
        Set<ComputedModel> set = this.myQueue;
        synchronized (set) {
            if (this.myCurrent == dataSource2 || this.myProject.isDisposed()) {
                return;
            }
            this.myQueue.add(dataSource2);
            if (this.myProcessing != null) {
                return;
            }
            this.myProcessing = new EmptyProgressIndicator();
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.serve(this.myProcessing));
        }
    }

    private void stop() {
        ProgressIndicator processing = this.myProcessing;
        if (processing != null) {
            processing.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serve(@NotNull ProgressIndicator indicator) {
        Object object;
        if (indicator == null) {
            SqlDataSourceUpdateQueue.$$$reportNull$$$0(2);
        }
        try {
            while (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                ComputedModel current;
                object = this.myQueue;
                synchronized (object) {
                    current = this.myCurrent = (ComputedModel)((Object)ContainerUtil.getFirstItem(this.myQueue));
                    if (this.myCurrent == null) {
                        this.myProcessing = null;
                        break;
                    }
                    this.myQueue.remove((Object)current);
                }
                current.compute(indicator);
                indicator.checkCanceled();
            }
        }
        finally {
            ArrayList<ComputedModel> rejected;
            object = this.myQueue;
            synchronized (object) {
                rejected = new ArrayList<ComputedModel>(this.myQueue);
                this.myQueue.clear();
                this.myCurrent = null;
                this.myProcessing = null;
            }
            for (ComputedModel model : rejected) {
                model.reject();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceUpdateQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enqueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "serve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ComputedModel
    extends SimpleModificationTracker
    implements Disposable {
        private volatile ModelFactory myModelFactory = ModelFactory.BLACK_HOLE;
        private volatile boolean myInvalidModel = true;
        private volatile BasicModModel myModel;
        protected volatile Map<BasicElement, Pointer<DasObject>> myElements = new HashMap<BasicElement, Pointer<DasObject>>();
        protected volatile Pair<SqlFile, Long> myIncomplete;
        private volatile long myRevision;
        private volatile ProgressIndicator myCurrentIndicator;
        private boolean myComputing = false;
        private final Alarm myComputationAlarm = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

        public DasModel getModel() {
            this.check();
            return this.myModel == null ? DasUtil.emptyModel() : this.myModel;
        }

        public void check() {
            long rev = this.getModificationCount();
            if (this.myModel == null || rev != this.myRevision) {
                this.reset(rev);
            }
        }

        public synchronized boolean isReady() {
            return !this.myComputing;
        }

        protected abstract boolean introspect(@NotNull ProgressIndicator var1);

        protected abstract Project getProject();

        protected abstract void changed();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset(long rev) {
            ComputedModel computedModel = this;
            synchronized (computedModel) {
                if (this.myModel != null && rev == this.myRevision) {
                    return;
                }
                if (this.myComputing) {
                    this.myRevision = rev;
                    ProgressIndicator indicator = this.myCurrentIndicator;
                    if (indicator != null) {
                        indicator.cancel();
                    }
                    return;
                }
                this.myComputationAlarm.cancelAllRequests();
                this.myComputationAlarm.addRequest(() -> SqlDataSourceStorage.getInstance((Project)this.getProject()).myQueue.enqueue(this), 500);
                this.myComputing = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void compute(@NotNull ProgressIndicator indicator) {
            ComputedModel computedModel;
            if (indicator == null) {
                ComputedModel.$$$reportNull$$$0(0);
            }
            try {
                while (true) {
                    computedModel = this;
                    // MONITORENTER : computedModel
                    long rev = this.myRevision;
                    this.myCurrentIndicator = new SensitiveProgressWrapper(indicator);
                    // MONITOREXIT : computedModel
                    if (this.getProject().isDisposed()) {
                        return;
                    }
                    boolean done = this.introspect(this.myCurrentIndicator);
                    ComputedModel computedModel2 = this;
                    // MONITORENTER : computedModel2
                    this.myCurrentIndicator = null;
                    if (done && this.myRevision == rev) {
                        // MONITOREXIT : computedModel2
                        return;
                    }
                    // MONITOREXIT : computedModel2
                    indicator.checkCanceled();
                }
            }
            finally {
                computedModel = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reject() {
            ComputedModel computedModel = this;
            synchronized (computedModel) {
                this.myComputing = false;
            }
        }

        protected synchronized BasicModModel ensureProperModel(@NotNull Dbms dbms) {
            if (dbms == null) {
                ComputedModel.$$$reportNull$$$0(1);
            }
            if (this.myModel == null || ((BasicMetaModel)this.myModel.getMetaModel()).dbms != dbms || this.myInvalidModel) {
                this.myModel = this.myModelFactory.createModel(dbms);
                this.myInvalidModel = false;
            }
            return this.myModel;
        }

        @TestOnly
        public synchronized void setModelFactory(ModelFactory mf) {
            this.myModelFactory = mf;
            this.myInvalidModel = true;
            this.incModificationCount();
        }

        public void dispose() {
        }

        @Nullable
        public DasObject fromModel(DasObject delegate) {
            Pointer<DasObject> element2 = this.myElements == null ? null : this.myElements.get(delegate);
            return element2 == null ? null : (DasObject)element2.dereference();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/database/SqlDataSourceUpdateQueue$ComputedModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureProperModel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

