/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeDialectToolbarAction
extends AlignedIconWithTextAction.Group
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        Condition<VirtualFile> condition = project == null ? null : ChangeDialectAction.FILE_FILTER(project);
        VirtualFile file = project != null && psiFile != null ? psiFile.getVirtualFile() : null;
        boolean isSqlFile = file != null && condition.value((Object)file);
        boolean isConsole = file != null && DbVFSUtils.isConsoleFile(file);
        Presentation presentation = e.getPresentation();
        boolean notMenuOrSearch = !ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        boolean enabledAndVisible = notMenuOrSearch && isSqlFile && !isConsole && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsole.findConsole(e) == null;
        presentation.setEnabledAndVisible(enabledAndVisible);
        if (!enabledAndVisible) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((PsiElement)psiFile);
        presentation.setText(dialect == null ? DatabaseBundle.message("ChangeDialectToolbarAction.action.dialect.text", new Object[0]) : dialect.getDisplayName());
        presentation.setDescription(DatabaseBundle.message("ChangeDialectToolbarAction.action.change.sql.dialect.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        if (e == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(1);
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : file.getVirtualFile();
        if (virtualFile == null || project == null) {
            return;
        }
        ListPopup popup2 = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile), "");
        JComponent button = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (button == null) {
            popup2.showInBestPositionFor(e.getDataContext());
            return;
        }
        popup2.showUnderneathOf((Component)button);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/sql/dialects/ChangeDialectToolbarAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

