/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlPasteProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/editor/SqlPasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "getElementsToPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/actionSystem/DataContext;)[Ljava/lang/Object;", "getSqlFile", "Lcom/intellij/sql/psi/SqlFile;", "isPasteEnabled", "", "isPastePossible", "performPaste", "", "intellij.database.sql.impl"})
public final class SqlPasteProvider
implements PasteProvider {
    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getSqlFile(dataContext) != null && this.getElementsToPaste(dataContext) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dataContext.getData(Comm\u2026taKeys.PROJECT) ?: return");
        Project project2 = project;
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"dataContext.getData(Comm\u2026ataKeys.EDITOR) ?: return");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document doc = document;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        psiDocumentManager.commitDocument(doc);
        PsiFile psiFile = psiDocumentManager.getPsiFile(doc);
        if (!(psiFile instanceof SqlFile)) {
            psiFile = null;
        }
        SqlFile sqlFile = (SqlFile)psiFile;
        if (sqlFile == null) {
            return;
        }
        SqlFile file = sqlFile;
        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)file)) {
            return;
        }
        Object[] objectArray = this.getElementsToPaste(dataContext);
        if (objectArray == null) {
            return;
        }
        Object[] elementsToPaste = objectArray;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project2, dialect).withDialect(dialect.getDatabaseDialect());
        int n = 0;
        int n2 = elementsToPaste.length;
        while (n < n2) {
            Object object;
            void i2;
            if (i2 > 0) {
                builder.symbol(",\n");
            }
            if (!((object = elementsToPaste[i2]) instanceof DasObject)) {
                object = null;
            }
            DasObject dasObject = (DasObject)object;
            if (dasObject == null) {
                return;
            }
            builder.identifier(dasObject);
            ++i2;
        }
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(psiDocumentManager, doc, editor2, builder){
            final /* synthetic */ PsiDocumentManager $psiDocumentManager;
            final /* synthetic */ Document $doc;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ DdlBuilder $builder;

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ performPaste.1 this$0;

                    public final void run() {
                        this.this$0.$psiDocumentManager.doPostponedOperationsAndUnblockDocument(this.this$0.$doc);
                        this.this$0.$psiDocumentManager.commitDocument(this.this$0.$doc);
                        EditorModificationUtil.deleteSelectedText((Editor)this.this$0.$editor);
                        Editor editor = this.this$0.$editor;
                        DdlBuilder ddlBuilder = this.this$0.$builder;
                        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder");
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)ddlBuilder.getStatement());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$psiDocumentManager = psiDocumentManager;
                this.$doc = document;
                this.$editor = editor;
                this.$builder = ddlBuilder;
            }
        }, SqlBundle.message("SqlPasteProvider.command.name.pasting.database.object.references", new Object[0]), null);
    }

    private final SqlFile getSqlFile(DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor == null || (editor = editor.getDocument()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"dataContext.getData(Comm\u2026?.document ?: return null");
        Editor doc = editor;
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dataContext.getData(Comm\u2026s.PROJECT) ?: return null");
        Project project2 = project;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)doc);
        if (!(psiFile instanceof SqlFile)) {
            psiFile = null;
        }
        return (SqlFile)psiFile;
    }

    private final Object[] getElementsToPaste(DataContext dataContext) {
        Object[] objectArray;
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        if (producer == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)producer, (String)"PasteAction.TRANSFERABLE\u2026taContext) ?: return null");
        Producer producer2 = producer;
        Transferable transferable = (Transferable)producer2.produce();
        if (transferable == null) {
            return null;
        }
        Transferable transferable2 = transferable;
        try {
            boolean bl;
            Object[] data;
            block7: {
                Object object = transferable2.getTransferData(DnDEventImpl.ourDataFlavor);
                if (!(object instanceof Object[])) {
                    object = null;
                }
                Object[] objectArray2 = (Object[])object;
                if (objectArray2 == null) {
                    return null;
                }
                Object[] $this$all$iv = data = objectArray2;
                boolean $i$f$all = false;
                Object[] objectArray3 = $this$all$iv;
                int n = objectArray3.length;
                for (int j = 0; j < n; ++j) {
                    Object element$iv;
                    Object it2 = element$iv = objectArray3[j];
                    boolean bl2 = false;
                    if (it2 instanceof DasObject) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            objectArray = bl ? data : null;
        }
        catch (Exception ignored) {
            objectArray = null;
        }
        return objectArray;
    }
}

