/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlCreateBodyStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u001a\u0010\u001f\u001a\u00020\u0014*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u001aC\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010!*\u00020\u00072*\u0010\"\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010#0!\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010#\u00a2\u0006\u0002\u0010$\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020%\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0010\u001a\u0014\u0010&\u001a\u00020\u0014*\u00020\u00182\u0006\u0010'\u001a\u00020\u001bH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006("}, d2={"toChange", "", "Lcom/intellij/database/util/Case;", "getToChange", "(Lcom/intellij/database/util/Case;)Z", "identifierIsBuiltInFunction", "parent", "Lcom/intellij/psi/PsiElement;", "isQuoted", "node", "Lcom/intellij/lang/ASTNode;", "namingService", "Lcom/intellij/database/script/generator/NamingService;", "obtainOriginalCase", "", "refExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "performModificationInBulk", "", "documentManager", "Lcom/intellij/psi/PsiDocumentManager;", "document", "Lcom/intellij/openapi/editor/Document;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "skipSpaces", "element", "whetherKeywordsUpper", "applyChangesInReversedOrder", "findSubSequence", "", "predicates", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;[Lkotlin/jvm/functions/Function1;)[Lcom/intellij/psi/PsiElement;", "Lcom/intellij/sql/psi/SqlIdentifier;", "performOneReplacement", "change", "intellij.database.sql.core.impl"})
@JvmName(name="SqlPreFormatHelper")
public final class SqlPreFormatHelper {
    public static final void performModificationInBulk(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull Collection<Change> changes) {
        Intrinsics.checkNotNullParameter((Object)documentManager, (String)"documentManager");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        DocumentUtil.executeInBulk((Document)document, (boolean)true, (Runnable)new Runnable(document, changes){
            final /* synthetic */ Document $document;
            final /* synthetic */ Collection $changes;

            public final void run() {
                SqlPreFormatHelper.access$applyChangesInReversedOrder(this.$document, this.$changes);
            }
            {
                this.$document = document;
                this.$changes = collection;
            }
        });
        if (documentManager.isUncommited(document)) {
            documentManager.commitDocument(document);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void applyChangesInReversedOrder(Document $this$applyChangesInReversedOrder, Collection<Change> changes) {
        int n = changes.size();
        if (n == 0) {
            return;
        }
        ArrayList<Change> theChanges = new ArrayList<Change>(changes);
        if (n > 1) {
            CollectionsKt.sort((List)theChanges);
        }
        int n2 = n - 1;
        boolean bl = false;
        while (n2 >= 0) {
            void i2;
            Change change = theChanges.get((int)i2);
            Intrinsics.checkNotNullExpressionValue((Object)change, (String)"theChanges[i]");
            SqlPreFormatHelper.performOneReplacement($this$applyChangesInReversedOrder, change);
            --i2;
        }
    }

    private static final void performOneReplacement(Document $this$performOneReplacement, Change change) {
        String string = $this$performOneReplacement.getText(change.range());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(change.range())");
        String text2 = string;
        String replacement = change.replacement;
        if (Intrinsics.areEqual((Object)text2, (Object)replacement)) {
            return;
        }
        int from = change.from;
        int till = change.till;
        if ($this$performOneReplacement.getRangeGuard(from, till) == null) {
            $this$performOneReplacement.replaceString(from, till, (CharSequence)replacement);
        }
    }

    public static final boolean isQuoted(@NotNull ASTNode node, @NotNull NamingService namingService) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)namingService, (String)"namingService");
        PsiElement element2 = node.getPsi();
        if (element2 instanceof SqlNameElement) {
            bl = ((SqlNameElement)element2).isQuotedIdentifier();
        } else {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            bl = namingService.isQuoted(string);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement[] findSubSequence(@NotNull PsiElement $this$findSubSequence, Function1<? super PsiElement, Boolean> ... predicates) {
        Intrinsics.checkNotNullParameter((Object)$this$findSubSequence, (String)"$this$findSubSequence");
        Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
        int n = predicates.length;
        PsiElement[] found = new PsiElement[n];
        PsiElement p2 = SqlPreFormatHelper.skipSpaces($this$findSubSequence);
        while (p2 != null) {
            PsiElement q = p2;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void i2;
                boolean ok = (Boolean)predicates[i2].invoke((Object)q);
                if (!ok) break;
                found[i2] = q;
                if (i2 == n - 1) {
                    return found;
                }
                if ((q = SqlPreFormatHelper.skipSpaces(q.getNextSibling())) == null) break;
                ++i2;
            }
            p2 = SqlPreFormatHelper.skipSpaces(p2.getNextSibling());
        }
        return null;
    }

    private static final PsiElement skipSpaces(PsiElement element2) {
        PsiElement e = element2;
        while (e instanceof PsiWhiteSpace) {
            e = ((PsiWhiteSpace)e).getNextSibling();
        }
        return e;
    }

    public static final boolean whetherKeywordsUpper(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement kw = element2;
        while (kw.getFirstChild() != null) {
            PsiElement e;
            kw = e;
        }
        String text2 = kw.getText();
        return text2 == null || text2.length() < 2 ? false : Character.isUpperCase(text2.charAt(1));
    }

    @Nullable
    public static final String obtainOriginalCase(@NotNull SqlIdentifier $this$obtainOriginalCase) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainOriginalCase, (String)"$this$obtainOriginalCase");
        PsiElement psiElement = $this$obtainOriginalCase.getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent2 = psiElement;
        return parent2 instanceof SqlReferenceExpression ? SqlPreFormatHelper.obtainOriginalCase((SqlReferenceExpression)parent2) : $this$obtainOriginalCase.getName();
    }

    public static final boolean identifierIsBuiltInFunction(@Nullable PsiElement parent2) {
        PsiElement psiElement = parent2;
        if (!(psiElement instanceof SqlReferenceExpression)) {
            psiElement = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
        Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
        if (!(object instanceof SqlFunctionCallExpression)) {
            object = null;
        }
        SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)object;
        if (sqlFunctionCallExpression == null) {
            return false;
        }
        SqlFunctionCallExpression call = sqlFunctionCallExpression;
        Number n = SqlFunctionsUtil.getSignatureNumber(call);
        if (n != null) {
            return true;
        }
        BuiltinFunction fd = call.getFunctionDefinition();
        return fd != null;
    }

    @Nullable
    public static final String obtainOriginalCase(@NotNull SqlReferenceExpression $this$obtainOriginalCase) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainOriginalCase, (String)"$this$obtainOriginalCase");
        DasSymbol dasSymbol = $this$obtainOriginalCase.resolveSymbol();
        if (dasSymbol == null) {
            return null;
        }
        DasSymbol symbol = dasSymbol;
        return SqlPreFormatHelper.obtainOriginalCase($this$obtainOriginalCase, symbol);
    }

    @Nullable
    public static final String obtainOriginalCase(@Nullable SqlReferenceExpression refExpr, @NotNull DasSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        DasSymbol definition = symbol;
        if (definition instanceof SqlCreateBodyStatementImpl) {
            DasObject dasObject = ((SqlCreateBodyStatementImpl)((Object)definition)).getDasParent();
            if (!(dasObject instanceof SqlDefinition)) {
                dasObject = null;
            }
            SqlDefinition sqlDefinition = (SqlDefinition)dasObject;
            DasSymbol dasSymbol = definition = sqlDefinition != null ? (DasSymbol)sqlDefinition : definition;
        }
        if (symbol instanceof DbElement) {
            Object object = ((DbElement)symbol).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.delegate");
            Object symbolDelegate = object;
            if (symbolDelegate instanceof BasicElement) {
                boolean preserves;
                BasicDatabase basicDatabase = ((BasicElement)symbolDelegate).getDatabase();
                if (basicDatabase == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)basicDatabase, (String)"symbolDelegate.database ?: return null");
                BasicDatabase db = basicDatabase;
                Casing casing = db.getCasing(((BasicElement)symbolDelegate).getKind(), null);
                Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"db.getCasing(symbolDelegate.kind, null)");
                Casing casing2 = casing;
                boolean bl = preserves = casing2.plain == Case.EXACT || casing2.plain == Case.MIXED;
                if (!preserves) {
                    return null;
                }
            }
        }
        String originName = null;
        if (definition instanceof SqlProcedureDefinitionImpl) {
            IElementType parentType;
            PsiElement psiElement = ((SqlProcedureDefinitionImpl)((Object)definition)).getParent();
            Object object = parentType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
            if (parentType != null && Intrinsics.areEqual((Object)parentType.toString(), (Object)"ORA_CREATE_PACKAGE_BODY_STATEMENT")) {
                DasObject originOne;
                NavigationHelper nh = NavigationHelper.EP.forDbms(Dbms.ORACLE);
                JBIterable pair = nh.findSuperDefinitions((DasObject)((Object)definition), false);
                JBIterable jBIterable = pair;
                DasObject dasObject = originOne = jBIterable != null && (jBIterable = (JBIterable)jBIterable.second) != null ? (DasObject)jBIterable.first() : null;
                String string = originName = dasObject != null ? dasObject.getName() : null;
            }
        }
        if (originName == null && definition instanceof SqlFileImpl.GroupImpl) {
            SqlDefinition sqlDefinition = (SqlDefinition)((SqlFileImpl.GroupImpl)definition).delegates().first();
            String string = originName = sqlDefinition != null ? sqlDefinition.getName() : null;
        }
        if (originName == null) {
            Object object;
            JBIterable<? extends PsiElement> jBIterable = definition.getPsiDeclarations();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"definition.psiDeclarations");
            Object object2 = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
            if (!(object2 instanceof PsiNamedElement)) {
                object2 = null;
            }
            if ((object = (PsiNamedElement)object2) == null || (object = object.getName()) == null) {
                object = originName = definition.getName();
            }
        }
        if (refExpr == null) {
            return originName;
        }
        String string = refExpr.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"refExpr.name");
        String thisName = string;
        return StringsKt.equals((String)originName, (String)thisName, (boolean)true) ? originName : null;
    }

    public static final boolean getToChange(@NotNull Case $this$toChange) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toChange), (String)"$this$toChange");
        return $this$toChange == Case.LOWER || $this$toChange == Case.UPPER || $this$toChange == Case.TITLE;
    }

    public static final /* synthetic */ void access$applyChangesInReversedOrder(Document $this$access_u24applyChangesInReversedOrder, Collection changes) {
        SqlPreFormatHelper.applyChangesInReversedOrder($this$access_u24applyChangesInReversedOrder, changes);
    }
}

