/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlCasePreFormatter;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.SqlQueryPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ,\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/sql/formatter/SqlPreFormatter;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "allowResolving", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiElement;Lcom/intellij/database/Dbms;Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Z)V", "casePreFormatter", "Lcom/intellij/sql/formatter/SqlCasePreFormatter;", "changes", "Ljava/util/ArrayList;", "Lcom/intellij/sql/formatter/Change;", "documentManager", "Lcom/intellij/psi/PsiDocumentManager;", "queryPreFormatter", "Lcom/intellij/sql/formatter/SqlQueryPreFormatter;", "readOnlyFragments", "", "Lcom/intellij/openapi/util/TextRange;", "calculateDelta", "", "fixRange", "range", "process", "processRecursively", "", "pa", "grandpa", "intellij.database.sql.core.impl"})
public final class SqlPreFormatter {
    private final PsiDocumentManager documentManager;
    private final ArrayList<Change> changes;
    private final List<TextRange> readOnlyFragments;
    private final SqlQueryPreFormatter queryPreFormatter;
    private final SqlCasePreFormatter casePreFormatter;
    private final Project project;
    private final Document document;
    private final PsiElement element;

    @NotNull
    public final TextRange process(@NotNull TextRange range) {
        PsiElement pa;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PostprocessReformattingAspect postprocessReformattingAspect = PostprocessReformattingAspect.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)postprocessReformattingAspect, (String)"PostprocessReformattingAspect.getInstance(project)");
        if (postprocessReformattingAspect.isDisabled()) {
            return range;
        }
        PsiElement psiElement = pa = this.element.getParent();
        this.processRecursively(this.element, pa, (PsiElement)(psiElement != null ? psiElement.getParent() : null), range);
        if (this.changes.size() >= 2) {
            CollectionsKt.sort((List)this.changes);
        }
        TextRange fixedRange = this.fixRange(range);
        SqlPreFormatHelper.performModificationInBulk(this.documentManager, this.document, (Collection<Change>)this.changes);
        int delta = this.calculateDelta();
        TextRange textRange = fixedRange.grown(delta);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"fixedRange.grown(delta)");
        return textRange;
    }

    private final void processRecursively(PsiElement element2, PsiElement pa, PsiElement grandpa, TextRange range) {
        TextRange elementTextRange;
        TextRange textRange = elementTextRange = element2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"elementTextRange");
        if (textRange.isEmpty() || !elementTextRange.intersectsStrict(range)) {
            return;
        }
        IElementType elementType = PsiTreeUtilKt.getElementType((PsiElement)element2);
        PsiElement child = element2.getFirstChild();
        if (child == null || Intrinsics.areEqual((Object)elementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
            this.casePreFormatter.processElement(element2, pa, grandpa);
        } else if (elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE) {
            this.queryPreFormatter.processQuery(element2);
        }
        while (child != null) {
            this.processRecursively(child, element2, pa, range);
            child = child.getNextSibling();
        }
    }

    private final TextRange fixRange(TextRange range) {
        int start2 = range.getStartOffset();
        int end2 = range.getEndOffset();
        int n = this.changes.size();
        if (n > 0) {
            int n2 = this.changes.get((int)0).from;
            boolean bl = false;
            start2 = Math.min(start2, n2);
            n2 = this.changes.get((int)(n - 1)).till;
            bl = false;
            end2 = Math.max(end2, n2);
        }
        return new TextRange(start2, end2);
    }

    private final int calculateDelta() {
        int delta = 0;
        for (Change change : this.changes) {
            delta += change.delta();
        }
        return delta;
    }

    public SqlPreFormatter(@NotNull Project project, @NotNull Document document, @NotNull PsiElement element2, @NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings, boolean allowResolving) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.project = project;
        this.document = document;
        this.element = element2;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"PsiDocumentManager.getInstance(project)");
        this.documentManager = psiDocumentManager;
        this.changes = new ArrayList();
        this.readOnlyFragments = this.document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.project).getNonEditableFragments((DocumentWindow)this.document) : null;
        this.queryPreFormatter = new SqlQueryPreFormatter(settings, (Collection<Change>)this.changes);
        this.casePreFormatter = new SqlCasePreFormatter(dbms, settings, this.document, allowResolving, this.readOnlyFragments, (Collection<Change>)this.changes);
    }
}

