/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlElsifSectionBlock;
import com.intellij.sql.formatter.model.SqlForkBlock;
import com.intellij.sql.formatter.model.SqlForkSectionBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0004\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/SqlForkElementBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "forkBlock", "Lcom/intellij/sql/formatter/model/SqlForkBlock;", "getForkBlock", "()Lcom/intellij/sql/formatter/model/SqlForkBlock;", "configureFormattingAttributes", "", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "overrideShape", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "overrideShape$intellij_database_sql_core_impl", "userRequiresExpand", "", "Lcom/intellij/sql/formatter/model/SqlForkSectionBlock;", "intellij.database.sql.core.impl"})
public abstract class SqlForkElementBlock
extends SqlNodeBlock {
    @Nullable
    public abstract SqlForkBlock getForkBlock();

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node;
        return aSTNode instanceof SqlExpression ? BlockRole.BODY : (aSTNode instanceof SqlStatement ? BlockRole.ELEMENT : super.determineRole(node));
    }

    @Override
    public boolean userRequiresExpand() {
        return !this.getContext().getSql().IMP_IF_THEN_COLLAPSE;
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        SqlForkBlock sqlForkBlock = this.getForkBlock();
        Wrap w = sqlForkBlock != null ? sqlForkBlock.getForkWrap$intellij_database_sql_core_impl() : null;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            SqlBlock sqlBlock = b2;
            if (sqlBlock instanceof SqlElsifSectionBlock) {
                boolean toIndent = s2.IMP_IF_THEN_INDENT_THEN_ELSE;
                b2.setMyWrap(w);
                b2.setMyIndent(toIndent ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (sqlBlock instanceof SqlForkSectionBlock) {
                boolean toWrap = ((SqlForkSectionBlock)b2).isElse$intellij_database_sql_core_impl() ? s2.IMP_IF_THEN_WRAP_ELSE : s2.IMP_IF_THEN_WRAP_THEN;
                boolean toIndent = s2.IMP_IF_THEN_INDENT_THEN_ELSE;
                b2.setMyWrap((Wrap)(toWrap ? w : null));
                b2.setMyIndent(toIndent ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (sqlBlock instanceof SqlCodeFlowBlock || sqlBlock instanceof SqlStatementBlock) {
                b2.setMyWrap((Wrap)(s2.IMP_IF_THEN_WRAP_INNER ? w : null));
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (!(sqlBlock instanceof SqlKeyword) || ((SqlKeyword)b2).getElementType() != SqlCommonKeywords.SQL_END) continue;
            b2.setMyWrap(w);
            b2.setMyIndent(s2.IMP_IF_THEN_INDENT_END ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
        }
    }

    public final void overrideShape$intellij_database_sql_core_impl(@NotNull BlockShape shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (!(b2 instanceof SqlForkElementBlock)) continue;
            b2.setShape(shape);
            ((SqlForkElementBlock)b2).overrideShape$intellij_database_sql_core_impl(shape);
        }
    }

    private SqlForkElementBlock() {
    }

    public /* synthetic */ SqlForkElementBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

