/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlAutoIncrementDuplicateInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlAutoIncrementDuplicateInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAutoIncrementDuplicateInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlAutoIncrementDuplicateInspection.$$$reportNull$$$0(2);
        }
        if (!((dbms = dialect.getDbms()).isMysql() || dbms.isTransactSql() || dbms.isDb2())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                boolean autoIncrementFound = false;
                for (SqlColumnDefinition column2 : o.getDeclaredColumns()) {
                    ASTNode genClause;
                    SqlColumnDefinition anchor2;
                    boolean generated = SqlImplUtil.isAutoVal(column2);
                    if (!generated || (anchor2 = (genClause = column2.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) == null ? column2 : genClause.getPsi()) == null) continue;
                    if (autoIncrementFound) {
                        this.addWarning((PsiElement)anchor2);
                    }
                    boolean autoInc = genClause == null || genClause.getFirstChildNode() == genClause.getLastChildNode() || genClause.findChildByType((IElementType)SqlCommonKeywords.SQL_IDENTITY) != null;
                    autoIncrementFound |= autoInc;
                }
            }

            private void addWarning(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addDescriptor(this.myManager.createProblemDescriptor(element2, SqlBundle.message("inspection.message.only.one.auto.increment.column.it.must.be.defined.as.key", new Object[0]), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection$1", "addWarning"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlAutoIncrementDuplicateInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

