/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.ComputedInsertPolicy;
import com.intellij.sql.inspections.IdentityInsertPolicy;
import com.intellij.sql.inspections.SqlInsertIntoGeneratedColumnInspection;
import com.intellij.sql.inspections.SqlInsertIntoGeneratedColumnInspection$WhenMappings;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlInspectionUtilsKt;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertOverridingClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "SurroundWithSetIdentityFix", "intellij.database.sql.impl"})
public final class SqlInsertIntoGeneratedColumnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        ComputedInsertPolicy computedPolicy = SqlInspectionUtilsKt.getComputedInsertPolicy(dbms2);
        IdentityInsertPolicy identityPolicy = SqlInspectionUtilsKt.getIdentityInsertPolicy(dbms2);
        if (computedPolicy == ComputedInsertPolicy.ALWAYS && identityPolicy == IdentityInsertPolicy.ALWAYS) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(computedPolicy, identityPolicy, onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ ComputedInsertPolicy $computedPolicy;
            final /* synthetic */ IdentityInsertPolicy $identityPolicy;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlInsertStatement(@NotNull SqlInsertStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o.getDmlInstruction();
                if (sqlInsertDmlInstruction == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlInsertDmlInstruction, (String)"o.dmlInstruction ?: return");
                SqlInsertDmlInstruction dmlInstruction = sqlInsertDmlInstruction;
                SqlTableColumnsList columnsList = dmlInstruction.getColumnsList();
                SqlTableType targetType = dmlInstruction.getTargetType();
                int n = 0;
                SqlTableType sqlTableType = targetType;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"targetType");
                int n2 = sqlTableType.getColumnCount();
                while (n < n2) {
                    PsiColumn column2;
                    PsiElement psiElement;
                    SqlReferenceExpression columnRef;
                    Object object;
                    void index2;
                    PsiElement psiElement2 = targetType.getColumnElement((int)index2);
                    if (!(psiElement2 instanceof SqlReferenceExpression)) {
                        psiElement2 = null;
                    }
                    if ((SqlReferenceExpression)psiElement2 != null) {
                        SqlReferenceExpression sqlReferenceExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        SqlReferenceExpression it2 = sqlReferenceExpression;
                        boolean bl3 = false;
                        object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)columnsList), (PsiElement)((PsiElement)it2), (boolean)true) ? sqlReferenceExpression : null;
                    } else {
                        object = columnRef = null;
                    }
                    if (!((psiElement = targetType.getSourceColumnElement((int)index2)) instanceof PsiColumn)) {
                        psiElement = null;
                    }
                    if ((PsiColumn)psiElement == null) {
                    } else if (SqlImplUtil.isComputedVal(column2)) {
                        this.checkComputed(columnRef, dmlInstruction, (int)index2);
                    } else if (SqlImplUtil.isAutoVal(column2)) {
                        this.checkIdentity(column2, columnRef, dmlInstruction, (int)index2);
                    }
                    ++index2;
                }
            }

            private final void checkComputed(SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                switch (SqlInsertIntoGeneratedColumnInspection$WhenMappings.$EnumSwitchMapping$0[this.$computedPolicy.ordinal()]) {
                    case 1: {
                        String string = SqlBundle.message("inspection.message.insertion.into.generated.column.not.supported", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026ed.column.not.supported\")");
                        this.reportOnColumnOrTableRef(string, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        String string = SqlBundle.message("inspection.message.only.default.may.be.inserted.into.generated.column", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026d.into.generated.column\")");
                        this.checkDefault(string, dmlInstruction, index2, columnRef);
                        break;
                    }
                    case 3: {
                        return;
                    }
                }
            }

            private final void checkDefault(@InspectionMessage String message2, SqlInsertDmlInstruction dmlInstruction, int index2, SqlReferenceExpression columnRef) {
                SqlValuesExpression sqlValuesExpression = dmlInstruction.getValuesExpression();
                if (sqlValuesExpression != null && (sqlValuesExpression = sqlValuesExpression.getExpressions()) != null) {
                    Iterable $this$forEach$iv = (Iterable)sqlValuesExpression;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        boolean isDefaultExpr;
                        Object object;
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl = false;
                        SqlExpression sqlExpression = it2;
                        if (!(sqlExpression instanceof SqlExpressionList)) {
                            sqlExpression = null;
                        }
                        SqlExpression columnExpr = (object = (SqlExpressionList)sqlExpression) != null && (object = object.getExpressionList()) != null ? (SqlExpression)CollectionsKt.getOrNull((List)object, (int)index2) : null;
                        boolean bl2 = isDefaultExpr = columnExpr instanceof SqlLiteralExpression && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((SqlLiteralExpression)columnExpr).getFirstChild()), (Object)SqlCommonKeywords.SQL_DEFAULT);
                        if (columnExpr == null || isDefaultExpr) continue;
                        createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnExpr, message2, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                    }
                }
                if (columnRef != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnRef, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, 8, null);
                }
            }

            private final void checkIdentity(PsiColumn column2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                String string = SqlBundle.message("inspection.message.insertion.into.identity.autoincrement.column.not.supported", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inspe\u2026nt.column.not.supported\")");
                String errorMessage = string;
                switch (SqlInsertIntoGeneratedColumnInspection$WhenMappings.$EnumSwitchMapping$1[this.$identityPolicy.ordinal()]) {
                    case 1: {
                        this.reportOnColumnOrTableRef(errorMessage, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        if (columnRef == null || this.hasSetIdentityInsert(dmlInstruction)) {
                            return;
                        }
                        this.reportIssue((SqlElement)columnRef, errorMessage, ProblemHighlightType.GENERIC_ERROR, SurroundWithSetIdentityFix.INSTANCE);
                        break;
                    }
                    case 3: {
                        if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dmlInstruction), SqlInsertOverridingClause.class) != null) {
                            return;
                        }
                        if (!this.isForcedAutoVal(column2)) {
                            return;
                        }
                        String string2 = SqlBundle.message("inspection.message.only.default.may.be.inserted.into.identity.autoincrement.column", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SqlBundle.message(\"inspe\u2026ty.autoincrement.column\")");
                        this.checkDefault(string2, dmlInstruction, index2, columnRef);
                        break;
                    }
                    case 4: {
                        return;
                    }
                }
            }

            private final boolean isForcedAutoVal(PsiColumn $this$isForcedAutoVal) {
                boolean bl;
                block7: {
                    Object v1;
                    PsiElement it2;
                    block6: {
                        if (!($this$isForcedAutoVal instanceof SqlColumnDefinition)) {
                            return false;
                        }
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren($this$isForcedAutoVal);
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil\n          .sqlChildren(this)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    PsiElement psiElement = v1;
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement identityClause = psiElement;
                    JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren(identityClause);
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(identityClause)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it2 = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_ALWAYS)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean hasSetIdentityInsert(SqlInsertDmlInstruction dmlInstruction) {
                for (PsiElement currentContext = dmlInstruction.getParent(); currentContext != null && !(currentContext instanceof SqlBatchBlock) && !(currentContext instanceof SqlFile); currentContext = currentContext.getParent()) {
                    Object v2;
                    block2: {
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.revSiblings(currentContext);
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.revSiblings(currentContext)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            PsiElement psiElement = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                            if (!this.isSetIdentityInsert(psiElement, dmlInstruction)) continue;
                            v2 = element$iv;
                            break block2;
                        }
                        v2 = null;
                    }
                    PsiElement setClause = v2;
                    if (setClause == null) continue;
                    return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)setClause.getLastChild()), (Object)SqlCommonKeywords.SQL_ON);
                }
                return false;
            }

            private final boolean isSetIdentityInsert(PsiElement element2, SqlInsertDmlInstruction dmlInstruction) {
                if (!(element2 instanceof SqlSetStatement)) {
                    return false;
                }
                PsiElement psiElement = ((SqlSetStatement)element2).getFirstChild();
                if (psiElement == null) {
                    return false;
                }
                PsiElement anchor2 = psiElement;
                PsiElement psiElement2 = PsiTreeUtil.findSiblingForward((PsiElement)anchor2, (IElementType)((IElementType)SqlCommonKeywords.SQL_IDENTITY_INSERT), (boolean)true, null);
                if (psiElement2 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.findSiblingF\u2026          ?: return false");
                PsiElement identityInsert = psiElement2;
                PsiElement psiElement3 = PsiTreeUtil.findSiblingForward((PsiElement)identityInsert, (IElementType)((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE), (boolean)true, null);
                if (!(psiElement3 instanceof SqlReferenceExpression)) {
                    psiElement3 = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement3;
                if (sqlReferenceExpression == null) {
                    return false;
                }
                SqlReferenceExpression tableRef = sqlReferenceExpression;
                SqlExpression sqlExpression = dmlInstruction.getTargetExpression();
                if (!(sqlExpression instanceof SqlReferenceExpression)) {
                    sqlExpression = null;
                }
                SqlReferenceExpression sqlReferenceExpression2 = (SqlReferenceExpression)sqlExpression;
                if (sqlReferenceExpression2 == null) {
                    return false;
                }
                SqlReferenceExpression insertTableRef = sqlReferenceExpression2;
                PsiElement psiElement4 = tableRef.resolve();
                if (psiElement4 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"tableRef.resolve() ?: return false");
                PsiElement affectedTable = psiElement4;
                PsiElement psiElement5 = insertTableRef.resolve();
                if (psiElement5 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"insertTableRef.resolve() ?: return false");
                PsiElement insertTable = psiElement5;
                return Intrinsics.areEqual((Object)affectedTable, (Object)insertTable);
            }

            private final void reportOnColumnOrTableRef(@InspectionMessage String message2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction) {
                SqlExpression anchor2;
                SqlReferenceExpression sqlReferenceExpression = columnRef;
                SqlExpression sqlExpression = anchor2 = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : dmlInstruction.getTargetExpression();
                if (anchor2 != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)anchor2, message2, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                }
            }

            private final void reportIssue(SqlElement element2, @InspectionMessage String message2, ProblemHighlightType level, LocalQuickFix fix) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element2, message2, fix, level, this.$onTheFly));
            }

            static /* synthetic */ void reportIssue$default(createAnnotationVisitor.1 var0, SqlElement sqlElement, String string, ProblemHighlightType problemHighlightType, LocalQuickFix localQuickFix, int n, Object object) {
                if ((n & 8) != 0) {
                    localQuickFix = null;
                }
                var0.reportIssue(sqlElement, string, problemHighlightType, localQuickFix);
            }
            {
                this.$computedPolicy = $captured_local_variable$0;
                this.$identityPolicy = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$dialect = $captured_local_variable$4;
                this.$result = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection$SurroundWithSetIdentityFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    public static final class SurroundWithSetIdentityFix
    implements LocalQuickFix {
        @NotNull
        public static final SurroundWithSetIdentityFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.surround.with.set.identity.insert", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ith.set.identity.insert\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), SqlInsertStatement.class);
            if (sqlInsertStatement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlInsertStatement, (String)"PsiTreeUtil.getParentOfT\u2026nt::class.java) ?: return");
            SqlInsertStatement insertStatement = sqlInsertStatement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getTargetExpression()) == null) {
                return;
            }
            SqlInsertDmlInstruction targetExpression = sqlInsertDmlInstruction;
            PsiElement psiElement = insertStatement.getParent();
            if (psiElement == null) {
                return;
            }
            PsiElement parent2 = psiElement;
            PsiFile file = parent2.getContainingFile();
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)insertStatement));
            if (!(psiElement2 instanceof LeafPsiElement)) {
                psiElement2 = null;
            }
            LeafPsiElement leafPsiElement = (LeafPsiElement)psiElement2;
            if (leafPsiElement != null) {
                LeafPsiElement leafPsiElement2 = leafPsiElement;
                boolean bl = false;
                boolean bl2 = false;
                LeafPsiElement it2 = leafPsiElement2;
                boolean bl3 = false;
                object = Intrinsics.areEqual((Object)it2.getText(), (Object)DbSqlUtil.getDelimiterAt(file, insertStatement.getTextOffset())) ? leafPsiElement2 : null;
            } else {
                object = null;
            }
            LeafPsiElement delimiter = object;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
            DdlBuilder ddlBuilder = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" ON");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.keyword(\"SET IDE\u2026sion.text).keyword(\" ON\")");
            String string = ddlBuilder.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.keyword(\"SET IDE\u2026.keyword(\" ON\").statement");
            String setOnText = string;
            builder.clear();
            DdlBuilder ddlBuilder2 = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" OFF");
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"builder.keyword(\"SET IDE\u2026ion.text).keyword(\" OFF\")");
            String string2 = ddlBuilder2.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.keyword(\"SET IDE\u2026keyword(\" OFF\").statement");
            String setOffText = string2;
            SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText(setOnText, dialect, project, null);
            Intrinsics.checkNotNull((Object)sqlStatement);
            SqlStatement sqlStatement2 = sqlStatement;
            boolean bl = false;
            boolean bl4 = false;
            SqlStatement it3 = sqlStatement2;
            boolean bl5 = false;
            PsiElement setOnStatement = parent2.addBefore((PsiElement)it3, (PsiElement)insertStatement);
            SqlStatement sqlStatement3 = SqlPsiElementFactory.createStatementFromText(setOffText, dialect, project, null);
            Intrinsics.checkNotNull((Object)sqlStatement3);
            SqlStatement sqlStatement4 = sqlStatement3;
            bl4 = false;
            boolean bl6 = false;
            SqlStatement it4 = sqlStatement4;
            boolean bl7 = false;
            PsiElement psiElement3 = (PsiElement)it4;
            LeafPsiElement leafPsiElement3 = delimiter;
            if (leafPsiElement3 == null) {
                leafPsiElement3 = insertStatement;
            }
            PsiElement setOffStatement = parent2.addAfter(psiElement3, (PsiElement)leafPsiElement3);
            if (delimiter != null) {
                parent2.addAfter((PsiElement)delimiter, setOnStatement);
                parent2.addAfter((PsiElement)delimiter, setOffStatement);
            }
        }

        private SurroundWithSetIdentityFix() {
        }

        static {
            SurroundWithSetIdentityFix surroundWithSetIdentityFix;
            INSTANCE = surroundWithSetIdentityFix = new SurroundWithSetIdentityFix();
        }
    }
}

