/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"createGroupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "expressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "addGroupBy", "Lcom/intellij/sql/psi/SqlQueryExpression;", "groupByClause", "getElementForGroupBy", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.sql.impl"})
public final class IntentionUtilsKt {
    @Nullable
    public static final SqlGroupByClause addGroupBy(@NotNull SqlQueryExpression $this$addGroupBy, @NotNull SqlGroupByClause groupByClause) {
        PsiElement psiElement;
        PsiElement anchor2;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)$this$addGroupBy, (String)"$this$addGroupBy");
        Intrinsics.checkNotNullParameter((Object)groupByClause, (String)"groupByClause");
        SqlTableExpression sqlTableExpression = $this$addGroupBy.getTableExpression();
        if (sqlTableExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"tableExpression ?: return null");
        SqlTableExpression tableExpression = sqlTableExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)$this$addGroupBy);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(this)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra()) {
            psiElement2 = null;
        } else if (dbms2.isClickHouse()) {
            Object v6;
            block12: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(tableExpression)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it2 instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first2 = ((SqlClause)it2).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first2);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first2), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v6 = element$iv;
                    break block12;
                }
                v6 = null;
            }
            if ((psiElement2 = (PsiElement)v6) == null) {
                psiElement2 = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement2 = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement2 = anchor2 = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        if (!((psiElement = tableExpression.addBefore((PsiElement)groupByClause, anchor2)) instanceof SqlGroupByClause)) {
            psiElement = null;
        }
        return (SqlGroupByClause)psiElement;
    }

    @Nullable
    public static final SqlGroupByClause createGroupByClause(@NotNull List<? extends SqlExpression> expressions2, @NotNull SqlLanguageDialect dialect, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SqlPsiElementFactory.createGroupByClause(CollectionsKt.joinToString$default((Iterable)expressions2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SqlExpression, CharSequence>(dialect){
            final /* synthetic */ SqlLanguageDialect $dialect;

            @NotNull
            public final CharSequence invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
                Object object = IntentionUtilsKt.access$getElementForGroupBy(it2, dbms);
                return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
            }
            {
                this.$dialect = sqlLanguageDialect;
                super(1);
            }
        }), (int)31, null), dialect, project);
    }

    private static final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    public static final /* synthetic */ PsiElement access$getElementForGroupBy(SqlExpression $this$access_u24getElementForGroupBy, Dbms dbms) {
        return IntentionUtilsKt.getElementForGroupBy($this$access_u24getElementForGroupBy, dbms);
    }
}

