/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPivotedQueryExpressionImpl
extends SqlExpressionImpl
implements SqlExpression {
    public SqlPivotedQueryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlClause columnsClause = this.getColumnsClause();
        SqlClause forClause = (SqlClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)columnsClause, SqlClause.class);
        SqlClause inClause = this.getInClause();
        if (forClause == null || inClause == null) {
            return this.getPivotedExpressionType();
        }
        SqlTableType pivotedType = this.getPivotedType(columnsClause, forClause, inClause);
        SqlTableType restType = this.getRestType(columnsClause, forClause, inClause).alias(null, (PsiElement)this, Collections.emptyList());
        SqlTableType sqlTableType = restType.add(pivotedType);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        List columns;
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(4);
        }
        return (columns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlPivotColumnDefinition.class)).isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new TableBasedSqlTableTypeImpl(columns, (PsiElement)this);
    }

    @NotNull
    protected SqlTableType getRestType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(5);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(6);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(7);
        }
        SqlTableType sqlTableType = this.getRestTypeImpl(columnsClause, forClause);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(8);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getRestTypeImpl(SqlClause ... clauses) {
        SqlTableType pivotedType = this.getPivotedExpressionType();
        if (pivotedType == SqlTableTypeBase.EMPTY_TABLE) {
            SqlTableType sqlTableType = pivotedType;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(9);
            }
            return sqlTableType;
        }
        LinkedHashSet toSubtract = new LinkedHashSet();
        for (SqlReferenceExpression ref : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)JBIterable.of((Object[])clauses))).filter(SqlReferenceExpression.class)) {
            if (SqlImplUtil.isAsteriskRef((PsiElement)ref) || ref.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) continue;
            for (ResolveResult result2 : ref.multiResolve(false)) {
                ContainerUtil.addIfNotNull(toSubtract, (Object)result2.getElement());
            }
        }
        for (PsiElement element2 : toSubtract) {
            pivotedType = pivotedType.subtract(element2);
        }
        SqlTableType sqlTableType = pivotedType;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(10);
        }
        return sqlTableType;
    }

    @NotNull
    private SqlTableType getPivotedExpressionType() {
        SqlExpression expression = this.getPivotedExpression();
        if (expression == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(11);
            }
            return sqlTableType;
        }
        SqlType pivotedType = expression.getSqlType();
        SqlTableType sqlTableType = pivotedType instanceof SqlTableType ? (SqlTableType)pivotedType : SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(12);
        }
        return sqlTableType;
    }

    @Nullable
    protected SqlClause getColumnsClause() {
        return (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlClause.class);
    }

    @Nullable
    protected SqlClause getInClause() {
        PsiElement child = this.getLastChild();
        if (child == null || child instanceof SqlClause) {
            return (SqlClause)child;
        }
        return (SqlClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)child, SqlClause.class);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(15);
        }
        SqlExpression expression = this.getPivotedExpression();
        if ((lastParent == null || lastParent.getContext() == this && !PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)place, (boolean)false)) && expression != null && !SqlImplUtil.processDeclarationsInType(expression, processor, state, place)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    private SqlExpression getPivotedExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsClause";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inClause";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestTypeImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPivotedExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPivotedType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRestType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ByValues
    extends SqlPivotedQueryExpressionImpl {
        public ByValues(@NotNull IElementType elementType) {
            if (elementType == null) {
                ByValues.$$$reportNull$$$0(0);
            }
            super(elementType);
        }

        @Override
        @NotNull
        protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
            if (columnsClause == null) {
                ByValues.$$$reportNull$$$0(1);
            }
            if (forClause == null) {
                ByValues.$$$reportNull$$$0(2);
            }
            if (inClause == null) {
                ByValues.$$$reportNull$$$0(3);
            }
            SqlTableType sqlTableType = (SqlTableType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcPivotedType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (sqlTableType == null) {
                ByValues.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }

        @NotNull
        private SqlTableType calcPivotedType() {
            SqlClause columnsClause = this.getColumnsClause();
            SqlClause inClause = this.getInClause();
            List values2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)columnsClause, SqlExpression.class);
            List columns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlExpression.class);
            if (values2.isEmpty() || columns.isEmpty()) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                if (sqlTableType == null) {
                    ByValues.$$$reportNull$$$0(5);
                }
                return sqlTableType;
            }
            ArrayList<MyFakeDefinition> result2 = new ArrayList<MyFakeDefinition>(values2.size() * columns.size());
            for (SqlExpression column2 : columns) {
                for (SqlExpression value2 : values2) {
                    result2.add(MyFakeDefinition.create((PsiElement)this, value2, column2));
                }
            }
            return new TableBasedSqlTableTypeImpl(result2, (PsiElement)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsClause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forClause";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inClause";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPivotedType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcPivotedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPivotedType";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyFakeDefinition
        extends SqlFileImpl.FakeDefinition
        implements SqlTypedDefinition {
            private final boolean myQuoted;
            private final SqlExpression myValue;
            private final SqlExpression myColumn;

            MyFakeDefinition(@NotNull PsiElement parent2, @Nullable String name, boolean quoted, @NotNull SqlExpression value2, @NotNull SqlExpression column2) {
                if (parent2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(1);
                }
                if (column2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(2);
                }
                super(parent2, StringUtil.notNullize((String)name));
                this.myQuoted = quoted;
                this.myValue = value2;
                this.myColumn = column2;
            }

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = SqlImplUtil.getSqlDialectDbms(this.getParent());
                if (dbms == null) {
                    MyFakeDefinition.$$$reportNull$$$0(3);
                }
                return dbms;
            }

            public boolean isNameQuoted() {
                return this.myQuoted;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    MyFakeDefinition.$$$reportNull$$$0(4);
                }
                return objectKind;
            }

            @NotNull
            public PsiElement getNavigationElement() {
                SqlExpression sqlExpression = this.myColumn;
                if (sqlExpression == null) {
                    MyFakeDefinition.$$$reportNull$$$0(5);
                }
                return sqlExpression;
            }

            @NotNull
            public SqlType getSqlType() {
                SqlType sqlType = this.myValue.getSqlType();
                if (sqlType == null) {
                    MyFakeDefinition.$$$reportNull$$$0(6);
                }
                return sqlType;
            }

            @NotNull
            public DataType getDataType() {
                DataType dataType = this.getSqlType().getDataType();
                if (dataType == null) {
                    MyFakeDefinition.$$$reportNull$$$0(7);
                }
                return dataType;
            }

            @NotNull
            public DasType getDasType() {
                DasType dasType = DasType.UNKNOWN;
                if (dasType == null) {
                    MyFakeDefinition.$$$reportNull$$$0(8);
                }
                return dasType;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            public static MyFakeDefinition create(@NotNull PsiElement parent2, @NotNull SqlExpression value2, @NotNull SqlExpression column2) {
                String vName;
                if (parent2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(9);
                }
                if (value2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(10);
                }
                if (column2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(11);
                }
                boolean columnQuoted = DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)column2, DasObject.class));
                boolean valueQuoted = DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)value2, DasObject.class));
                String cName = column2.getName();
                String string = vName = value2 instanceof DasObject ? value2.getName() : null;
                if (valueQuoted != columnQuoted) {
                    SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(parent2);
                    Casing casing = language.getCasing(ObjectKind.COLUMN, null);
                    if (casing.quoted == Case.EXACT) {
                        if (!columnQuoted) {
                            cName = casing.plain.apply(cName);
                        }
                        if (!valueQuoted) {
                            vName = casing.plain.apply(vName);
                        }
                    }
                }
                String name = cName == null || vName == null ? cName : cName + "_" + vName;
                return new MyFakeDefinition(parent2, name, columnQuoted || valueQuoted, value2, column2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues$MyFakeDefinition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues$MyFakeDefinition";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNavigationElement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSqlType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class SqlPivotColumnDefinition
    extends SqlDefinitionImpl
    implements SqlTypedDefinition {
        public SqlPivotColumnDefinition(@NotNull IElementType elementType) {
            if (elementType == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(0);
            }
            super(elementType);
        }

        @NotNull
        public SqlType getSqlType() {
            SqlClause columnsClause;
            PsiElement parent2 = this.getParent();
            SqlPivotedQueryExpressionImpl grandParent = parent2 == null ? null : (SqlPivotedQueryExpressionImpl)((Object)ObjectUtils.tryCast((Object)parent2.getParent(), SqlPivotedQueryExpressionImpl.class));
            SqlClause sqlClause = columnsClause = grandParent == null ? null : grandParent.getColumnsClause();
            if (columnsClause == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlPivotColumnDefinition.$$$reportNull$$$0(1);
                }
                return sqlPrimitiveType;
            }
            if (grandParent.getNode().getElementType() == SqlCompositeElementTypes.SQL_UNPIVOTED_QUERY_EXPRESSION) {
                SqlClause inClause = grandParent.getInClause();
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)inClause, SqlReferenceExpression.class);
                if (ref == null) {
                    SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                    if (sqlPrimitiveType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(2);
                    }
                    return sqlPrimitiveType;
                }
                if (parent2 == columnsClause) {
                    SqlType sqlType = ref.getSqlType();
                    if (sqlType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(3);
                    }
                    return sqlType;
                }
                SqlExpression expr = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref, SqlExpression.class);
                if (expr == null || expr instanceof SqlReferenceExpression) {
                    SqlType sqlType = SqlTypeFactory.defaultType(SqlType.Category.STRING, SqlImplUtil.getSqlDialectSafe((PsiElement)this));
                    if (sqlType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(4);
                    }
                    return sqlType;
                }
                SqlType sqlType = expr.getSqlType();
                if (sqlType == null) {
                    SqlPivotColumnDefinition.$$$reportNull$$$0(5);
                }
                return sqlType;
            }
            SqlExpression ref = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)columnsClause, SqlExpression.class);
            Object object = ref == null ? SqlType.UNKNOWN : ref.getSqlType();
            if (object == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(6);
            }
            return object;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(7);
            }
            return dataType;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = DasType.UNKNOWN;
            if (dasType == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(8);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$SqlPivotColumnDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$SqlPivotColumnDefinition";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

