/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ultimate;

import com.intellij.ide.license.CommercialBundle;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.ReflectionUtil;
import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class PluginVerifier {
    private static final BigInteger PUBLIC_MOD = new BigInteger("ba3da866372947f737c0120610ae281f1085659726cbd2b1288ac7a2b95acef7392d4c848d4cab7767c2c972bdf4e4f73482ef23fb31bf6dda4cbcbf82924d97", 16);
    private static final BigInteger PUBLIC_EXP = new BigInteger("10001", 16);
    private static final AtomicBoolean ourDialogShowingFlag = new AtomicBoolean(false);

    private PluginVerifier() {
    }

    public static void verifyUltimatePlugin() {
        PluginVerifier.verifyUltimatePlugin(UltimateVerifier.getInstance());
    }

    public static boolean isUltimate() {
        try {
            UltimateVerifier verifier = UltimateVerifier.getInstance();
            if (verifier != null) {
                BigInteger seed = new BigInteger(128, new Random(System.nanoTime()));
                return seed.equals(verifier.checkResult(verifier.verify(seed), PUBLIC_EXP, PUBLIC_MOD));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void verifyUltimatePlugin(@NotNull UltimateVerifier verifier) {
        Application app;
        if (verifier == null) {
            PluginVerifier.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()) != null && app.isUnitTestMode()) {
            return;
        }
        BigInteger seed = new BigInteger(128, new Random(System.nanoTime()));
        String result2 = verifier.verify(seed);
        try {
            BigInteger decoded = verifier.checkResult(result2, PUBLIC_EXP, PUBLIC_MOD);
            if (!decoded.equals(seed)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            ClassLoader loader = ReflectionUtil.findCallerClass((int)1).getClassLoader();
            PluginId pluginId = null;
            if (loader instanceof PluginAwareClassLoader) {
                pluginId = ((PluginAwareClassLoader)loader).getPluginId();
            }
            String pluginName = pluginId != null ? pluginId.getIdString() : null;
            String incompatibilityMessage = CommercialBundle.message((String)"a.plugin.has.been.detected", (Object[])new Object[]{pluginName, pluginName != null ? 0 : 1});
            if (app != null && app.isHeadlessEnvironment()) {
                System.err.println(incompatibilityMessage);
                System.exit(1);
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (!ourDialogShowingFlag.getAndSet(true)) {
                    JOptionPane.showMessageDialog(null, incompatibilityMessage);
                    System.exit(0);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verifier", "com/intellij/ultimate/PluginVerifier", "verifyUltimatePlugin"));
    }
}

