/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;

public final class CreateRunConfigurationUtil {
    private static final String DEBUG_APPLICATION = "Debug Application";
    private static final String LOCALHOST = "http://localhost:";
    private static final String RUN_SCRIPT = "run-script";
    private static final String URI = "uri";
    private static final String JSDEBUG = "jsdebug";
    private static final String NPM = "npm";

    public static void npmConfiguration(Project project, String scriptName) {
        RunManager runManager = RunManager.getInstance((Project)project);
        VirtualFile pkg = PackageJsonUtil.findChildPackageJsonFile(project.getBaseDir());
        if (pkg != null) {
            RunnerAndConfigurationSettings startConfiguration = new NpmRunConfigurationBuilder(project).createRunConfiguration("npm " + scriptName, null, pkg.getPath(), ContainerUtil.newHashMap((Pair)new Pair((Object)RUN_SCRIPT, (Object)scriptName), (Pair[])new Pair[0]));
            runManager.setSelectedConfiguration(startConfiguration);
        }
    }

    public static void debugConfiguration(Project project, int port) {
        RunManager runManager = RunManager.getInstance((Project)project);
        ObjectUtils.doIfNotNull((Object)JSRunConfigurationBuilder.getForName(JSDEBUG, project), builder -> (RunnerAndConfigurationSettings)ObjectUtils.notNull(null, () -> {
            RunnerAndConfigurationSettings settings = builder.createRunConfiguration(DEBUG_APPLICATION, project.getBaseDir(), null, ContainerUtil.newHashMap((Pair)new Pair((Object)URI, (Object)(LOCALHOST + port)), (Pair[])new Pair[0]));
            runManager.setSelectedConfiguration(settings);
            return settings;
        }));
    }
}

