/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.javascript.microservices.AngularUrlPathReferenceContributor;
import com.intellij.javascript.microservices.JSUrlPathReferenceContributorKt;
import com.intellij.javascript.microservices.JSUrlPathReferenceProvider;
import com.intellij.lang.javascript.patterns.JSCallExpressionPattern;
import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.patterns.JSReferenceExpressionPattern;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/microservices/AngularUrlPathReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "httpServiceMethods", "", "", "[Ljava/lang/String;", "injector", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "Lcom/intellij/lang/javascript/psi/JSExpression;", "angularHttpClient", "Lcom/intellij/lang/javascript/patterns/JSCallExpressionPattern;", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "intellij.javascript.langInjection"})
public final class AngularUrlPathReferenceContributor
extends PsiReferenceContributor {
    private final String[] httpServiceMethods = new String[]{"get", "post", "put", "delete", "head", "jsonp", "patch"};
    private final UrlPathReferenceInjector<JSExpression> injector = UrlPathReferenceInjector.Companion.forPartialStringFrom(JSUrlPathReferenceContributorKt.getJsPksParser(), (Function1)injector.1.INSTANCE).withDefaultRootContextProviderFactory((Function1)injector.2.INSTANCE);

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        JSUrlPathReferenceProvider jsUrlPathReferenceProvider = new JSUrlPathReferenceProvider(this.injector);
        registrar.registerReferenceProvider((ElementPattern)((JSElementPattern.Capture)JSPatterns.jsLiteralExpression().inside((ElementPattern)JSPatterns.jsArgument((JSReferenceExpressionPattern)JSPatterns.jsReferenceExpression().andOr(new ElementPattern[]{(ElementPattern)JSPatterns.jsReferenceExpression().withNameStartingWith("$http").withReferenceNames(Arrays.copyOf(this.httpServiceMethods, this.httpServiceMethods.length))}), 0))).save(JSUrlPathReferenceProvider.Companion.getFULL_URL_EXPRESSION()), (PsiReferenceProvider)jsUrlPathReferenceProvider);
        JSElementPattern.Capture<JSLiteralExpression> capture = JSPatterns.jsLiteralExpression();
        ElementPattern[] elementPatternArray = new ElementPattern[2];
        JSReferenceExpressionPattern jSReferenceExpressionPattern = JSPatterns.jsReferenceExpression();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)"options");
        spreadBuilder.addSpread((Object)this.httpServiceMethods);
        elementPatternArray[0] = (ElementPattern)JSPatterns.jsArgument(jSReferenceExpressionPattern.withReferenceNames((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), 0).inside((ElementPattern)this.angularHttpClient());
        elementPatternArray[1] = (ElementPattern)JSPatterns.jsArgument(JSPatterns.jsReferenceExpression().withReferenceNames("request"), 1).inside((ElementPattern)this.angularHttpClient());
        registrar.registerReferenceProvider((ElementPattern)((JSElementPattern.Capture)capture.inside(JSPatterns.or((ElementPattern[])elementPatternArray))).save(JSUrlPathReferenceProvider.Companion.getFULL_URL_EXPRESSION()), (PsiReferenceProvider)jsUrlPathReferenceProvider);
    }

    private final JSCallExpressionPattern angularHttpClient() {
        ObjectPattern objectPattern = JSPatterns.jsCallExpression().with((PatternCondition)new PatternCondition<JSCallExpression>("JSCallExpression.contextualHttpResolve"){

            public boolean accepts(@NotNull JSCallExpression t, @NotNull ProcessingContext context) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PsiElement psiElement = t.getFirstChild();
                if (!(psiElement instanceof JSReferenceExpression)) {
                    psiElement = null;
                }
                JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)psiElement;
                if (jSReferenceExpression == null) {
                    return false;
                }
                JSReferenceExpression referenceExpression = jSReferenceExpression;
                JSReferenceExpression jSReferenceExpression2 = referenceExpression;
                if (!(jSReferenceExpression2 instanceof JSReferenceExpressionImpl)) {
                    jSReferenceExpression2 = null;
                }
                JSReferenceExpressionImpl jSReferenceExpressionImpl = (JSReferenceExpressionImpl)jSReferenceExpression2;
                JSExpression jSExpression = jSReferenceExpressionImpl != null ? jSReferenceExpressionImpl.getResolveQualifier() : null;
                if (!(jSExpression instanceof JSPsiReferenceElement)) {
                    jSExpression = null;
                }
                JSPsiReferenceElement jSPsiReferenceElement = (JSPsiReferenceElement)((Object)jSExpression);
                if (jSPsiReferenceElement == null) {
                    return false;
                }
                JSPsiReferenceElement qualifier = jSPsiReferenceElement;
                String string = qualifier.getReferenceName();
                if (string == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"qualifier.referenceName ?: return false");
                String referenceName = string;
                PsiElement resolveResult = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, (PsiElement)referenceExpression);
                PsiElement psiElement2 = resolveResult;
                if (!(psiElement2 instanceof JSTypeOwner)) {
                    psiElement2 = null;
                }
                return Intrinsics.areEqual((Object)((object = (JSTypeOwner)psiElement2) != null && (object = object.getJSType()) != null ? object.getTypeText() : null), (Object)"HttpClient");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"jsCallExpression().with(\u2026ttpClient\"\n      }\n    })");
        return (JSCallExpressionPattern)objectPattern;
    }
}

