/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocUtil;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDocumentationProvider
implements DocumentationProvider {
    private static final PsiElementPattern.Capture<ES6FromClause> ES6_FROM_CLAUSE = (PsiElementPattern.Capture)PlatformPatterns.psiElement(ES6FromClause.class).withParent(ES6ImportDeclaration.class);

    @Nullable
    public String getQuickNavigateInfo(PsiElement resolvedElement, PsiElement contextElement) {
        if (resolvedElement == null) {
            return null;
        }
        String referenceText = NodeDocumentationProvider.getReferenceText(contextElement);
        if (!NodeDocumentationProvider.accept(referenceText)) {
            return null;
        }
        if (NodeCoreLibraryManager.isCoreModuleName(referenceText)) {
            return NodeDocumentationProvider.getCoreModuleDocumentation(contextElement.getProject(), referenceText);
        }
        VirtualFile packageDir2 = NodeDocumentationProvider.findPackageDir(resolvedElement, referenceText);
        if (packageDir2 != null) {
            NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir2, false);
            return documentation != null ? documentation.getQuickInfoHtml() : null;
        }
        return null;
    }

    @Nullable
    public String generateDoc(@Nullable PsiElement resolvedElement, @Nullable PsiElement contextElement) {
        if (resolvedElement == null) {
            return null;
        }
        String referenceText = NodeDocumentationProvider.getReferenceText(contextElement);
        if (!NodeDocumentationProvider.accept(referenceText)) {
            return null;
        }
        if (NodeCoreLibraryManager.isCoreModuleName(referenceText)) {
            return null;
        }
        VirtualFile packageDir2 = NodeDocumentationProvider.findPackageDir(resolvedElement, referenceText);
        if (packageDir2 != null) {
            NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir2, true);
            return documentation != null ? documentation.getFullDocHtml() : null;
        }
        return null;
    }

    @Nullable
    private static String getCoreModuleDocumentation(@NotNull Project project, @NotNull String coreModuleName) {
        if (project == null) {
            NodeDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (coreModuleName == null) {
            NodeDocumentationProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getReferenceText(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSLiteralExpression) {
            element = parent;
        }
        if (parent instanceof ES6FromClause) {
            element = parent;
        }
        String text = null;
        if (JavaScriptReferenceContributor.Holder.REQUIRE_ARG_PLACE.accepts((Object)element)) {
            text = element.getText();
        } else if (ES6_FROM_CLAUSE.accepts((Object)element)) {
            text = ((ES6FromClause)element).getReferenceText();
        }
        return text != null ? StringUtil.unquoteString((String)text) : null;
    }

    @Contract(value="null -> false")
    private static boolean accept(@Nullable String referenceText) {
        if (StringUtil.isEmpty((String)referenceText)) {
            return false;
        }
        return !StringUtil.containsChar((String)referenceText, (char)'/') || NodeModuleSearchUtil.isScopedPackageName(referenceText);
    }

    @Nullable
    private static VirtualFile findPackageDir(@NotNull PsiElement resolvedElement, @NotNull String packageName) {
        VirtualFile file2;
        if (resolvedElement == null) {
            NodeDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            NodeDocumentationProvider.$$$reportNull$$$0(3);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)resolvedElement)) != null) {
            PackageJsonData data;
            VirtualFile packageJson;
            if (file2.isDirectory()) {
                VirtualFile child;
                int ind;
                String scope = NodeModuleSearchUtil.getScopeByPackageName(packageName);
                if (file2.getName().equals(scope) && (ind = packageName.indexOf(47)) > 0 && (child = file2.findChild(packageName.substring(ind + 1))) != null && child.isDirectory()) {
                    file2 = child;
                }
            }
            if ((packageJson = PackageJsonUtil.findUpPackageJson(file2)) != null && packageName.equals((data = PackageJsonData.getOrCreate(packageJson)).getName())) {
                return packageJson.getParent();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModuleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCoreModuleDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

