/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.CommonBundle;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ModalityUiUtil;
import org.jetbrains.annotations.NotNull;

public class NodeJsInterpreterManagerStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterManagerStartupActivity.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Node.js interpreter", NotificationDisplayType.BALLOON, true, null);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(0);
        }
        ModalityUiUtil.invokeLaterIfNeeded(() -> {
            if (project.isDefault()) {
                return;
            }
            NodeJsInterpreterManager interpreterManager = NodeJsInterpreterManager.getInstance(project);
            NodeJsInterpreterRef interpreterRef = interpreterManager.getInterpreterRef();
            if (interpreterRef.isConstantRef()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
                    NodeJsInterpreter interpreter;
                    if (!project.isDisposed() && !NodeJsRemoteInterpreterType.getInstance().isRemoteReference(interpreterRef) && (interpreter = interpreterRef.resolveWithoutAliases(project)) instanceof NodeJsLocalInterpreter && !((NodeJsLocalInterpreter)interpreter).isValid()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            boolean clonedFromDefaultProject = interpreterManager.isClonedFromDefaultProject();
                            LOG.info("Invalid project interpreter " + interpreterRef.getReferenceName() + ", updated to 'node', clonedFromDefaultProject: " + clonedFromDefaultProject);
                            NodeJsInterpreterManagerStartupActivity.updateProjectInterpreterRef(project, !clonedFromDefaultProject);
                        }, project.getDisposed());
                    }
                }));
            }
        }, (ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed());
    }

    private static void updateProjectInterpreterRef(@NotNull Project project, boolean showNotification) {
        if (project == null) {
            NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager.getInstance(project).setInterpreterRef(NodeJsLocalInterpreterType.createNodeFromPathRef());
        if (showNotification) {
            Notification notification = NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("node.js.invalid.node", SystemInfo.isWindows ? "%Path%" : "$PATH"), NotificationType.INFORMATION);
            notification.addAction((AnAction)DumbAwareAction.create((String)CommonBundle.message((String)"button.ok", (Object[])new Object[0]), event -> notification.expire()));
            notification.addAction((AnAction)DumbAwareAction.create((String)JavaScriptBundle.message("node.js.configure", new Object[0]), event -> {
                notification.expire();
                NodeSettingsConfigurable.showSettingsDialog(project);
            }));
            notification.notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManagerStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProjectInterpreterRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

